/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.printCompilerError=exports.getCompilerOptions=exports.getFiles=exports.getTsProgram=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),fs=require("fs"),path=require("path"),ts=require("typescript");function getAccessibleFileSystemEntries(e){try{const t=fs.readdirSync(e||".").sort(),r=[],s=[];return t.forEach(t=>{if("."===t||".."===t||".png"===path.extname(t))return;const i=ts.combinePaths(e,t);let o;try{o=fs.statSync(i)}catch(e){return}if(o.isFile())r.push(t);else if(o.isDirectory())s.push(t)}),{files:r,directories:s}}catch(e){return{files:[],directories:[]}}}const getTsProgram=(e,t)=>{const r=(0,exports.getFiles)(e,t);return ts.createProgram(r,(0,exports.getCompilerOptions)(e,t?.configFileName||"tsconfig.json",t?.tsconfigOverride))};exports.getTsProgram=getTsProgram;const getFiles=(e,t)=>{const r=path.resolve(e,t?.configFileName||"tsconfig.json"),{include:s,exclude:i,extends:o}=JSON.parse(fs.readFileSync(r,"utf8"));return ts.matchFiles(e,o,t?.excludeOverride||i,t?.includeOverride||s.filter(e=>!e.endsWith(".json")),true,process.cwd(),void 0,getAccessibleFileSystemEntries,ts.sys.realpath)};exports.getFiles=getFiles;const getCompilerOptionsFromTsConfig=(e,t)=>{const r=ts.readConfigFile(e,ts.sys.readFile),s=ts.parseJsonConfigFileContent(r.config,ts.sys,t||path.dirname(e));return s.options.configFilePath=e,s},getCompilerOptions=(e,t="tsconfig.json",r)=>{const s=path.resolve(e,t),i=path.resolve(e,"build");let o={};try{o=getCompilerOptionsFromTsConfig(s).options}catch(e){}const n={module:ts.ModuleKind.CommonJS,moduleResolution:ts.ModuleResolutionKind.NodeJs,target:ts.ScriptTarget.ES2022,outDir:i,rootDir:path.resolve(e),baseUrl:path.resolve(e),experimentalDecorators:true,declaration:true,declarationMap:true,composite:true,sourceMap:true,stripInternal:true,watch:false,noUnusedLocals:false,noImplicitAny:true,noImplicitThis:true,strictNullChecks:true,useDefineForClassFields:false,skipLibCheck:true,...r};return{...o,...n}};exports.getCompilerOptions=getCompilerOptions;const printCompilerError=e=>t=>{if(t.file&&t.start){(0,xtrem_cli_lib_1.addTsDiagnosticToDispatchQueue)(t,"server");const{line:r,character:s}=t.file.getLineAndCharacterOfPosition(t.start),i=ts.flattenDiagnosticMessageText(t.messageText,"\n").trim();(0,xtrem_cli_lib_1.printWarning)(e,`${t.file.fileName} (${r+1},${s+1}): ${i}`)}else(0,xtrem_cli_lib_1.printWarning)(e,`${ts.flattenDiagnosticMessageText(t.messageText,"\n").trim()}`)};exports.printCompilerError=printCompilerError;
//# sourceMappingURL=server-compilation.js.map