/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.pageMetadataTransformer=exports.PageMetadataBuilder=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_i18n_1=require("@sage/xtrem-i18n"),fs=require("fs"),lodash_1=require("lodash"),path=require("path"),ts=require("typescript"),isPageAction=e=>"ui.PageAction"===e;class PageMetadataBuilder{static isSourceFile(e){const t=path.parse(e.fileName).base;return!["index.ts","_index.ts"].includes(t)&&-1===e.fileName.indexOf("node_modules")&&Boolean(e.fileName.match(/(\/|\\)lib(\/|\\)/))}static{this.getValueFromObjectLiteralByKey=(e,t,i)=>{const a=t.properties&&t.properties.find(t=>t.name&&t.name.getText(e)===i),r=a?.initializer;if(r){if(r.kind===ts.SyntaxKind.TrueKeyword)return true;if(r.kind===ts.SyntaxKind.FalseKeyword)return false;if(ts.isStringLiteral(r))return r.text;if(ts.isNumericLiteral(r))return Number(r.text)}return}}static{this.getStringValueFromObjectLiteralByKey=(e,t,i)=>PageMetadataBuilder.getValueFromObjectLiteralByKey(e,t,i)}static{this.getBooleanValueFromObjectLiteralByKey=(e,t,i)=>PageMetadataBuilder.getValueFromObjectLiteralByKey(e,t,i)}static{this.getNumberValueFromObjectLiteralByKey=(e,t,i)=>PageMetadataBuilder.getValueFromObjectLiteralByKey(e,t,i)}static{this.getTsNodeText=(e,t)=>t.getText(e)}static getLineAndCharacterOfTsNode(e,t){return e.getLineAndCharacterOfPosition(t.pos)}static getLocation(e,t){return`${e.fileName}:${PageMetadataBuilder.getLineAndCharacterOfTsNode(e,t).line+1}`}static{this.getAccessBindingFromObjectLiteralExpression=(e,t,i)=>({node:PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"node")||i,bind:PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"bind")})}static{this.getComponentAttributes=(e,t,i)=>{const findAccessBindingProperty=i=>{if(!t.properties)return;return t.properties.find(t=>t.name&&t.name.getText(e)===i)},a=findAccessBindingProperty("access"),r=findAccessBindingProperty("extensionAccessBinding");return{access:a&&a.initializer&&ts.isObjectLiteralExpression(a.initializer)&&PageMetadataBuilder.getAccessBindingFromObjectLiteralExpression(e,a.initializer,i)||void 0,extensionAccess:r&&r.initializer&&ts.isObjectLiteralExpression(r.initializer)&&PageMetadataBuilder.getAccessBindingFromObjectLiteralExpression(e,r.initializer,i)||void 0,node:PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"node")||i,bind:PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"bind"),valueField:PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"valueField"),tunnelPage:PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"tunnelPage"),fragment:PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"fragment"),helperTextField:PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"helperTextField"),isTransient:PageMetadataBuilder.getBooleanValueFromObjectLiteralByKey(e,t,"isTransient")}}}static{this.resolvedBinding=(e,t,i)=>({node:e.access?.node||t||i,bind:e.access?.bind||e.bind||"$read"})}static{this.getAuthorizationCodeFromObjectLiteralExpression=(e,t)=>PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"authorizationCode")}static{this.getCategoryFromObjectLiteralExpression=(e,t)=>PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"category")}static{this.getGroupFromObjectLiteralExpression=(e,t)=>PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"group")}static{this.getDescriptionFromObjectLiteralExpression=(e,t)=>PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"description")}static{this.getListIconFromObjectLiteralExpression=(e,t)=>PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"listIcon")}static{this.getExtendsFromObjectLiteralExpression=(e,t)=>PageMetadataBuilder.getStringValueFromObjectLiteralByKey(e,t,"extends")}static{this.getPriorityFromObjectLiteralExpression=(e,t)=>PageMetadataBuilder.getNumberValueFromObjectLiteralByKey(e,t,"priority")}static{this.resolveMenuItem=(e,t,i,a,r)=>{if(a.startsWith(".")){const s=path.resolve(path.dirname(e.fileName),a).replace(`${t}${path.sep}`,""),n=path.resolve(i,s);return require(n)[r]}return require(require.resolve(a,{paths:[t]}))[r]}}static{this.visitor=(e,t,i,a,r,s,n,o)=>l=>{const d=PageMetadataBuilder.getComponentAttributes(e,l);if(d?.node)n.push(d?.node);if(d?.access?.node)n.push(d?.access?.node);if(ts.isPropertyDeclaration(l)){const t=ts.getDecorators(l)?.[0],i=t&&ts.isCallExpression(t.expression)?t.expression:void 0,a=i&&ts.isObjectLiteralExpression(i.arguments[0])?i.arguments[0]:void 0,s=a?PageMetadataBuilder.getComponentAttributes(e,a):void 0;if(s?.node)n.push(s?.node);if(s?.access?.node)n.push(s?.access?.node);const o=PageMetadataBuilder.getTsNodeText(e,l.name),d=l.type&&ts.isTypeReferenceNode(l.type)&&PageMetadataBuilder.getTsNodeText(e,l.type.typeName)||"";if(o&&isPageAction(d))if(/Action$/.test(o))throw new xtrem_core_1.LogicError(`Page action name '${o}' must not end with 'Action'. Do you mean '${o.slice(0,-6)}'? at ${PageMetadataBuilder.getLocation(e,l.name)}`);if(i&&a&&i.getText(e).includes(".pluginField<"))a.properties.filter(t=>"pluginPackage"===t.name?.getText(e)).forEach(e=>{if(ts.isStringLiteral(e.initializer)&&!r.includes(e.initializer.text))r.push(e.initializer.text)})}if(d?.fragment)s.push(d.fragment);return ts.visitEachChild(l,PageMetadataBuilder.visitor(e,t||"",i||{},d?.node||a||"",r,s,n,o),o)}}}function pageMetadataTransformer(e){return t=>{if(!PageMetadataBuilder.isSourceFile(t))return t;const i=[],a=(t.statements.filter(ts.isClassDeclaration)||[]).pop();if(!a)return t;const r=ts.getDecorators(a)?.[0];if(!(r&&ts.isCallExpression(r.expression)))return t;try{const s=r.expression;let n;if(s.arguments&&s.arguments.length>0&&ts.isObjectLiteralExpression(s.arguments[0])){const r=s.arguments[0],o=a.name?.getText(t);if(!o)throw new xtrem_core_1.LogicError("page class does not have a name");const l=PageMetadataBuilder.getAuthorizationCodeFromObjectLiteralExpression(t,r),d=PageMetadataBuilder.getCategoryFromObjectLiteralExpression(t,r),c=PageMetadataBuilder.getGroupFromObjectLiteralExpression(t,r),g=PageMetadataBuilder.getExtendsFromObjectLiteralExpression(t,r),u=PageMetadataBuilder.getListIconFromObjectLiteralExpression(t,r),m=PageMetadataBuilder.getDescriptionFromObjectLiteralExpression(t,r),p=[],x=[],B=PageMetadataBuilder.getComponentAttributes(t,r),f=PageMetadataBuilder.resolvedBinding(B,B.node,B.node);if(B.node)i.push(B.node);let y;n=f.node;const b=B.extensionAccess;if(f.node)i.push(f.node),y=f;ts.visitNode(t,PageMetadataBuilder.visitor(t,n||"",B,"",p,x,i,e));const h={authorizationCode:l,category:d,className:o,description:m,extends:g,extensionAccess:b,fragments:x,group:c,listIcon:u,md5:(0,xtrem_cli_lib_1.hashFile)(t.fileName),nodes:(0,lodash_1.uniq)(i),pageAccess:y,pageNode:B.node,plugins:p};if(ts.isCallExpression(s)&&ts.isPropertyAccessExpression(s.expression))h.type=s.expression.name.getText(t);const P=(0,xtrem_i18n_1.getPackageNameAndRoot)(t.fileName),L=path.resolve(P.root,"package.json"),F=require(L),M=(0,lodash_1.pick)(F,"main","name"),O=path.dirname(path.resolve(P.root,M.main)),j=r.properties.find(e=>"menuItem"===e.name.getText(t));if(j){const e=j?.initializer.getText(t),i=t.statements.find(i=>ts.isImportDeclaration(i)&&i.importClause?.namedBindings&&ts.isNamedImports(i.importClause?.namedBindings)&&i.importClause?.namedBindings.elements.find(i=>i.getText(t)===e)).moduleSpecifier.getText(t),a=PageMetadataBuilder.resolveMenuItem(t,P.root,O,(0,lodash_1.trim)(i,"'"),e);h.parentMenuItem=a.id,h.priority=PageMetadataBuilder.getPriorityFromObjectLiteralExpression(t,r)}const _=(0,xtrem_cli_lib_1.getMetadataFilePathForClientFile)(P.root,t.fileName);(0,xtrem_cli_lib_1.mkdirp)(path.dirname(_));const E=fs.existsSync(_)?{...JSON.parse(fs.readFileSync(_,"utf-8")),...h}:h;fs.writeFileSync(_,JSON.stringify(E,null,4),"utf-8")}return t}catch(e){if(e instanceof xtrem_core_1.LogicError)throw new Error(`${t.fileName}: ${e.message}`);return(0,xtrem_cli_lib_1.printWarning)(xtrem_cli_lib_1.ExecutionMode.STANDALONE,`${t.fileName}: Page access transformer failed due to the following error: ${e}`),t}}}exports.PageMetadataBuilder=PageMetadataBuilder,exports.pageMetadataTransformer=pageMetadataTransformer;
//# sourceMappingURL=page-metadata-transformer.js.map