/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.defaultElasticMq=exports.requiredQueues=exports.updateElasticMqConfigFile=exports.getAllElasticMqConfigs=exports.getRoutingFilePath=exports.getRoutingData=exports.sortRoutesByTopic=exports.mergeRoutings=void 0;const xtrem_core_1=require("@sage/xtrem-core"),fs=require("fs"),_=require("lodash"),fsp=require("path"),logger=require("./logger");function mergeRoutings(e,t){return sortRoutesByTopic(_.mergeWith(e,t,mergeRoutes))}function mergeRoutes(e,t){return _.unionWith(e,t,_.isEqual)}function sortRoutesByTopic(e){return Object.keys(e).forEach(t=>{e[t].sort((e,t)=>e.topic.localeCompare(t.topic))}),e}function getRoutingData(e){logger.info(`Getting data from file ${e}`);const t=fs.readFileSync(e,"utf-8");return JSON.parse(t)}function getRoutingFilePath(e){return fsp.join(e,"routing.json")}function getQueues(e){const t=new Set;return Object.values(e).forEach(e=>{_.uniq(e.map(e=>e.queue)).forEach(e=>t.add(e))}),[...t]}exports.mergeRoutings=mergeRoutings,exports.sortRoutesByTopic=sortRoutesByTopic,exports.getRoutingData=getRoutingData,exports.getRoutingFilePath=getRoutingFilePath;const defaultVisibilityTimeout="30 seconds",delay="0 seconds",receiveMessageWait="0 seconds",fifo="true",deadLetterQueueName="dev-dead-letter-queue";function elasticQueueConfig(e){const t=e===deadLetterQueueName?void 0:{name:deadLetterQueueName,maxReceiveCount:5};return{[e]:{defaultVisibilityTimeout,delay,receiveMessageWait,fifo,deadLetterQueue:t}}}function getAllElasticMqConfigs(e,t,i,o){const s={...getQueues(t).reduce((e,t)=>({...e,...elasticQueueConfig(xtrem_core_1.Application.limitSqsQueueName(i?`test-${i}-${t}`:t))}),{}),...o};if(!i){let t=e.dir.split("/").at(-3);if("services"===t)t="sdmo";else if("tools"===t)t=e.dir.split("/").at(-2);Object.keys(s).forEach(e=>{if(!t)throw new xtrem_core_1.LogicError("Application directory does not match expected format");if(!e.startsWith(`${t}--`))s[xtrem_core_1.Application.limitSqsQueueName(`${t}--${e}`)]=s[e]})}return s}function sortElasticMqConfigs(e){const t=Object.keys(e).sort((e,t)=>e.localeCompare(t));return _.pick(e,t)}function writeElasticMqConfigFile(e,t){const i=`${'include classpath("application.conf")'}\n\nqueues ${JSON.stringify(sortElasticMqConfigs(t),null,"\t").replace(/: \{/g," {").replace(/:/g," =").replace(/[",]/g,"")}\n`;fs.writeFileSync(e,i,"utf-8")}function readElasticMqConfigFile(e){if(!fs.existsSync(e))return{};let t=fs.readFileSync(e,"utf-8").replace(/^include.*/,"").replace(/\nqueues\s+{/,"{").replace(/(\n\t+)((?:\w|-)+) \{/g,'$1"$2": {').replace(/(\n\t+)((?:\w|-)+) = (.*)/g,'$1"$2": "$3",').replace(/([}"])\n/g,"$1,\n").replace(/,(\n\t*)\}/g,"$1}").trimEnd();if(","===t.slice(-1))t=t.slice(0,-1);return JSON.parse(t)}function updateElasticMqConfigFile(e,t){const i=readElasticMqConfigFile(e);writeElasticMqConfigFile(e,_.merge(i,t))}exports.getAllElasticMqConfigs=getAllElasticMqConfigs,exports.updateElasticMqConfigFile=updateElasticMqConfigFile,exports.requiredQueues=["infrastructure-event","intacctReceive"].reduce((e,t)=>({...e,...elasticQueueConfig(t)}),{}),exports.defaultElasticMq={queues:{...elasticQueueConfig(deadLetterQueueName),...elasticQueueConfig("demo-queue"),...exports.requiredQueues,...elasticQueueConfig("unit-test-message-queue"),...elasticQueueConfig("unit-test-notification-queue"),...elasticQueueConfig("unit-test-visibility-multiple-listeners-queue")}};
//# sourceMappingURL=routing.js.map