/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.RoutingBuilder=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),fs=require("fs"),_=require("lodash"),path=require("path"),ts=require("typescript"),logger=require("./logger"),routing_1=require("./routing");class RoutingBuilder{#e;#t;#i;#r;#n;#s;#a;constructor(e){this.rootDir=e,this.packageJson=this.getPackageJson(),this.mutationNames=[],this.#r="",this.#n="",this.#a=false;const t=this.rootDir||process.cwd();this.routingFilename=(0,routing_1.getRoutingFilePath)(t),this.#e={[this.packageName]:RoutingBuilder.readRoutingData(this.routingFilename)[this.packageName]||[]}}get packageName(){return(0,xtrem_core_1.getPackageName)(this.packageJson)}get queue(){if(!this.#t)this.#t=this.getPackageQueueName();return this.#i??this.#t}get routing(){return this.#e}get filename(){return this.#n}get filePath(){return this.#r}setVisitingFile(e){this.#r=e,this.#n=path.basename(e),this.setVisitingNodeDecorator(void 0)}get nodeQueueName(){return this.#i}set nodeQueueName(e){this.#i=e}get node(){return this.#s}setVisitingNodeDecorator(e){this.#s=e,this.#i=void 0;const{filename:t,mutationNames:i}=this;if(!e)return;if(!ts.isCallExpression(e.expression))throw new Error(`${t}: expected CallExpression, got ${ts.SyntaxKind[e.expression.kind]}`);const r=e.expression.arguments[0];if(!r||!ts.isObjectLiteralExpression(r))throw new Error(`${t}: expected ObjectLiteralExpression, got ${r&&ts.SyntaxKind[r.kind]}`);r.properties.forEach(e=>{if(ts.isPropertyAssignment(e)&&ts.isIdentifier(e.name)){const t=e.name;if(e.initializer.kind===ts.SyntaxKind.TrueKeyword){const e=/^canBulk(Delete|Update)$/.exec(t.escapedText.toString());if(e)i.push(`bulk${e[1]}`)}if(ts.isStringLiteral(e.initializer)&&"queue"===t.escapedText)this.#i=e.initializer.text}})}static readRoutingData(e){if(!fs.existsSync(e))return{};const t=fs.readFileSync(e,"utf-8");return JSON.parse(t)}getPackageQueueName(){return(0,xtrem_core_1.getPackageQueueName)(this.packageJson)}getPackageJson(){const{rootDir:e,routingFilename:t}=this,i=e||RoutingBuilder.getPackageRootDir(t),r=path.join(i,"package.json");if(!fs.existsSync(r))throw new Error(`package.json not found, rootDir: ${e}, fileName: ${t}`);const n=fs.readFileSync(r,"utf-8");return JSON.parse(n)}static getPackageRootDir(e){let t=path.dirname(e),i=path.join(t,"package.json");for(;"/"!==t&&!fs.existsSync(i);)t=path.join(t,".."),i=path.join(t,"package.json");return t}createListener(e){const{packageName:t,filePath:i,queue:r}=this,n={fileName:i,packageName:t,queue:r,topic:""};return e.arguments[0].properties.forEach(e=>{const t=e.name;if("queue"===t.escapedText)n.queue=RoutingBuilder.getQueue(e);else if("topic"===t.escapedText)n.topic=RoutingBuilder.getTopic(e)}),n}createAsyncMutationListener(e){const{filePath:t}=this,i=e.parent.parent;if(!ts.isMethodDeclaration(i))throw new Error(`${t}: expected MethodDeclaration, got ${ts.SyntaxKind[i.kind]}`);if(!ts.isIdentifier(i.name))throw new Error(`${t}: expected Identifier, got ${ts.SyntaxKind[i.name.kind]}`);const r=i.parent;if(!ts.isClassDeclaration(r))throw new Error(`${t}: expected ClassDeclaration, got ${ts.SyntaxKind[r.kind]}`);return this.createAsyncMutationListenerObject(r,i.name.text,RoutingBuilder.getAsyncMutationQueueName(i))}createAsyncMutationListenerObject(e,t,i){const{packageName:r,filePath:n}=this;return{fileName:n,packageName:r,queue:i??this.queue,topic:`${RoutingBuilder.getAsyncMutationClassName(n,e)}/${t}/start`}}static getQueue(e){if(ts.isPropertyAssignment(e)&&ts.isArrowFunction(e.initializer))return e.initializer.body.getText().split(".").pop();return""}static getTopic(e){if(ts.isPropertyAssignment(e)&&ts.isStringLiteral(e.initializer))return e.initializer.text;return""}updateRouting(e){const{routing:t,filename:i}=this,r={..._.pick(e,["topic","queue"]),sourceFileName:i},n=e.packageName;if(!t[n]||!RoutingBuilder.isRouteInList(r,t[n]))logger.info(`New route found: (topic: ${r.topic}, queue: ${r.queue})`),t[n].push(r),this.#a=true}static isRouteInList(e,t){return null!=_.find(t,e)}writeRoutingData(){if(!this.#a)return;const{routing:e,routingFilename:t}=this;(0,routing_1.sortRoutesByTopic)(e),fs.writeFileSync(t,JSON.stringify(e,null,4),"utf-8"),this.#a=false}static getAsyncMutationClassName(e,t){if(!t.name)throw new Error(`${e}: no name on node class declaration`);const i=ts.getDecorators(t)?.[0]?.expression;if(!(i&&ts.isCallExpression(i)&&ts.isObjectLiteralExpression(i.arguments[0])))throw new Error(`${e}: invalid node class: decorator not found`);const r=i.arguments[0].properties.find(e=>e.name&&ts.isIdentifier(e.name)&&"extends"===e.name.text);if(!r)return t.name.text;if(ts.isPropertyAccessExpression(i.expression)&&"subNode"===i.expression.name.text)return t.name.text;const n=r&&ts.isPropertyAssignment(r)&&ts.isArrowFunction(r.initializer)&&r.initializer;if(!n)throw new Error(`${e}: extends attribute is not an arrow function`);if(ts.isIdentifier(n.body))return n.body.text;if(ts.isPropertyAccessExpression(n.body)&&ts.isIdentifier(n.body.name))return n.body.name.text;throw new Error(`${e}: unexpected expression in extends decorator attribute`)}static getAsyncMutationQueueName(e){if(!e.modifiers||0===e.modifiers.length)return;const t=e.modifiers.map(e=>{if(!ts.isDecorator(e))return null;if(!ts.isCallExpression(e.expression))return null;if(!ts.isPropertyAccessExpression(e.expression.expression))return null;if(!/asyncMutation|bulkMutation/.test(e.expression.expression.name.text))return null;if(1!==e.expression.arguments.length)return null;const t=e.expression.arguments[0];if(!ts.isObjectLiteralExpression(t))return null;const i=t.properties.map(e=>{if(!ts.isPropertyAssignment(e))return null;if(!e.name)return null;if(!ts.isIdentifier(e.name))return null;if("queue"!==e.name.text)return null;if(!ts.isStringLiteral(e.initializer))return null;return e.initializer.text}).filter(e=>e);if(0===i.length)return null;return i[0]}).filter(e=>e);if(0===t.length)return;return t[0]}createListeners(){this.mutationNames.forEach(e=>{const t=this.createStandardBulkMutationListener(e);this.updateRouting(t)});const e=this.createAsyncExportMutationListener();if(e)this.updateRouting(e);this.writeRoutingData()}createStandardBulkMutationListener(e){const{node:t,filePath:i}=this;if(!t)throw new Error(`${i}: no current node decorator`);const r=t.parent;if(!ts.isClassDeclaration(r))throw new Error(`${i}: expected ClassDeclaration, got ${ts.SyntaxKind[r.kind]}`);return this.createAsyncMutationListenerObject(r,e,this.nodeQueueName)}createAsyncExportMutationListener(){const{node:e,filePath:t}=this;if(!e)throw new Error(`${t}: no current node decorator`);const i=this.filename,r=(0,xtrem_shared_1.canExportNodeDecorator)(t,e);if(!(0,xtrem_shared_1.isAbstractNodeDecorator)(i,e)&&r){const i=e.parent;if(!ts.isClassDeclaration(i))throw new Error(`${t}: expected ClassDeclaration, got ${ts.SyntaxKind[i.kind]}`);return this.createAsyncMutationListenerObject(i,"asyncExport","import-export")}return}}exports.RoutingBuilder=RoutingBuilder;
//# sourceMappingURL=routing-builder.js.map