import { PackageJsonFile } from '@sage/xtrem-core';
import * as ts from 'typescript';
import { Routing } from './routing';
export interface Listener {
    fileName: string;
    packageName: string;
    queue: string;
    topic: string;
}
export declare class RoutingBuilder {
    #private;
    private readonly rootDir;
    readonly routingFilename: string;
    readonly packageJson: PackageJsonFile;
    private readonly mutationNames;
    constructor(rootDir: string | undefined);
    get packageName(): string;
    get queue(): string;
    get routing(): Routing;
    get filename(): string;
    get filePath(): string;
    setVisitingFile(filePath: string): void;
    get nodeQueueName(): string | undefined;
    set nodeQueueName(queueName: string | undefined);
    get node(): ts.Decorator | undefined;
    setVisitingNodeDecorator(node: ts.Decorator | undefined): void;
    private static readRoutingData;
    private getPackageQueueName;
    private getPackageJson;
    private static getPackageRootDir;
    createListener(node: ts.CallExpression): Listener;
    createAsyncMutationListener(node: ts.CallExpression): Listener;
    createAsyncMutationListenerObject(classDeclaration: ts.ClassDeclaration, name: string, 
    /**
     * Override of the default queue name (by default, the queue name is based on the package name)
     */
    queueNameOverride?: string): Listener;
    private static getQueue;
    private static getTopic;
    updateRouting(listener: Listener): void;
    private static isRouteInList;
    writeRoutingData(): void;
    private static getAsyncMutationClassName;
    /**
     * Retrieve (if defined) the 'queue' parameter set in the decorator of the asyncMutation
     */
    private static getAsyncMutationQueueName;
    createListeners(): void;
    createStandardBulkMutationListener(name: string): Listener;
    createAsyncExportMutationListener(): Listener | undefined;
}
//# sourceMappingURL=routing-builder.d.ts.map