/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.createMochaRunner=exports.setupTestSuite=exports.mochaErrors=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai"),chaiAsPromised=require("chai-as-promised"),fs=require("fs"),Mocha=require("mocha"),path=require("path"),yargs=require("yargs"),mocha_reporter_1=require("./mocha-reporter");(0,chai_1.use)(chaiAsPromised);const setupTestSuite=async()=>{if(null!=xtrem_core_1.Test.application)return void(0,xtrem_cli_lib_1.printWarning)(xtrem_cli_lib_1.ExecutionMode.STANDALONE,"Test application already set");const e=process.env.APPLICATION_DIR??process.cwd();xtrem_core_1.ConfigManager.load(e,"test");const r={api:await(0,xtrem_cli_lib_1.withTiming)(xtrem_cli_lib_1.ExecutionMode.STANDALONE,{body:()=>require(path.join(e,"build/index.js")),success:()=>`Required modules from ${e}`}),buildDir:path.join(path.join(e,"build"))};process.env.XTREM_USE_TEST_APPLICATION="1",xtrem_core_1.Test.application=await(0,xtrem_cli_lib_1.withTiming)(xtrem_cli_lib_1.ExecutionMode.STANDALONE,{body:()=>xtrem_core_1.Test.createTestApplication(r),success:()=>"application created"});const t=path.join(e,"build/test/fixtures/before-test");if(fs.existsSync(`${t}.js`)){const e=require(t);if(e.beforeTest)await(0,xtrem_cli_lib_1.withTiming)(xtrem_cli_lib_1.ExecutionMode.STANDALONE,{body:()=>e.beforeTest(),success:()=>`running beforeTest from ${t}`})}const i=yargs.argv;if(i.allServiceOptions)xtrem_core_1.Test.cliActiveServiceOptions=Object.values(xtrem_core_1.Test.application.serviceOptionsByName);else if(i.serviceOptions)xtrem_core_1.Test.cliActiveServiceOptions=i.serviceOptions.split(",").map(e=>xtrem_core_1.Test.application.findServiceOption(e))};exports.setupTestSuite=setupTestSuite;const createMochaRunner=(e,r,t)=>{exports.mochaErrors={};const i=require(path.resolve(r,"package.json"));let o;if(t)o="mocha-junit-reporter";else o="spec";if("custom"===process.env.REPORTER)o=mocha_reporter_1.MochaTestReporter;const getTimeout=()=>{const r=yargs.argv;if(r.noTimeout)return(0,xtrem_cli_lib_1.printWarning)(e,"--noTimeout set : timeout is disabled."),false;if(r.timeout)return(0,xtrem_cli_lib_1.printWarning)(e,`timeout forced to ${r.timeout} ms`),r.timeout;return false};return new Mocha({color:true,ui:"",ignoreLeaks:false,timeout:xtrem_cli_lib_1.isDebugging?false:getTimeout(),reporter:o,fullStackTrace:true,reporterOptions:t?{junit_report_name:i.description,junit_report_path:path.resolve(r,`junit-report-${i.name.replace("/","-").replace("@","")}.xml`)}:void 0})};exports.createMochaRunner=createMochaRunner;
//# sourceMappingURL=mocha.js.map