import { AnyValue, Dict, TestOptions } from '@sage/xtrem-core';
import { GraphQLSchema } from 'graphql';
type ExecutionModeType = 'only' | 'skip' | 'normal';
interface Parameters {
    [key: string]: {
        input?: object;
        output: object;
        variables?: Dict<AnyValue>;
        envConfigs?: TestOptions;
        layers: string[];
        mocks?: string[];
        executionMode?: ExecutionModeType;
    };
}
interface TestScenarioInput {
    parameters: Parameters;
    scenario: string;
    requestHbs: string;
    schema: GraphQLSchema;
    responseHbs: string;
    directory: string;
}
/**
 * Runs a test scenario, i.e. any key defined in 'parameters.json'.
 *
 * @export
 * @param {TestScenarioInput} {
 *     parameters,
 *     scenario,
 *     applicationDir,
 *     requestHbs,
 *     schema,
 *     responseHbs,
 *     directory,
 * }
 */
export declare function runScenario({ parameters, scenario, requestHbs, schema, responseHbs, directory, }: TestScenarioInput): Promise<void>;
export {};
//# sourceMappingURL=graphql-tests-entry-point.d.ts.map