/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.decimalTransformer=void 0;const ts=require("typescript"),tsf=ts.factory;function isDecimalLiteral(e){return/^[+-]?(?:\.\d+|\d+\.\d*)$/.test(e)}function decimalTransformer(e){let t,typesLib=null;function createIdentifier(e){return typesLib=typesLib||tsf.createIdentifier("typesLib"),tsf.createIdentifier(e?`${typesLib.text}.${e}`:typesLib.text)}function createFunction(e,t=false){switch(e){case ts.SyntaxKind.LessThanToken:return createIdentifier("lt");case ts.SyntaxKind.GreaterThanToken:return createIdentifier("gt");case ts.SyntaxKind.LessThanEqualsToken:return createIdentifier("lte");case ts.SyntaxKind.GreaterThanEqualsToken:return createIdentifier("gte");case ts.SyntaxKind.EqualsEqualsToken:return createIdentifier("eq");case ts.SyntaxKind.EqualsEqualsEqualsToken:return createIdentifier("strictEq");case ts.SyntaxKind.ExclamationEqualsToken:return createIdentifier("ne");case ts.SyntaxKind.ExclamationEqualsEqualsToken:return createIdentifier("strictNe");case ts.SyntaxKind.PlusToken:return createIdentifier(t?"plus":"add");case ts.SyntaxKind.MinusToken:return createIdentifier(t?"negated":"sub");case ts.SyntaxKind.AsteriskToken:return createIdentifier("mul");case ts.SyntaxKind.SlashToken:return createIdentifier("div");default:return}}function fromAssignment(e){switch(e){case ts.SyntaxKind.PlusEqualsToken:return createFunction(ts.SyntaxKind.PlusToken);case ts.SyntaxKind.MinusEqualsToken:return createFunction(ts.SyntaxKind.MinusToken);case ts.SyntaxKind.AsteriskEqualsToken:return createFunction(ts.SyntaxKind.AsteriskToken);case ts.SyntaxKind.SlashEqualsToken:return createFunction(ts.SyntaxKind.SlashToken);case ts.SyntaxKind.PlusPlusToken:return createFunction(ts.SyntaxKind.PlusToken);case ts.SyntaxKind.MinusMinusToken:return createFunction(ts.SyntaxKind.MinusToken);default:return}}const n=function visit(n){const nodeKey=e=>`${e.pos}~${e.end}`,r=ts.visitEachChild(n,visit,e);if(r.kind===ts.SyntaxKind.BinaryExpression){const e=r;let t=createFunction(e.operatorToken.kind);if(t)return tsf.createCallExpression(t,void 0,[e.left,e.right]);if(t=fromAssignment(e.operatorToken.kind),t)return tsf.createAssignment(tsf.createIdentifier(e.left.getText()),tsf.createCallExpression(t,void 0,[e.left,e.right]))}else if(r.kind===ts.SyntaxKind.NumericLiteral){const e=r;if(isDecimalLiteral(e.getText()))return tsf.createCallExpression(createIdentifier("newDecimal"),void 0,[tsf.createStringLiteral(`${e.getText()}`)])}else if(r.kind===ts.SyntaxKind.PrefixUnaryExpression){const e=r;if(!((e.operator===ts.SyntaxKind.MinusToken||e.operator===ts.SyntaxKind.PlusToken)&&e.operand.kind===ts.SyntaxKind.NumericLiteral&&!isDecimalLiteral(e.operand.getText()))){let t=createFunction(e.operator,true);if(t)return tsf.createCallExpression(t,void 0,[e.operand]);if(t=fromAssignment(e.operator),t)return tsf.createParenthesizedExpression(tsf.createAssignment(tsf.createIdentifier(e.operand.getText()),tsf.createCallExpression(t,void 0,[e.operand,tsf.createNumericLiteral(1)])))}}else if(r.kind===ts.SyntaxKind.Block&&t[nodeKey(r)]){const e=r,t=tsf.createExpressionStatement(tsf.createIdentifier("var _v"));return tsf.updateBlock(e,tsf.createNodeArray([t,...e.statements]))}else if(r.kind===ts.SyntaxKind.PostfixUnaryExpression){const e=r,n=fromAssignment(e.operator);if(n){let s=r.parent;for(;s;){if(s.kind===ts.SyntaxKind.Block)return t[nodeKey(s)]=true,tsf.createComma(tsf.createComma(tsf.createAssignment(tsf.createIdentifier("_v"),tsf.createIdentifier(e.operand.getText())),tsf.createAssignment(tsf.createIdentifier(e.operand.getText()),tsf.createCallExpression(n,void 0,[e.operand,tsf.createNumericLiteral(1)]))),tsf.createIdentifier("_v"));s=s.parent}}}else if(r.kind===ts.SyntaxKind.Identifier){const e=r;if("Math"===e.getText()){const t=e.parent.getText();if(/Math\.(?:abs|ceil|floor|max|min|pow|round)$/.test(t))return createIdentifier()}}return r};return e=>{typesLib=null,t={};const r=ts.visitNode(e,n);if(null==typesLib)return r;const s=tsf.createImportDeclaration(void 0,tsf.createImportClause(true,typesLib,tsf.createNamespaceImport(typesLib)),tsf.createStringLiteral("@sage/xtrem-decimal"));return tsf.updateSourceFile(r,[s,...r.statements])}}exports.decimalTransformer=decimalTransformer,exports.default=decimalTransformer;
//# sourceMappingURL=decimal-transformer.js.map