import { ExecutionMode, PackagingMode } from '@sage/xtrem-cli-lib';
import { Observable } from 'rxjs';
import * as webpack from 'webpack';
export declare const compileClientAndSharedFunctions: (executionMode: ExecutionMode, dir: string) => void;
export declare const checkTypesOnClientArtifactsAndBuildDeclarations: (executionMode: ExecutionMode, dir: string) => void;
export declare const filterExternals: ({ request }: any) => Promise<string | void>;
export declare const isCompilable: (filePath: string) => boolean;
export declare const getWebpackEntry: (executionMode: ExecutionMode, dir: string, isOnlyChanged: boolean) => (() => webpack.Entry);
interface CompileInput {
    executionMode: ExecutionMode;
    buildDir: string;
    isProd: boolean;
    isInstrumented: boolean;
    isFast?: boolean;
    isWatch?: boolean;
    isOnlyChanged?: boolean;
}
export declare const compilePagesAndStickers: ({ executionMode, buildDir, isProd, isInstrumented, isWatch, isOnlyChanged, }: CompileInput) => Observable<WebpackResult>;
interface WebpackInput {
    buildDir: string;
    entry: () => webpack.Entry;
    output: webpack.Configuration['output'];
    packagingMode?: PackagingMode;
    isInstrumented: boolean;
    options?: webpack.Configuration;
}
export declare const compileFiles: ({ buildDir, entry, output, packagingMode, isInstrumented, options, }: WebpackInput) => Observable<WebpackResult>;
export type WebpackResult = {
    stats: webpack.Stats | undefined | null;
    error: Error | undefined | null;
};
export {};
//# sourceMappingURL=client-compilation.d.ts.map