/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.executeUnitTest=exports.resolvePackageBin=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),childProcess=require("child_process"),fs=require("fs"),glob_1=require("glob"),path=require("path"),yargs=require("yargs"),mocha_1=require("../../utils/mocha"),resolvePackageBin=e=>{const r=require.resolve(`${e}/package.json`,{paths:[__dirname]}),t=path.dirname(r),i=require(r),s=i.bin[e]||i.bin;return path.resolve(t,s)};exports.resolvePackageBin=resolvePackageBin;const executeUnitTest=async(e,r,t,i="")=>{(0,xtrem_cli_lib_1.printInfo)(e,"Running unit tests...");const s=require(path.resolve(r,"package.json")),n=t?"build/test/mocha/**/*":`build/test/mocha/**/${i}*`,o=glob_1.glob.sync(`./test/graphql/${i}*/`,{cwd:r,absolute:true,realpath:true}).sort(xtrem_shared_1.defaultStringCompare),l=glob_1.glob.sync(`${r}/${n}`).filter(e=>e.endsWith(".js")).filter(e=>!e.endsWith("sample-test.js")).filter(e=>fs.readFileSync(e,"utf8").includes("describe")).sort(xtrem_shared_1.defaultStringCompare);if(!(l&&0!==l.length||o&&0!==o.length))return void(0,xtrem_cli_lib_1.printWarning)(e,"No unit test files were found.");if(t){const t=yargs.argv,i=t.serviceOptions||t.allServiceOptions,o=path.join(__dirname,"../../utils/graphql-tests-entry-point");try{if(await new Promise(e=>{let t=[(0,exports.resolvePackageBin)("c8"),"--include","build/lib/**/*.js","--extension",".js","--extension",".ts"];["build/lib/{client-functions,pages,page-extensions,page-fragments,stickers,upgrades,widgets}/**/*.js",...s?.c8?.exclude||[]].forEach(e=>{t.push("--exclude"),t.push(e)}),t=[...t,"--exclude-after-remap","false","--reporter","html","--reporter","text","--reporter","json","--reporter","cobertura",(0,exports.resolvePackageBin)("mocha"),"--max-old-space-size=3000","--exit","--ui",require.resolve("./xtrem-interface"),"--timeout","1200000","--require",require.resolve("@sage/xtrem-bytenode"),"--require","source-map-support/register","--reporter","mocha-multi","--reporter-options","spec=-,mocha-junit-reporter=-","--recursive",`${o}.js`,`${n}.js`,""+(i?`--service-options=${i}`:"")];const l={...process.env,MOCHA_FILE:path.resolve(r,`junit-report-${s.name.replace("/","-").replace("@","")}.xml`)};if("undefined"===l.NODE_ENV)delete l.NODE_ENV;childProcess.spawn("node",t,{env:l,cwd:r,stdio:"inherit"}).on("close",r=>{e(0===r)})}))(0,xtrem_cli_lib_1.printSuccess)(e,"Unit tests passed.");else(0,xtrem_cli_lib_1.quitWithError)(e,"Unit tests failed.")}catch(r){console.log(r),(0,xtrem_cli_lib_1.printWarning)(e,r),(0,xtrem_cli_lib_1.quitWithError)(e,"Unit tests failed.")}}else{if(xtrem_cli_lib_1.isDebugging)(0,xtrem_cli_lib_1.printWarning)(e,"Running in debug mode, timeout is disabled.");try{const i=(0,mocha_1.createMochaRunner)(e,r,t),s=path.join(__dirname,"../../utils/unit-tests-entry-point");if(i.addFile(s),l.forEach(e=>{i.addFile(e)}),!xtrem_core_1.ConfigManager.current.logs?.disabled){const t=`The following unit test files will be executed:\n${[...o,...l].map(e=>` - ${e.replace(r+path.sep,"")}`).join("\n")}`;(0,xtrem_cli_lib_1.printInfo)(e,t)}if(!await new Promise(e=>{i.run(e)}))(0,xtrem_cli_lib_1.printSuccess)(e,"Unit tests passed.");else(0,xtrem_cli_lib_1.quitWithError)(e,"Unit tests failed.")}catch(r){console.log(r),(0,xtrem_cli_lib_1.printWarning)(e,r),(0,xtrem_cli_lib_1.quitWithError)(e,"Unit tests failed.")}}};exports.executeUnitTest=executeUnitTest;
//# sourceMappingURL=unit-tests.js.map