/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.lint=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),chalk_1=require("chalk"),eslint_1=require("eslint"),fs=require("fs"),glob_1=require("glob"),path=require("path"),file_1=require("../../utils/file"),getFiles=(e,t,i,s)=>{const r={cwd:t,absolute:true,realpath:true};if(s){const i=path.isAbsolute(s)?s:path.resolve(t,s);if(fs.statSync(i).isFile()){if(i.endsWith(".ts")){if(fs.existsSync(i))return[i];return void(0,xtrem_cli_lib_1.quitWithError)(e,"File is not found.")}return void(0,xtrem_cli_lib_1.quitWithError)(e,`${i} is not a TypeScript file.`)}}else return[...glob_1.glob.sync("./lib/**/*.ts",r),...glob_1.glob.sync("./test/**/*.ts",r),...glob_1.glob.sync("./test/graphql/**/parameters.json",r)].filter(e=>i||!/[\\/](pages|page-extensions|page-fragments|stickers|client-functions)[\\/]/.test(e));return[...glob_1.glob.sync("./lib/**/*.ts",r),...glob_1.glob.sync("./lib-generated/**/*.ts",r),...glob_1.glob.sync("./test/**/*.ts",r),...glob_1.glob.sync("./test/graphql/**/parameters.json",r)]};function getEslintBaseConfig(e,t,i){return{baseConfig:require(`${e}/${i}`),fix:t}}const lint=async(e=false,t)=>{const{executionMode:i,dir:s}=xtrem_cli_lib_1.cliContext,r=path.resolve((0,file_1.getResourcesDir)(),".prettierrc"),l=JSON.parse(fs.readFileSync(r,"utf-8")),n=getEslintBaseConfig(s,e,".eslintrc.js");n.reportUnusedDisableDirectives="error";const o=n.baseConfig.parserOptions,a=o.project instanceof Array&&o.project.includes("tsconfig-artifacts.json"),c=new eslint_1.ESLint(n),f=new eslint_1.ESLint(getEslintBaseConfig(s,e,".eslintrc-filename.js")),_=getFiles(i,s,a,t),u=[];if(!_)return;const g=await c.lintFiles(_);if(e)(0,xtrem_cli_lib_1.printInfo)(i,"Output fixes to disk"),await eslint_1.ESLint.outputFixes(g);const p=await f.lintFiles(_),b=require("prettier");await Promise.all(_.filter(e=>!/\.json$/.test(e)).map(async t=>{const s=await fs.promises.readFile(t,"utf-8"),r=await b.format(s,{...l,filepath:t}),n=r!==s;if(e&&n)(0,xtrem_cli_lib_1.printInfo)(i,`${t} has been reformatted.`),await fs.promises.writeFile(t,r,"utf-8");else if(n)u.push(t)}));const m=[...g,...p];if(m.some(e=>e.messages.some(e=>2===e.severity))||u.length>0){if(m.forEach(e=>{e.messages.filter(e=>1===e.severity&&e.ruleId).forEach(t=>{(0,xtrem_cli_lib_1.printWarning)(i,`${e.filePath}:${t.line}:${t.column}: ${t.message} (${t.ruleId})`)}),e.messages.filter(e=>2===e.severity).forEach(t=>{(0,xtrem_cli_lib_1.printError)(i,`${e.filePath}:${t.line}:${t.column}: ${t.message} (${t.ruleId})`)})}),u.forEach(e=>{(0,xtrem_cli_lib_1.printWarning)(i,`prettier (${e})`)}),!e)(0,xtrem_cli_lib_1.printInfo)(i,`Run again with ${chalk_1.default.bold("--fix")} to try to fix the issues above.`);(0,xtrem_cli_lib_1.quitWithError)(i,"Some files didn't pass the linter.")}else if(m.forEach(e=>{e.messages.filter(e=>1===e.severity&&e.ruleId).forEach(t=>{(0,xtrem_cli_lib_1.printWarning)(i,`${e.filePath}:${t.line}:${t.column}: ${t.message} (${t.ruleId})`)})}),(0,xtrem_cli_lib_1.printSuccess)(i,"All good!"),i===xtrem_cli_lib_1.ExecutionMode.STANDALONE)process.exit(0)};exports.lint=lint;
//# sourceMappingURL=index.js.map