/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.init=exports.searchX3Dependencies=exports.bootstrapPackage=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),fs=require("fs"),inquirer=require("inquirer"),path=require("path"),bootstrap_package_1=require("./bootstrap-package");Object.defineProperty(exports,"bootstrapPackage",{enumerable:true,get:function(){return bootstrap_package_1.bootstrapPackage}});const search_packages_1=require("./search-packages");Object.defineProperty(exports,"searchX3Dependencies",{enumerable:true,get:function(){return search_packages_1.searchX3Dependencies}});const kebabCaseRegex=/^([a-z][a-z0-9]*)(-[a-z0-9]+)*$/,init=()=>{const{executionMode:e,dir:a}=xtrem_cli_lib_1.cliContext;(async()=>{const r=await(0,search_packages_1.searchX3Dependencies)(e),t=await inquirer.prompt([{name:"vendorName",type:"input",message:"Enter your vendor name (e.g. sage)",default:"sage",validate:e=>{if(kebabCaseRegex.test(e.trim()))return true;return"Please enter your vendor name in kebab case format."}},{name:"name",type:"input",default:"sample-package",message:"Enter your package name (e.g. my-xtrem-package)",validate:e=>{if(e&&kebabCaseRegex.test(e.trim())){if(fs.existsSync(path.resolve(a,e)))return"This package already exists in the current directory. Please choose another name.";return true}return"Please enter your vendor name in kebab case format."}},{name:"dependencies",type:"checkbox",message:"Select your dependencies",choices:r.map(e=>`${e.name} v${e.version}`)},{name:"database",type:"list",message:"Select your database driver",default:"none",choices:["none","postgres"]}]),s=t.dependencies.map(e=>{const a=e.split(" v");return{name:a[0],version:a[1]}});if("none"!==t.database)s.push({name:`@sage/xtrem-${t.database}`,version:"1.0.0"});try{if(await(0,bootstrap_package_1.bootstrapPackage)(e,a,t.vendorName,t.name,s),(0,xtrem_cli_lib_1.printSuccess)(e,"Your new package is now ready to roll!"),e===xtrem_cli_lib_1.ExecutionMode.STANDALONE)process.exit()}catch(a){(0,xtrem_cli_lib_1.quitWithError)(e,a)}})().catch(a=>{(0,xtrem_cli_lib_1.quitWithError)(e,a)})};exports.init=init;
//# sourceMappingURL=index.js.map