/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.compile=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_client_gen_1=require("@sage/xtrem-client-gen"),xtrem_cop_1=require("@sage/xtrem-cop"),xtrem_core_1=require("@sage/xtrem-core"),xtrem_i18n_1=require("@sage/xtrem-i18n"),chalk_1=require("chalk"),fs=require("fs"),_=require("lodash"),path=require("path"),routing_1=require("../../utils/notification-listener-routing/routing"),binary_1=require("./binary"),clean_1=require("./clean"),compile_server_1=require("./compile-server"),compile_ui_1=require("./compile-ui"),copy_dictionaries_1=require("./copy-dictionaries"),dts_generator_1=require("./dts-generator"),instrumenter_1=require("./instrumenter");async function compile(e){const{executionMode:i,dir:r}=xtrem_cli_lib_1.cliContext,{skipClient:t,skipCop:n,skipServer:o,skipClean:a,skipDts:s,skipApiClient:l,force:c,isInstrumented:g,isBinary:u,isProd:p,isUsingReferences:f,isOnlyApi:m,isOnlyChanged:d}=e,x=Date.now();if(m)(0,xtrem_client_gen_1.generateClientPackageJsonFromPackageJson)(r),process.exit();if(process.env.XTREM_USE_TEST_APPLICATION="0",o&&u)(0,xtrem_cli_lib_1.quitWithError)(i,"In order to compile to binary format, you have to also compile the server side artifacts.");else{if(c||!a&&!d)(0,clean_1.clean)(i,r,{force:c});else if(d)(0,xtrem_cli_lib_1.printWarning)(i,"The build folder was not cleaned as the --only-changed flag was applied.");else(0,xtrem_cli_lib_1.printInfo)(i,"Skipping build folder cleanup.");if(!o)(0,compile_server_1.compileServer)(i,r,{isUsingReferences:f});else if(!l)(0,xtrem_cli_lib_1.quitWithError)(i,"In order to generate the client API schema, you have to also compile the server side artifacts. Try adding the --skip-api-client flag or removing the --skip-server one");else(0,xtrem_cli_lib_1.printInfo)(i,"Skipping server side artifacts.");if(!o&&!s)(0,dts_generator_1.generateSingleDefinition)(i,r);else(0,xtrem_cli_lib_1.printInfo)(i,"Skipping single declaration file generation.");const e=await xtrem_core_1.ApplicationManager.getApplication(r,{applicationType:"dev-tool"});if(e.mainPackage.isMain||e.mainPackage.api.workflowSteps)if(aggregateNotificationListenerRoutingData(e,i),!fs.existsSync(path.join(e.mainPackage.dir,"lib")))(0,xtrem_cli_lib_1.printSuccess)(i,`${chalk_1.default.bgGreen(" 🌋 ")} It's all done, you are ready to roll!`),process.exit();if(!n&&!path.join(e.mainPackage.dir,"../..").endsWith("/x3")){(0,xtrem_cli_lib_1.printInfo)(i,"Verifying code..."),(0,xtrem_cop_1.verifyDependsOn)(e);const r=await e.verifySqlConversions();if(r>0)(0,xtrem_cli_lib_1.quitWithError)(i,`Found ${r} errors in the getValue/computeValue decorators`);(0,xtrem_cli_lib_1.printSuccess)(i,"Code was successfully verified.")}else(0,xtrem_cli_lib_1.printInfo)(i,"Skipping code verification.");if(!l)(0,xtrem_cli_lib_1.printInfo)(i,"Generating API reference TS declaration package..."),await(0,xtrem_client_gen_1.generateClientPackage)(e),(0,xtrem_cli_lib_1.printSuccess)(i,"API reference TS declaration package generated successfully.");else(0,xtrem_cli_lib_1.printInfo)(i,"Skipping API reference TS declaration package generation.");if(g)(0,instrumenter_1.instrumentCode)(i,r);if(u)await(0,binary_1.binaryEncoding)(i,r);if(!t)if(process.env.SKIP_CLIENT)(0,xtrem_cli_lib_1.printWarning)(i,"SKIP_CLIENT environment variable found, skipping client compilation...");else await(0,compile_ui_1.compileUi)(i,r,p,g,d);else(0,xtrem_cli_lib_1.printInfo)(i,"Skipping client side artifacts.");if((0,xtrem_cli_lib_1.printInfo)(i,"Preparing string literal files..."),(0,xtrem_i18n_1.mergeTranslationFiles)(r),(0,xtrem_i18n_1.resetDictionary)(),(0,xtrem_cli_lib_1.printSuccess)(i,"String literal files prepared."),(0,copy_dictionaries_1.copyDictionaries)(i,r),(0,xtrem_cli_lib_1.printSuccess)(i,`${chalk_1.default.bgGreen(" 🌋 ")} It's all done, you are ready to roll! (${Date.now()-x} ms)`,false),i===xtrem_cli_lib_1.ExecutionMode.STANDALONE)process.exit()}}function aggregateNotificationListenerRoutingData(e,i){let r={},t={};e.getPackages().forEach(e=>{if(e.isMain&&!e.hasListeners)return;const n=getRoutingDataForPackage(e,i);r=(0,routing_1.mergeRoutings)(r,n),t=(0,routing_1.mergeRoutings)(t,n);const o=path.join(e.dir,"test/fixtures/routing.json");if(fs.existsSync(o)){const e=JSON.parse(fs.readFileSync(o,"utf-8"));t=(0,routing_1.mergeRoutings)(t,e)}});const n=e.workflowManager.getWorkflowTopics().map(e=>({topic:e,queue:"workflow",sourceFileName:"<workflow step>"}));r=(0,routing_1.mergeRoutings)(r,{"@sage/xtrem-workflow":n}),t=(0,routing_1.mergeRoutings)(t,{"@sage/xtrem-workflow":n});const o=(0,routing_1.getRoutingFilePath)(e.mainPackage.dir);(0,xtrem_cli_lib_1.printInfo)(i,`Writing file ${o}`),fs.writeFileSync(o,JSON.stringify(r,null,4),"utf-8");const a=routing_1.defaultElasticMq,s=(0,routing_1.getAllElasticMqConfigs)(e,t,void 0,routing_1.requiredQueues);a.queues=_.merge(a.queues,s),e.getPackages().forEach(i=>{const r=_.kebabCase(i.name.split("/").pop()),n=(0,routing_1.getAllElasticMqConfigs)(e,t,r);a.queues=_.merge(a.queues,n)}),(0,routing_1.updateElasticMqConfigFile)(path.join(e.dir,"../../../elasticmq.conf"),a.queues)}function getRoutingDataForPackage(e,i){const r=(0,routing_1.getRoutingFilePath)(e.dir);if(fs.existsSync(r))return(0,xtrem_cli_lib_1.printInfo)(i,`Routing file found in package ${e.name}: ${r}`),(0,routing_1.getRoutingData)(r);return{}}exports.compile=compile;
//# sourceMappingURL=index.js.map