/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.binaryEncoding=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_core_1=require("@sage/xtrem-core"),esquery=require("esquery"),glob_1=require("glob"),lodash=require("lodash"),path=require("path"),xtremBytenode=require("@sage/xtrem-bytenode"),parse=require("espree").parse;function getPreservedRanges(e){const r=parse(e,{ecmaVersion:2022}),i=esquery.query(r,'CallExpression:has(SequenceExpression > MemberExpression[property.name="registerSqlFunction"])');if(i.length>0)return[[0,e.length]];const s=[...esquery.query(r,"Property[key.name=/^(defaultValue|getValue|filter|isClearedByReset|where)$/]"),...esquery.query(r,"Property[key.name=/^(set|join)$/] > ObjectExpression > Property")].filter(e=>"FunctionExpression"===e.value.type),t=esquery.query(r,"Property").filter(e=>"FunctionExpression"===e.value.type),n=lodash.difference(t,s),o=esquery.query(r,"FunctionDeclaration"),l=esquery.query(r,"ArrowFunctionExpression"),getStart=e=>e.start,getEnd=e=>e.end,getRange=e=>[getStart(e),getEnd(e)],declarationStartRange=(e,r)=>[getStart(e),getStart(r)],declarationEndRange=(e,r)=>[getEnd(r)-1,getEnd(e)];return[...s.map(getRange),...i.map(getRange),...n.map(e=>declarationStartRange(e,e.value.body)),...n.map(e=>declarationEndRange(e,e.value.body)),...o.map(e=>declarationStartRange(e,e.body)),...o.map(e=>declarationEndRange(e,e.body)),...l.map(e=>declarationStartRange(e,e.body)),...l.map(e=>declarationEndRange(e,e.body))].filter(e=>e[1]>e[0]).sort((e,r)=>e[0]-r[0])}const binaryEncoding=async(e,r)=>{(0,xtrem_cli_lib_1.printInfo)(e,"Encoding server side artifacts to binary format...");const i={cwd:r,absolute:true,realpath:true},s=glob_1.glob.sync("./build/**/*.js",i),t=glob_1.glob.sync("./build/lib/pages/**/*.js",i),n=glob_1.glob.sync("./build/lib/stickers/**/*.js",i),o=glob_1.glob.sync("./build/lib/menu-items/**/*.js",i),l=glob_1.glob.sync("./build/lib/client-functions/**/*.js",{cwd:r,absolute:true,realpath:true}),a=glob_1.glob.sync("./build/lib/shared-functions/**/*.js",{cwd:r,absolute:true,realpath:true}),u=/\/(x3-services|wh-services)\//.test(r.replace(/\\/g,"/"))?glob_1.glob.sync("./build/lib/node*/**/*.js",i):[],c=[path.join(r,"build","index.js"),path.join("build","index.js"),path.join(r,"build","lib","index.js"),path.join("build","lib","index.js"),...t,...n,...o,...l,...a,...u];await(0,xtrem_core_1.asyncArray)(s.filter(e=>!c.includes(e))).forEach(e=>{xtremBytenode.compileFile({filename:e,compileAsModule:true,compress:true,minify:true,getPreservedRanges})}),(0,xtrem_cli_lib_1.printSuccess)(e,"Server side artifacts encoded to binary format.")};exports.binaryEncoding=binaryEncoding;
//# sourceMappingURL=binary.js.map