/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.compilePlugin=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_i18n_1=require("@sage/xtrem-i18n"),fs=require("fs"),path=require("path"),webpack_merge_1=require("webpack-merge"),utils_1=require("../../utils"),page_metadata_transformer_1=require("../../utils/page-metadata-transformer"),webpack=require("webpack"),compilePlugin=()=>{const{executionMode:e,dir:r}=xtrem_cli_lib_1.cliContext,i=path.resolve(r,"build"),t=path.resolve(r,"webpack.config.js");if(true!==JSON.parse(fs.readFileSync(path.resolve(r,"package.json"),"utf-8")).xtremPlugin)(0,xtrem_cli_lib_1.quitWithError)(e,"Is this package really an Xtrem UI plugin? If so make sure to set the `xtremPlugin` property to true in your package file.");if(fs.existsSync(i))(0,xtrem_cli_lib_1.printInfo)(e,"Cleaning build directory..."),(0,xtrem_cli_lib_1.safeRmSync)(i,{recursive:true}),(0,xtrem_cli_lib_1.printSuccess)(e,"Build directory is clear.");const s=fs.existsSync(t)?require(t):{};(0,xtrem_cli_lib_1.printInfo)(e,"Building plugin...");const l=(0,webpack_merge_1.merge)({entry:fs.existsSync(path.resolve(r,"lib","index.tsx"))?"./lib/index.tsx":"./lib/index.ts",mode:"production",devtool:false,target:"web",context:r,output:{path:i,libraryTarget:"commonjs",filename:"index.js"},externals:[utils_1.filterExternals],plugins:[new webpack.optimize.LimitChunkCountPlugin({maxChunks:1})],module:{rules:[{test:/\.tsx?$/,exclude:/node_modules/,loader:"ts-loader",options:{colors:false,configFile:path.resolve(r,"tsconfig.json"),errorFormatter:e=>JSON.stringify(e),getCustomTransformers:()=>({before:[xtrem_i18n_1.messageTransformer,page_metadata_transformer_1.pageMetadataTransformer]})}},{test:/\.(png|woff|woff2|eot|ttf|svg|gif)$/,use:[{loader:"url-loader",options:{limit:1e5}}]},{test:/\.css$/,use:["style-loader","css-loader"]},{test:/\.scss$/,use:["style-loader","css-loader","sass-loader"],include:path.resolve(r,"lib")}]},resolve:{extensions:[".ts",".tsx",".js",".json",".mjs"]}},s);webpack(l).run((i,t)=>{const s=t&&t.toJson();if(t.hasWarnings())s.warnings.forEach(r=>{(0,xtrem_cli_lib_1.printWarning)(e,r.message)});if(t.hasErrors())s.errors.forEach(r=>{(0,xtrem_cli_lib_1.printWarning)(e,r.message)});if(i)(0,xtrem_cli_lib_1.quitWithError)(e,i.message);if(t.hasErrors())(0,xtrem_cli_lib_1.quitWithError)(e,"See compilation errors above.");if((0,xtrem_i18n_1.mergeTranslationFiles)(r),(0,xtrem_cli_lib_1.printSuccess)(e,"Plugin is ready."),e===xtrem_cli_lib_1.ExecutionMode.STANDALONE)process.exit(0)})};exports.compilePlugin=compilePlugin;
//# sourceMappingURL=index.js.map