"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.funnel = void 0;
const xtrem_shared_1 = require("@sage/xtrem-shared");
function funnel(max = 1, callback) {
    let queue = [];
    let active = 0;
    let closed = false;
    let highWaterMark = 0;
    function _doOne() {
        const current = queue.shift();
        active += 1;
        if (current == null) {
            throw new xtrem_shared_1.LogicError(`Unexpected value: ${current}`);
        }
        current
            .body()
            .then(current.resolve, current.reject)
            .finally(() => {
            active -= 1;
            if (!closed) {
                while (active < max && queue.length > 0)
                    _doOne();
            }
        });
    }
    const fun = (body) => {
        return new Promise((resolve, reject) => {
            if (max < 0 || max === Infinity)
                body().then(resolve, reject);
            else {
                queue.push({
                    body,
                    resolve,
                    reject,
                });
                callback?.();
                if (queue.length > highWaterMark)
                    highWaterMark = queue.length;
                if (active < max && queue.length > 0)
                    _doOne();
            }
        });
    };
    fun.close = () => {
        queue = [];
        closed = true;
    };
    Object.defineProperty(fun, 'length', {
        get() {
            return queue.length;
        },
    });
    Object.defineProperty(fun, 'capacity', {
        get() {
            return max;
        },
    });
    Object.defineProperty(fun, 'highWaterMark', {
        get() {
            return highWaterMark;
        },
    });
    // cast is required because the getter are not resolved
    return fun;
}
exports.funnel = funnel;
//# sourceMappingURL=funnel.js.map