// From file: /agent/_work/1/s/platform/back-end/xtrem-log/build/index.d.ts
declare module '@sage/xtrem-log/index' {
	export { clsContext, Colors, Logger, LogLevel, withClsContext } from '@sage/xtrem-log/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-log/build/lib/logger.d.ts
declare module '@sage/xtrem-log/lib/logger' {
	import { AnyValue, AsyncResponse, Config, LoggerErrorHandler, LoggerIgnoreCallback, LoggerInterface, LoggingOptions, ProfilerCallback } from '@sage/xtrem-shared';
	export type MessageOrCallback = string | Error | (() => string | Error);
	export type MessageOrCallbackAsync = Promise<string | Error> | (() => string | Error | Promise<string | Error>);
	/** Default error handler for `logger.do`. Just rethrows */
	export const rethrow: LoggerErrorHandler<any>;
	/** We need a function for testability */
	export const getDate: () => Date;
	export class Logger implements LoggerInterface {
	    private readonly domain;
	    private static _globalLogger;
	    private static readonly _allLoggers;
	    private static readonly _allLoggersByDomain;
	    private static _nextEventId;
	    private static _startBannerDisplayed;
	    private static logsConfig;
	    private static _logAsJson?;
	    private static _app?;
	    private static readonly consoleFormatter;
	    private static readonly fileFormatter;
	    private _logLevel;
	    private initialized;
	    private readonly moduleName;
	    private readonly timer;
	    private static isDisabled;
	    constructor(sourceFilename: string, domain: string);
	    private static get globalLogger();
	    private static set globalLogger(value);
	    private nopFunction;
	    /**
	     * Returns the name of the package that contains the folder.
	     * The result will be sth like sage/xtrem-core
	     * @param folder
	     */
	    private static getPackageName;
	    /** internal */
	    static get rootLogger(): Logger;
	    static reloadConfig(config: Config): void;
	    private static initGlobalLogger;
	    private initIfNeeded;
	    private static displayStartBanner;
	    private get fullDomain();
	    get logLevel(): LogLevel;
	    set logLevel(level: LogLevel);
	    /**
	     * Creates a new logger.
	     * @param sourceFilename  should be __filename
	     * @param domain
	     */
	    static getLogger(sourceFilename: string, domain: string): Logger;
	    /**
	     * Logs a message with a provided log level
	     */
	    private _log;
	    /**
	     * Logs a message with a provided log level - async version
	     */
	    private _logAsync;
	    /**
	     * Logs a message with a provided log level
	     */
	    log(logLevel: LogLevel, messageProvider: () => string, options?: LoggingOptions): ProfilerCallback;
	    /**
	     * Logs a message with a provided log level - async version
	     */
	    logAsync(logLevel: LogLevel, messageProvider: Promise<string> | (() => Promise<string>), options?: LoggingOptions): Promise<ProfilerCallback>;
	    /**
	     * Logs a message with the 'info' level (level=3)
	     */
	    info(messageOrCallback: MessageOrCallback, options?: LoggingOptions): ProfilerCallback;
	    /**
	     * Logs a message with the 'info' level (level=3) - async version
	     */
	    infoAsync(messageOrCallback: MessageOrCallbackAsync, options?: LoggingOptions): Promise<ProfilerCallback>;
	    /**
	     * Logs a message with the 'warn' level (level=2)
	     */
	    warn(messageOrCallback: MessageOrCallback, options?: LoggingOptions): ProfilerCallback;
	    /**
	     * Logs a message with the 'warn' level (level=2) - async version
	     */
	    warnAsync(messageOrCallback: MessageOrCallbackAsync, options?: LoggingOptions): Promise<ProfilerCallback>;
	    /**
	     * Logs a message with the 'debug' level (level=5)
	     */
	    debug(messageProvider: () => string, options?: LoggingOptions): ProfilerCallback;
	    /**
	     * Logs a message with the 'debug' level (level=5)
	     */
	    debugAsync(messageProvider: () => string | Promise<string>, options?: LoggingOptions): Promise<ProfilerCallback>;
	    /**
	     * Logs a message with the 'verbose' level (level=4)
	     */
	    verbose(messageProvider: () => string, options?: LoggingOptions): ProfilerCallback;
	    /**
	     * Logs a message with the 'verbose' level (level=4) - async version
	     */
	    verboseAsync(messageProvider: () => string | Promise<string>, options?: LoggingOptions): Promise<ProfilerCallback>;
	    /**
	     * Logs a message with the 'error' level (level=1)
	     */
	    error(messageOrCallback: MessageOrCallback, options?: LoggingOptions): ProfilerCallback;
	    /**
	     * Logs a message with the 'error' level (level=1) - async version
	     * @param messageOrCallback
	     */
	    errorAsync(messageOrCallback: MessageOrCallbackAsync, options?: LoggingOptions): Promise<ProfilerCallback>;
	    private getLogFunctionCallback;
	    isActive(logLevel: LogLevel): boolean;
	    private static _messageOrErrorToString;
	    private _internalLog;
	    get statistics(): {
	        count: number;
	        totalDuration: number;
	        meanDuration: number;
	        standardDeviation: number;
	    };
	    /**
	     * result = do(fn, onError);
	     *
	     * Executes `fn()` silently.
	     * But if `fn()` fails, logs the stacktrace and rethrows.
	     *
	     * `onError(err)` is an optional callback which will be invoked if `fn()` fails.
	     * By default, `onError` rethrows the error, but you can rethrow a different error, typically
	     * to mask low level details, or add some context to the error.
	     * You can also use `onError` to stop the error propagation and return a special value.
	     */
	    do<T>(fn: () => T, onError?: LoggerErrorHandler<T>): T;
	    /**
	     * Async variant of do(fn, onError)
	     */
	    doAsync<T extends AnyValue | void>(fn: () => AsyncResponse<T>, options?: {
	        onError?: LoggerErrorHandler<T>;
	        /**
	         * The callback to determine if a message should be ignored
	         */
	        ignoreCallback?: LoggerIgnoreCallback;
	    }): Promise<T>;
	    static setAppName(app: string | undefined): void;
	    /**
	     * Logger.disable()
	     *
	     * Disables all logs.
	     * This method is called before running unit tests when logs/disabledForTests is true.
	     */
	    static disable(): void;
	    static isLogAsJson(): boolean;
	}
	//# sourceMappingURL=logger.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-log/build/lib/index.d.ts
declare module '@sage/xtrem-log/lib/index' {
	export * from '@sage/xtrem-log/lib/async-local-storage';
	export * from '@sage/xtrem-log/lib/colors';
	export * from '@sage/xtrem-log/lib/logger';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-log/build/lib/console-transport.d.ts
declare module '@sage/xtrem-log/lib/console-transport' {
	export {};
	//# sourceMappingURL=console-transport.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-log/build/lib/colors.d.ts
declare module '@sage/xtrem-log/lib/colors' {
	export abstract class Colors {
	    private static format;
	    static black(message: string): string;
	    static red(message: string): string;
	    static green(message: string): string;
	    static yellow(message: string): string;
	    static blue(message: string): string;
	    static magenta(message: string): string;
	    static cyan(message: string): string;
	    static white(message: string): string;
	    static lightGray(message: string): string;
	    static default(message: string): string;
	    static darkGray(message: string): string;
	    static lightRed(message: string): string;
	    static lightGreen(message: string): string;
	    static lightYellow(message: string): string;
	    static lightBlue(message: string): string;
	    static lightMagenta(message: string): string;
	    static lightCyan(message: string): string;
	    /** Removes all the color markers from a string */
	    static clean(message: string): string;
	}
	//# sourceMappingURL=colors.d.ts.map
}
// From file: /agent/_work/1/s/platform/back-end/xtrem-log/build/lib/async-local-storage.d.ts
declare module '@sage/xtrem-log/lib/async-local-storage' {
	import { AsyncResponse } from '@sage/xtrem-shared';
	export type AnyValue = boolean | string | number | object | null | undefined | AnyValue[] | void;
	export function withClsContext<T extends AnyValue | void>(fn: () => AsyncResponse<T>, context: {}): Promise<T>;
	export function clsContext<T = any>(): T;
	//# sourceMappingURL=async-local-storage.d.ts.map
}
declare module '@sage/xtrem-log' {
	export * from '@sage/xtrem-log/index';
}
