/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.WebSocketNotificationManager=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_websocket_emiter_1=require("@sage/xtrem-websocket-emiter"),ws_1=require("ws"),logger=xtrem_core_1.Logger.getLogger(__filename,"web-socket-notification");class WebSocketNotificationManager{static{this.webSocketNotificationClients=new Map}static startService(e){const t=xtrem_core_1.ConfigManager.current;if(!(0,xtrem_shared_1.isDevelopmentProdUiConfig)(t))return;WebSocketNotificationManager.webSocketServer=new ws_1.WebSocket.Server({noServer:true}),WebSocketNotificationManager.webSocketServer.on("connection",(e,t)=>{const o=t.headers.cookie.match(/(?<=access_token=)[^;]*/)[0],i=`${WebSocketNotificationManager.parseJwt(o).sub}-${t.headers["sec-websocket-key"]}`;WebSocketNotificationManager.addWebSocketNotificationClient(e,i),e.on("message",e=>{logger.info(`Received message from client ${i}: ${e.toString()}`)}),e.on("close",()=>{logger.info(`Client ${i} disconnected`),WebSocketNotificationManager.deleteWebSocketNotificationClient(i)}),e.send(`Connection established with ${i}`)}),e.on("upgrade",(e,t,o)=>{const i=e.headers.host;if(i?.startsWith("websocket."))WebSocketNotificationManager.webSocketServer.handleUpgrade(e,t,o,t=>{WebSocketNotificationManager.webSocketServer.emit("connection",t,e)});else t.destroy()})}static addWebSocketNotificationClient(e,t){if(WebSocketNotificationManager.webSocketNotificationClients.get(t))return;WebSocketNotificationManager.webSocketNotificationClients.set(t,e)}static deleteWebSocketNotificationClient(e){WebSocketNotificationManager.webSocketNotificationClients.delete(e)}static getWebSocketNotificationClient(e){const t=[];return WebSocketNotificationManager.webSocketNotificationClients.forEach((o,i)=>{if(i.startsWith(e))t.push(o)}),t}static parseJwt(e){return JSON.parse(Buffer.from(e.split(".")[1],"base64").toString())}static async sendUserNotification(e,t,o){const i=xtrem_core_1.ConfigManager.current,n=await e.loginUser,r=n?.email,a=n?._id;if(!r)return void logger.error(`Cannot send notification: No valid user email found in context for user id ${a}`);const c=e.tenantId;if(!c)return void logger.error(`Cannot send notification: No valid tenantId found in context for user id ${a}`);const s={category:t,payload:o};if((0,xtrem_shared_1.isDevelopmentProdUiConfig)(i)){if(!WebSocketNotificationManager.webSocketServer&&!e.testMode)throw Error("No WebServer started. Please run WebSocketNotificationManager.startService");const t=WebSocketNotificationManager.getWebSocketNotificationClient(r);if(0===t?.length)logger.warn(`No websocket clients connected for user ${a}.`);return void t?.forEach(e=>{e?.send(JSON.stringify(s))})}if("production"===i.deploymentMode){const e={userId:r,tenantId:c,sendToAllMatchingUserSessions:true},t=WebSocketNotificationManager.webSocketHelper(i);if(await t.isUserOfTenantConnected({userId:r,tenantId:c}))await t.sendUserNotification(e,s);else logger.warn(()=>`Notification not sent: user ${a} not connected`)}}static webSocketHelper(e){const t=e.webSocket?.clientNotifications;if(!t)throw new Error("Web socket request config is missing for clientNotifications");return new xtrem_websocket_emiter_1.WebsocketAWSImpl.WebsocketAWSRepository({app:xtrem_core_1.ConfigManager.current.app??"sdmo",source:t?.request?.source,clusterId:e.clusterId??"",dynamoDBTableName:t?.dynamoDbTableName??"",websocketQueueUrl:t?.request?.websocketQueueUrl??"",awsConfigOverride:{region:process.env.AWS_REGION||"eu-west-1"}})}}exports.WebSocketNotificationManager=WebSocketNotificationManager;
//# sourceMappingURL=web-socket-notification-manager.js.map