/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.WebSocketManager=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_websocket_emiter_1=require("@sage/xtrem-websocket-emiter"),nanoid_1=require("nanoid"),ws_1=require("ws"),axios=xtrem_core_1.Mocker.get("axios",require),logger=xtrem_core_1.Logger.getLogger(__filename,"web-socket");class WebSocketManager{static{this.wsClients=new Map}static start(e,t){if(this.wsClients.has(t))return void logger.error(`Websocket client already started : ${t}`);const r=xtrem_core_1.ConfigManager.current.webSocket&&xtrem_core_1.ConfigManager.current.webSocket[t];if(!r)return void logger.error(`Web socket config is missing for ${t}`);WebSocketManager.createWebSocketClient(e,t,r)}static async getUploadUrl(e,t){logger.info(`Fetching an upload url for contextid : ${t}`);try{const r=await axios.post(`${e}${t}`);if(201===r?.status)return logger.info(`Upload url response : ${JSON.stringify(r.data)}`),{uploadUrl:r.data.uploadUrl,confirmUrl:r.data.confirmUrl};throw new Error(`API to get presigned url returned with a ${r.status} status`)}catch(e){throw logger.error(`Error while fetching upload URL : \n${e.stack}`),e}}static async sendResponsePayload(e,t,r){const o=await this.getUploadUrl(e,t);try{const e=await axios.put(o.uploadUrl,r);if(200!==e.status)logger.error(`upload to s3 failure : ${e.status}`)}catch(e){throw logger.error(`upload to s3 failure : ${e}`),e}logger.info("upload to s3 done");try{const e=await axios.post(o.confirmUrl);if(200!==e.status)logger.error(`Fail to confirm upload done : ${e.status}`)}catch(e){throw logger.error(`Fail to confirm upload done : ${e}`),e}logger.info(`Confirmation of upload completed, end of processing ${t}`)}static createWebSocketClient(e,t,r){if(!r.response)return void logger.error(`Web socket response config is missing for ${t}`);const o=new ws_1.WebSocket(r.response.wsEndPoint,{headers:{Authorization:r.response.authToken},perMessageDeflate:false});o.on("open",()=>{logger.info(`Connected to ${t} web socket endpoint`)}),o.on("close",()=>{logger.info(`Server sent close event, reconnecting to ${t}`),WebSocketManager.createWebSocketClient(e,t,r)}),o.on("error",()=>{logger.info(`Server sent error event, reconnecting to ${t}`),setTimeout(()=>WebSocketManager.createWebSocketClient(e,t,r),5e3)});const processMessage=async o=>{logger.info(`received(${t}): ${o}`);let n=null;n=JSON.parse(o.toString());const s=["contextId","tenantId","developerId","source","type","request","replyId","replyTopic"].filter(e=>!n[e]);if(s.length>0)throw new Error(`Message missing, ${s} : ${n}`);if(logger.info(`Message format valid, contextId : ${n.contextId}, tenantId : ${n.tenantId}`),!xtrem_core_1.CoreHooks.webSocketHandlers[t])throw new Error(`Web socket handler missing for key : ${t}`);const a=JSON.stringify(await xtrem_core_1.CoreHooks.webSocketHandlers[t].getResponse(e,n));if(logger.info(`response = ${a}`),r.response)await WebSocketManager.sendResponsePayload(r.response.restResponseEndpoint,n.contextId,a);else logger.error(`Web socket response config is missing for ${t}`)};o.on("message",e=>{processMessage(e).catch(e=>logger.error(`Error sending response message: \n${e.stack}`))}),this.wsClients.set(t,o)}static getRegion(){return process.env.AWS_REGION||"eu-west-1"}static async send(e,t,r,o,n){logger.info(`Websocket - sending message on key ${e}`);const s=xtrem_core_1.ConfigManager.current,a=s.webSocket&&s.webSocket[e];if(!a?.request)throw new Error(`Web socket request config is missing for ${e}`);logger.info(`Searching if app ${o} is connected for tenant ${r}  (cluster context ${s.clusterId})`);const i=new xtrem_websocket_emiter_1.WebsocketAWSImpl.WebsocketAWSRepository({app:xtrem_core_1.ConfigManager.current.app||"",source:a.request.source,clusterId:s.clusterId||"",dynamoDBTableName:s.asyncContextTableName||"",websocketQueueUrl:a.request.websocketQueueUrl,awsConfigOverride:{region:this.getRegion()}}),c=(0,nanoid_1.nanoid)(),g={...t,contextId:c};if(await i.isThirdPartyAppConnected({tenantId:r,applicationId:o}))return logger.info(`3rd party app connected, message : ${JSON.stringify(g)}`),await i.sendThirdPartyAppNotification({applicationId:o,tenantId:r},g),logger.info(`Message sent: ${c}`),c;if(logger.error("The 3rd party app is not connected via websocket at the moment"),n?.force)return logger.warn(`Forcing message sending to user anyway : ${JSON.stringify(g)}`),await i.sendThirdPartyAppNotification({applicationId:o,tenantId:r},g),logger.warn(`Message sent, forced, not sure it will be received: ${c}`),c;throw new Error("Web socket request not sent, 3rd party app not connected.")}static startService(e){const t=e.startOptions.webSockets||[];if(t.length>0)logger.info(`Starting web sockets: ${t}`),t.forEach(t=>{WebSocketManager.start(e,t)})}}exports.WebSocketManager=WebSocketManager;
//# sourceMappingURL=web-socket-manager.js.map