# gms-chat-ui Web Component

The code examples included demonstrate the minimum code
required to integrate the component.

Initially, use the mocked backend (ie `backend-url="https://mocked/gms"`)
to get the component integrated into your codebase.

Once integrated, you will need Sage ID credentials to authenticate
the component to the backend.

For development, the simplest way is to launch the component
with `auth-token=""` and `backendUrl` pointed to the development backend.
In this situation, it will display a dev only login dialog.
Enter your Sage ID Client ID and Client Secret,
and the component will retrieve and use a bearer token.

Alternatively, you can supply your own bearer token to `auth-token`.
See [sage-id-auth.js](sage-id-auth.js) for a working example.

We will work with you to develop user authentication
that works with your existing authentication scheme.

## Using the mocked backend

When chatting with the mocked backend,
it will reply with the message you sent postfixed with `(reply)`.
You can test specific message kinds by sending `hyperlink` or `custom_data`
in the chat.
Errors can be simulated by sending `401`, `404`, `500`.

## Backend URLs

All the examples use the mocked backend (ie `backend-url="https://mocked/gms"`),
so access to the live backend isn't required to test the integration.

The live backends are as follows:

- https://api.gms.development.eu-west-1.sageai.sagecloudops.com/gms
- https://api.gms.pre-production.eu-west-1.sageai.sagecloudops.com/gms

_Note_: Only the development and pre-production backends are currently exposed.

## Chat window web component (application controls visibility)

This uses the `<gms-chat-window>` custom element.
The integrator needs to wrap this component in a
`<div>`, and control the visibility of the div.

See [minimal-window.html](minimal-window.html).

## Chat button web component (floating or fixed button)

This uses the `<gms-chat-button>` custom element,
where the web component renders a button,
and displays the chat window when the button
is clicked.
The button may be floating in the lower right
part of the page, or fixed on the page.

See [minimal-button.html](minimal-button.html).

## @sageai NPM repository

We publish gms-chat-ui to the @sageai jFrog NPM repository.
We will supply you with `user` and `password` credentials required
to access the repository.

```
curl -u<user>:<password> https://sail.jfrog.io/artifactory/api/npm/sageai-npm/auth/sageai > .npmrc
npm install @sageai/gms-chat-ui
```

You can then import the web component into your code as
show in [minimal-react.tsx](minimal-react.tsx).

## React wrapper

See [minimal-react.tsx](minimal-react.tsx) for
an example of integrating the chat component
into a React application.

Documentation of each of the web component attributes
is supplied in [minimal-react.tsx](minimal-react.tsx).

## `GmsChatUi` Control Object

Once you place a `<gms-chat-window>` or `<gms-chat-button>` element in your DOM,
the component will create a control object on `window`.
This object contains functions that allow you to externally control the
component. These are:

- `window.GmsChatUi.setDisplayState("hidden" | "container" | "popup" | "popup-right" | "minimised");`
- `window.GmsChatUi.navigateTo("chat" | "insights");`
- `window.GmsChatUi.navigateTo("unavailable", { productName: "product name" });`
- `window.GmsChatUi.fetchInsights: () => Promise<InsightSessionMessage[] | undefined>;`

## Events

The component generates events under certain conditions,
which you can subscribe to:

- ``document.addEventListener("gms-chat-initialised", () => alert(`Chat component has initialised`));``
- ``document.addEventListener("gms-chat-display-state", (prevState, newState) => alert(`Display state changed from "${event.detail.prevDisplayState}" to "${event.detail.newDisplayState}"`));``
- ``document.addEventListener("gms-chat-navigate", (event) => alert(`Navigate to "${event.detail.target}"`));``
- _Deprecated, use gms-chat-display-state_ `document.addEventListener("gms-chat-close", () => alert("Chat window has closed"));`

All events generated by the component are prefixed with `gms-chat-`.

## Fonts

If the embedding application includes the "Sage UI" fonts,
the component will use them, otherwise it will fall back
to Arial and friends. We don't embed the Sage fonts in the
component to keep the size to a minimum.

## Content Security Policy (CSP)

Here is a minimal CSP required if you are hosting `gms-chat-ui.js` on your server.

```
default-src 'self';
script-src 'self' 'unsafe-inline';
style-src 'self' 'unsafe-inline';
connect-src 'self' https://api.gms.development.eu-west-1.sageai.sagecloudops.com https://api.gms.pre-production.eu-west-1.sageai.sagecloudops.com https://api.gms.production.eu-west-1.sageai.sagecloudops.com;
img-src 'self' data:;
```

_Note_ that the URLs in `connect-src` can be reduced depending on which services you are using.
