// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/index.d.ts
declare module '@sage/x3-stock-data/index' {
	export * from '@sage/x3-stock-data/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/index.d.ts
declare module '@sage/x3-stock-data/lib/index' {
	export * as enums from '@sage/x3-stock-data/lib/enums/index';
	export * as menuItems from '@sage/x3-stock-data/lib/menu-items/index';
	export * as nodeExtensions from '@sage/x3-stock-data/lib/node-extensions/index';
	export * as nodes from '@sage/x3-stock-data/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-stock-data/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/service-options/index.d.ts
declare module '@sage/x3-stock-data/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/warehouse.d.ts
declare module '@sage/x3-stock-data/lib/nodes/warehouse' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class Warehouse extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	}
	//# sourceMappingURL=warehouse.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/stock.d.ts
declare module '@sage/x3-stock-data/lib/nodes/stock' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, decimal, date, integer, Collection } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class Stock extends Node {
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly stockId: Promise<decimal | null>;
	    readonly owner: Promise<string>;
	    readonly product: Reference<sageX3MasterData.nodes.ProductSite>;
	    readonly lot: Promise<string>;
	    readonly sublot: Promise<string>;
	    readonly supplierLot: Promise<string>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly status: Reference<sageX3StockData.nodes.StockStatus>;
	    readonly location: Reference<sageX3StockData.nodes.Location | null>;
	    readonly locationType: Promise<string>;
	    readonly locationCategory: Promise<sageX3StockData.enums.LocationCategory | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly serialNumber: Promise<string>;
	    readonly receiptDate: Promise<date | null>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly activeQuantityInStockUnit: Promise<decimal | null>;
	    readonly originalPackingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly originalQuantityInPackingUnit: Promise<decimal | null>;
	    readonly originalQuantityInStockUnit: Promise<decimal | null>;
	    readonly qualityAnalysisRequestId: Promise<string>;
	    readonly allocatedQuantity: Promise<decimal | null>;
	    readonly allocatedActiveQuantity: Promise<decimal | null>;
	    readonly inProcessQuantity: Promise<decimal | null>;
	    readonly inProcessActiveQuantity: Promise<decimal | null>;
	    readonly editedFlag: Promise<integer | null>;
	    readonly lastReceiptDate: Promise<date | null>;
	    readonly lastIssueDate: Promise<date | null>;
	    readonly lastCountDate: Promise<date | null>;
	    readonly isBeingCounted: Promise<boolean>;
	    readonly countWorksheet: Promise<string>;
	    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly stockCustomField1: Promise<string>;
	    readonly stockCustomField2: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly productCollection: Collection<sageX3MasterData.nodes.Product>;
	    readonly lotReference: Reference<sageX3StockData.nodes.Lot | null>;
	    readonly availableQuantity: Promise<decimal | null>;
	}
	//# sourceMappingURL=stock.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/stock-status.d.ts
declare module '@sage/x3-stock-data/lib/nodes/stock-status' {
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class StockStatus extends Node {
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly expiredQStatus: Reference<sageX3StockData.nodes.StockStatus | null>;
	    readonly expiredRStatus: Reference<sageX3StockData.nodes.StockStatus | null>;
	}
	//# sourceMappingURL=stock-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/stock-management-rules.d.ts
declare module '@sage/x3-stock-data/lib/nodes/stock-management-rules' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class StockManagementRules extends Node {
	    readonly productCategory: Reference<sageX3MasterData.nodes.ProductCategory | null>;
	    readonly stockSite: Reference<sageX3System.nodes.Site | null>;
	    readonly transactionType: Promise<sageX3StockData.enums.StockTransactionType>;
	    readonly stockMovementCode: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly locationNumber: Promise<sageX3StockData.enums.TitleOfLocationForStockManagementRules | null>;
	    readonly locationNumber2: Promise<sageX3StockData.enums.TitleOfLocationForStockManagementRules | null>;
	    readonly locationNumber3: Promise<sageX3StockData.enums.TitleOfLocationForStockManagementRules | null>;
	    readonly authorizedStatus: Promise<sageX3StockData.enums.QualityFilter1 | null>;
	    readonly authorizedSubstatus: Promise<string>;
	    readonly defaultStatus: Promise<string>;
	    readonly formula: Promise<string>;
	    readonly hasAnalysisRequest: Promise<boolean>;
	    readonly lotEntry: Promise<sageX3StockData.enums.PackingSequence | null>;
	    readonly lotByDefault: Promise<sageX3StockData.enums.DefaultLot | null>;
	    readonly outputLot: Promise<sageX3MasterData.enums.LotIssueExpirationUbd | null>;
	    readonly prototypeVersion: Promise<sageX3StockData.enums.PrototypeOrActiveVersion | null>;
	    readonly activeVersion: Promise<sageX3StockData.enums.PrototypeOrActiveVersion | null>;
	    readonly versionStopped: Promise<sageX3StockData.enums.VersionStopped | null>;
	    readonly isExclusiveEntryVersion: Promise<boolean>;
	    readonly licensePlateNumberEntry: Promise<sageX3StockData.enums.LicensePlateNumberEntry | null>;
	}
	//# sourceMappingURL=stock-management-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/stock-journal.d.ts
declare module '@sage/x3-stock-data/lib/nodes/stock-journal' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, decimal } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class StockJournal extends Node {
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly isUpdated: Promise<boolean>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly effectiveDate: Promise<date | null>;
	    readonly sequence: Promise<integer | null>;
	    readonly index: Promise<integer | null>;
	    readonly fifoDate: Promise<date | null>;
	    readonly fifoTime: Promise<string>;
	    readonly fifoTier: Promise<decimal | null>;
	    readonly owner: Promise<string>;
	    readonly lot: Promise<string>;
	    readonly sublot: Promise<string>;
	    readonly supplierLot: Promise<string>;
	    readonly location: Reference<sageX3StockData.nodes.Location | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly serialNumber: Promise<string>;
	    readonly transactionType: Promise<sageX3StockData.enums.StockTransactionType | null>;
	    readonly stockMovementGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly movementDescription: Promise<string>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly businessPartner: Reference<sageX3MasterData.nodes.BusinessPartner | null>;
	    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly documentId: Promise<string>;
	    readonly documentLine: Promise<integer | null>;
	    readonly documentTypeOriginal: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly documentIdOriginal: Promise<string>;
	    readonly documentLineOriginal: Promise<integer | null>;
	    readonly documentSequenceOriginal: Promise<integer | null>;
	    readonly adjustementType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly adjustementDocumentId: Promise<string>;
	    readonly adjustementDocumentLineId: Promise<integer | null>;
	    readonly lotCustomField1: Promise<string>;
	    readonly lotCustomField2: Promise<string>;
	    readonly lotCustomField3: Promise<decimal | null>;
	    readonly lotCustomField4: Promise<date | null>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantityInPackingUnit: Promise<decimal | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly quantityInStockUnit: Promise<decimal | null>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly orginialPackingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly originalPackingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly orderAmount: Promise<decimal | null>;
	    readonly movementValue: Promise<decimal | null>;
	    readonly orderVariance: Promise<decimal | null>;
	    readonly movementVariance: Promise<decimal | null>;
	    readonly orderCost: Promise<decimal | null>;
	    readonly valuedCost: Promise<decimal | null>;
	    readonly costSource: Promise<sageX3StockData.enums.CostSource | null>;
	    readonly secondaryMovementValue: Promise<decimal | null>;
	    readonly secondaryMovementVariance: Promise<decimal | null>;
	    readonly secondaryValuedCost: Promise<decimal | null>;
	    readonly secondaryCostSource: Promise<sageX3StockData.enums.CostSource | null>;
	    readonly isAdjusted: Promise<boolean>;
	    readonly varianceNotAbsorbed: Promise<decimal | null>;
	    readonly secondaryVarianceNotAbsorbed: Promise<decimal | null>;
	    readonly expirationDate: Promise<date | null>;
	    readonly status: Reference<sageX3StockData.nodes.StockStatus>;
	    readonly potency: Promise<decimal | null>;
	    readonly internationalUnitPotency: Promise<decimal | null>;
	    readonly activQuantity: Promise<decimal | null>;
	    readonly qualityAnalysisRequestId: Promise<string>;
	    readonly isPrinted: Promise<boolean>;
	    readonly isAdjustedMovement: Promise<boolean>;
	    readonly labelFormat: Reference<sageX3System.nodes.GenericPrintReport | null>;
	    readonly numberOfLabels: Promise<integer | null>;
	    readonly financialSite: Reference<sageX3System.nodes.Site | null>;
	    readonly hasStockInterfacePosted: Promise<boolean>;
	    readonly hasStockAccountingPosted: Promise<boolean>;
	    readonly hasStockAccountingPostedSecondary: Promise<boolean>;
	    readonly identifier1: Promise<string>;
	    readonly identifier2: Promise<string>;
	    readonly intercompany: Promise<boolean>;
	    readonly useByDate: Promise<date | null>;
	    readonly recontrolDate: Promise<date | null>;
	    readonly accountingDate: Promise<date | null>;
	    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorVersion: Promise<string>;
	    readonly startingSerialNumber: Promise<string>;
	    readonly stockCustomField1: Promise<string>;
	    readonly endingSerialNumber: Promise<string>;
	    readonly stockCustomField2: Promise<string>;
	    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	}
	//# sourceMappingURL=stock-journal.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/serial-number.d.ts
declare module '@sage/x3-stock-data/lib/nodes/serial-number' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class SerialNumber extends Node {
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly code: Promise<string>;
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly documentId: Promise<string>;
	    readonly documentLine: Promise<integer | null>;
	    readonly receiptDate: Promise<date | null>;
	    readonly receiptSite: Reference<sageX3System.nodes.Site | null>;
	    readonly receiptDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly receiptDocumentId: Promise<string>;
	    readonly receiptDocumentLine: Promise<integer | null>;
	    readonly customer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly issueDocumentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly issueDocumentId: Promise<string>;
	    readonly issueDocumentLine: Promise<integer | null>;
	    readonly issueDate: Promise<date | null>;
	    readonly warrantyEndDate: Promise<date | null>;
	    readonly stockId: Promise<decimal | null>;
	    readonly stockLine: Reference<sageX3StockData.nodes.Stock>;
	}
	//# sourceMappingURL=serial-number.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/product-site-internal-containers.d.ts
declare module '@sage/x3-stock-data/lib/nodes/product-site-internal-containers' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	export class ProductSiteInternalContainers extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly product: Promise<string>;
	    readonly stockSite: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ProductSite>;
	    readonly internalContainer: Reference<sageX3MasterData.nodes.Container | null>;
	}
	//# sourceMappingURL=product-site-internal-containers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/product-site-default-locations.d.ts
declare module '@sage/x3-stock-data/lib/nodes/product-site-default-locations' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class ProductSiteDefaultLocations extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly product: Promise<string>;
	    readonly stockSite: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ProductSite>;
	    readonly locationNumber: Promise<sageX3StockData.enums.TitleOfLocation | null>;
	    readonly defaultLocationType: Promise<string>;
	    readonly defaultLocation: Promise<string>;
	}
	//# sourceMappingURL=product-site-default-locations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/product-category-packing-units.d.ts
declare module '@sage/x3-stock-data/lib/nodes/product-category-packing-units' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	export class ProductCategoryPackingUnits extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly stockSite: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ProductCategory>;
	    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
	    readonly isPackingFactorEntryAllowed: Promise<boolean>;
	    readonly issuingPackingRule: Promise<sageX3MasterData.enums.UnpackingRulesPac | null>;
	    readonly labelFormat: Reference<sageX3System.nodes.GenericPrintReport | null>;
	}
	//# sourceMappingURL=product-category-packing-units.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/product-category-overheads.d.ts
declare module '@sage/x3-stock-data/lib/nodes/product-category-overheads' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class ProductCategoryOverheads extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly stockSite: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ProductCategory>;
	    readonly transactionType: Promise<sageX3StockData.enums.StockTransactionType | null>;
	    readonly overhead: Reference<sageX3StockData.nodes.Overhead | null>;
	    readonly isLowerLevelOverheadIncluded: Promise<boolean>;
	}
	//# sourceMappingURL=product-category-overheads.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/product-category-default-locations.d.ts
declare module '@sage/x3-stock-data/lib/nodes/product-category-default-locations' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class ProductCategoryDefaultLocations extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly stockSite: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3MasterData.nodes.ProductCategory>;
	    readonly locationNumber: Promise<sageX3StockData.enums.TitleOfLocation | null>;
	    readonly defaultLocationType: Promise<string>;
	    readonly defaultLocation: Promise<string>;
	}
	//# sourceMappingURL=product-category-default-locations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/overhead.d.ts
declare module '@sage/x3-stock-data/lib/nodes/overhead' {
	import { Node, Collection } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class Overhead extends Node {
	    readonly overhead: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly formulaCodes: Collection<sageX3StockData.nodes.OverheadFormulaCodes>;
	}
	//# sourceMappingURL=overhead.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/overhead-formula-codes.d.ts
declare module '@sage/x3-stock-data/lib/nodes/overhead-formula-codes' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class OverheadFormulaCodes extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly overhead: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3StockData.nodes.Overhead>;
	    readonly trigger: Promise<sageX3MasterData.enums.Trigger | null>;
	}
	//# sourceMappingURL=overhead-formula-codes.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/mobile-settings.d.ts
declare module '@sage/x3-stock-data/lib/nodes/mobile-settings' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class MobileSettings extends Node {
	    readonly stockSite: Reference<sageX3System.nodes.Site | null>;
	    readonly flowType: Promise<sageX3StockData.enums.AdcFlowType>;
	    readonly stockField1: Promise<sageX3StockData.enums.StockSearchFilter>;
	    readonly stockField2: Promise<sageX3StockData.enums.StockSearchFilter>;
	    readonly stockField3: Promise<sageX3StockData.enums.StockSearchFilter>;
	    readonly stockField4: Promise<sageX3StockData.enums.StockSearchFilter>;
	    readonly stockField5: Promise<sageX3StockData.enums.StockSearchFilter>;
	    readonly stockField6: Promise<sageX3StockData.enums.StockSearchFilter>;
	    readonly stockField7: Promise<sageX3StockData.enums.StockSearchFilter>;
	    readonly stockField8: Promise<sageX3StockData.enums.StockSearchFilter>;
	}
	//# sourceMappingURL=mobile-settings.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/major-version-status.d.ts
declare module '@sage/x3-stock-data/lib/nodes/major-version-status' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, Reference, date, Collection } from '@sage/xtrem-core';
	export class MajorVersionStatus extends Node {
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly code: Promise<string>;
	    readonly description: Promise<string>;
	    readonly shortDescription: Promise<string>;
	    readonly status: Promise<sageX3MasterData.enums.VersionStatus | null>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly isSubjectToException: Promise<boolean>;
	    readonly exceptionDate: Promise<date | null>;
	    readonly isOnHold: Promise<boolean>;
	    readonly minorVersions: Collection<sageX3MasterData.nodes.ProductVersion>;
	}
	//# sourceMappingURL=major-version-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/lots-sites.d.ts
declare module '@sage/x3-stock-data/lib/nodes/lots-sites' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, decimal, date, Collection } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class LotsSites extends Node {
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly lot: Promise<string>;
	    readonly sublot: Promise<string>;
	    readonly storageSite: Reference<sageX3System.nodes.Site>;
	    readonly acceptedQuantityAStatus: Promise<decimal | null>;
	    readonly qcQStatus: Promise<decimal | null>;
	    readonly rejectedQuantityRStatus: Promise<decimal | null>;
	    readonly averageCost: Promise<decimal | null>;
	    readonly aucBaseQuantity: Promise<decimal | null>;
	    readonly aucBaseAmount: Promise<decimal | null>;
	    readonly mapSubConCost: Promise<decimal | null>;
	    readonly invoicingElement: Promise<decimal | null>;
	    readonly mapMaterialOh: Promise<decimal | null>;
	    readonly mapMachineOh: Promise<decimal | null>;
	    readonly mapLaborOh: Promise<decimal | null>;
	    readonly mapSubConOh: Promise<decimal | null>;
	    readonly mapSubConCost1: Promise<decimal | null>;
	    readonly invoicingElement1: Promise<decimal | null>;
	    readonly mapMaterialOh1: Promise<decimal | null>;
	    readonly mapMachineOh1: Promise<decimal | null>;
	    readonly mapLaborOh1: Promise<decimal | null>;
	    readonly mapSubConOh1: Promise<decimal | null>;
	    readonly lastReceiptDate: Promise<date | null>;
	    readonly lastIssueDate: Promise<date | null>;
	    readonly lastCountDate: Promise<date | null>;
	    readonly stock: Collection<sageX3StockData.nodes.Stock>;
	}
	//# sourceMappingURL=lots-sites.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/lot.d.ts
declare module '@sage/x3-stock-data/lib/nodes/lot' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class Lot extends Node {
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly code: Promise<string>;
	    readonly sublot: Promise<string>;
	    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly documentId: Promise<string>;
	    readonly documentLine: Promise<integer | null>;
	    readonly supplierLot: Promise<string>;
	    readonly lotCustomField1: Promise<string>;
	    readonly lotCustomField2: Promise<string>;
	    readonly lotCustomField3: Promise<decimal | null>;
	    readonly lotCustomField4: Promise<date | null>;
	    readonly lotCreationDate: Promise<date | null>;
	    readonly expirationReferenceDate: Promise<date | null>;
	    readonly shelfLife: Promise<integer | null>;
	    readonly expirationDate: Promise<date | null>;
	    readonly potency: Promise<decimal | null>;
	    readonly internationalUnitPotency: Promise<decimal | null>;
	    readonly supplier: Reference<sageX3MasterData.nodes.Supplier | null>;
	    readonly expirationTimeUnit: Promise<sageX3StockData.enums.ExpirationLeadTimeUnits | null>;
	    readonly recontrolTimeUnit: Promise<sageX3StockData.enums.ExpirationLeadTimeUnits | null>;
	    readonly checkLeadTime: Promise<integer | null>;
	    readonly recontrolDate: Promise<date | null>;
	    readonly useByDateCoefficient: Promise<decimal | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly controlDate: Promise<date | null>;
	    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorVersion: Promise<string>;
	    readonly stock: Collection<sageX3StockData.nodes.Stock>;
	}
	//# sourceMappingURL=lot.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/location.d.ts
declare module '@sage/x3-stock-data/lib/nodes/location' {
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class Location extends Node {
	    readonly stockSite: Reference<sageX3System.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly availability: Promise<sageX3StockData.enums.StorageLocationCode | null>;
	    readonly type: Promise<string>;
	    readonly category: Promise<sageX3StockData.enums.LocationCategory | null>;
	    readonly isSingleProduct: Promise<boolean>;
	    readonly isDedicated: Promise<boolean>;
	    readonly authorizedSubstatus: Promise<string>;
	    readonly isBlocked: Promise<boolean>;
	    readonly isBeingCounted: Promise<boolean>;
	    readonly stock: Collection<sageX3StockData.nodes.Stock>;
	}
	//# sourceMappingURL=location.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/license-plate-number.d.ts
declare module '@sage/x3-stock-data/lib/nodes/license-plate-number' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, Collection } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class LicensePlateNumber extends Node {
	    readonly code: Promise<string>;
	    readonly stockSite: Reference<sageX3System.nodes.Site | null>;
	    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
	    readonly locationType: Promise<string>;
	    readonly location: Reference<sageX3StockData.nodes.Location | null>;
	    readonly container: Reference<sageX3MasterData.nodes.Container | null>;
	    readonly isActive: Promise<boolean>;
	    readonly isSingleProduct: Promise<boolean>;
	    readonly isSingleLot: Promise<boolean>;
	    readonly firstDateOfUse: Promise<date | null>;
	    readonly lastDateOfUse: Promise<date | null>;
	    readonly masterLicensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
	    readonly status: Promise<sageX3StockData.enums.ContainerStatus | null>;
	    readonly isPrinted: Promise<boolean>;
	    readonly documentEntryType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
	    readonly documentEntry: Promise<string>;
	    readonly stock: Collection<sageX3StockData.nodes.Stock>;
	}
	//# sourceMappingURL=license-plate-number.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/nodes/index.d.ts
declare module '@sage/x3-stock-data/lib/nodes/index' {
	export * from '@sage/x3-stock-data/lib/nodes/license-plate-number';
	export * from '@sage/x3-stock-data/lib/nodes/location';
	export * from '@sage/x3-stock-data/lib/nodes/lot';
	export * from '@sage/x3-stock-data/lib/nodes/lots-sites';
	export * from '@sage/x3-stock-data/lib/nodes/major-version-status';
	export * from '@sage/x3-stock-data/lib/nodes/mobile-settings';
	export * from '@sage/x3-stock-data/lib/nodes/overhead-formula-codes';
	export * from '@sage/x3-stock-data/lib/nodes/overhead';
	export * from '@sage/x3-stock-data/lib/nodes/product-category-default-locations';
	export * from '@sage/x3-stock-data/lib/nodes/product-category-overheads';
	export * from '@sage/x3-stock-data/lib/nodes/product-category-packing-units';
	export * from '@sage/x3-stock-data/lib/nodes/product-site-default-locations';
	export * from '@sage/x3-stock-data/lib/nodes/product-site-internal-containers';
	export * from '@sage/x3-stock-data/lib/nodes/serial-number';
	export * from '@sage/x3-stock-data/lib/nodes/stock-journal';
	export * from '@sage/x3-stock-data/lib/nodes/stock-management-rules';
	export * from '@sage/x3-stock-data/lib/nodes/stock-status';
	export * from '@sage/x3-stock-data/lib/nodes/stock';
	export * from '@sage/x3-stock-data/lib/nodes/warehouse';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/node-extensions/product-site-extension.d.ts
declare module '@sage/x3-stock-data/lib/node-extensions/product-site-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class ProductSiteExtension extends NodeExtension<sageX3MasterData.nodes.ProductSite> {
	    readonly reorderingManagementMode: Promise<sageX3StockData.enums.ReorderingManagementMode | null>;
	    readonly recontrolTimeUnit: Promise<sageX3StockData.enums.ExpirationLeadTimeUnits | null>;
	    readonly defaultInternalContainer: Reference<sageX3MasterData.nodes.Container | null>;
	    readonly defaultLocations: Collection<sageX3StockData.nodes.ProductSiteDefaultLocations>;
	    readonly internalContainers: Collection<sageX3StockData.nodes.ProductSiteInternalContainers>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product-site' {
	    interface ProductSite extends ProductSiteExtension {
	    }
	}
	//# sourceMappingURL=product-site-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/node-extensions/product-extension.d.ts
declare module '@sage/x3-stock-data/lib/node-extensions/product-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	import { NodeExtension } from '@sage/xtrem-core';
	export class ProductExtension extends NodeExtension<sageX3MasterData.nodes.Product> {
	    readonly stockManagementMode: Promise<sageX3MasterData.enums.StockManagement | null>;
	    readonly lotManagementMode: Promise<sageX3StockData.enums.LotManagementMode | null>;
	    readonly materialCostGroup: Promise<sageX3StockData.enums.MaterialCostGroup | null>;
	    readonly traceabilityManagementMode: Promise<sageX3StockData.enums.TraceabilityManagementMode | null>;
	    readonly traceabilityLevel: Promise<sageX3StockData.enums.TraceabilityLevel | null>;
	    readonly expirationTimeUnit: Promise<sageX3StockData.enums.ExpirationLeadTimeUnits | null>;
	    readonly recontrolTimeUnit: Promise<sageX3StockData.enums.ExpirationLeadTimeUnits | null>;
	    readonly stockVersionMode: Promise<sageX3StockData.enums.StockVersionMode | null>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product' {
	    interface Product extends ProductExtension {
	    }
	}
	//# sourceMappingURL=product-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/node-extensions/product-category-extension.d.ts
declare module '@sage/x3-stock-data/lib/node-extensions/product-category-extension' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { NodeExtension, Collection } from '@sage/xtrem-core';
	import * as sageX3StockData from '@sage/x3-stock-data/lib/index';
	export class ProductCategoryExtension extends NodeExtension<sageX3MasterData.nodes.ProductCategory> {
	    readonly lotManagementMode: Promise<sageX3StockData.enums.LotManagementMode | null>;
	    readonly traceabilityManagementMode: Promise<sageX3StockData.enums.TraceabilityManagementMode | null>;
	    readonly traceabilityLevel: Promise<sageX3StockData.enums.TraceabilityLevel | null>;
	    readonly materialCostGroup: Promise<sageX3StockData.enums.MaterialCostGroup | null>;
	    readonly reorderingManagementMode: Promise<sageX3StockData.enums.ReorderingManagementMode | null>;
	    readonly stockVersionMode: Promise<sageX3StockData.enums.StockVersionMode | null>;
	    readonly stockManagementRules: Collection<sageX3StockData.nodes.StockManagementRules>;
	    readonly defaultLocations: Collection<sageX3StockData.nodes.ProductCategoryDefaultLocations>;
	    readonly overheads: Collection<sageX3StockData.nodes.ProductCategoryOverheads>;
	    readonly packingUnits: Collection<sageX3StockData.nodes.ProductCategoryPackingUnits>;
	}
	declare module '@sage/x3-master-data/lib/nodes/product-category' {
	    interface ProductCategory extends ProductCategoryExtension {
	    }
	}
	//# sourceMappingURL=product-category-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-stock-data/lib/node-extensions/index' {
	export * from '@sage/x3-stock-data/lib/node-extensions/product-category-extension';
	export * from '@sage/x3-stock-data/lib/node-extensions/product-extension';
	export * from '@sage/x3-stock-data/lib/node-extensions/product-site-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/menu-items/transfer.d.ts
declare module '@sage/x3-stock-data/lib/menu-items/transfer' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const transfer: RootMenuItem;
	//# sourceMappingURL=transfer.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/menu-items/stock-identifier.d.ts
declare module '@sage/x3-stock-data/lib/menu-items/stock-identifier' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const stockByIdentifier: RootMenuItem;
	//# sourceMappingURL=stock-identifier.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/menu-items/stock-control.d.ts
declare module '@sage/x3-stock-data/lib/menu-items/stock-control' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const stockControl: RootMenuItem;
	//# sourceMappingURL=stock-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/menu-items/receipt.d.ts
declare module '@sage/x3-stock-data/lib/menu-items/receipt' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const receipt: RootMenuItem;
	//# sourceMappingURL=receipt.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/menu-items/picking.d.ts
declare module '@sage/x3-stock-data/lib/menu-items/picking' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const picking: RootMenuItem;
	//# sourceMappingURL=picking.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/menu-items/other.d.ts
declare module '@sage/x3-stock-data/lib/menu-items/other' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const other: RootMenuItem;
	//# sourceMappingURL=other.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/menu-items/lpn.d.ts
declare module '@sage/x3-stock-data/lib/menu-items/lpn' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const lpn: RootMenuItem;
	//# sourceMappingURL=lpn.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/menu-items/index.d.ts
declare module '@sage/x3-stock-data/lib/menu-items/index' {
	export * from '@sage/x3-stock-data/lib/menu-items/lpn';
	export * from '@sage/x3-stock-data/lib/menu-items/other';
	export * from '@sage/x3-stock-data/lib/menu-items/picking';
	export * from '@sage/x3-stock-data/lib/menu-items/receipt';
	export * from '@sage/x3-stock-data/lib/menu-items/stock-control';
	export * from '@sage/x3-stock-data/lib/menu-items/stock-identifier';
	export * from '@sage/x3-stock-data/lib/menu-items/transfer';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/wip-protection.d.ts
declare module '@sage/x3-stock-data/lib/enums/wip-protection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WipProtectionEnum {
	    no = 1,
	    always = 2,
	    accordingToProduct = 3
	}
	export interface WipProtection$EnumInterface {
	    no: 1;
	    always: 2;
	    accordingToProduct: 3;
	}
	export type WipProtection = keyof WipProtection$EnumInterface;
	export const wipProtectionDatatype: X3EnumDataType<keyof WipProtection$EnumInterface, unknown>;
	//# sourceMappingURL=wip-protection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/wip-classification.d.ts
declare module '@sage/x3-stock-data/lib/enums/wip-classification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum WipClassificationEnum {
	    byProduct = 1,
	    byOrderType = 2,
	    byDocumentType = 3
	}
	export interface WipClassification$EnumInterface {
	    byProduct: 1;
	    byOrderType: 2;
	    byDocumentType: 3;
	}
	export type WipClassification = keyof WipClassification$EnumInterface;
	export const wipClassificationDatatype: X3EnumDataType<keyof WipClassification$EnumInterface, unknown>;
	//# sourceMappingURL=wip-classification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/version-stopped.d.ts
declare module '@sage/x3-stock-data/lib/enums/version-stopped' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VersionStoppedEnum {
	    no = 1,
	    noUnlessException = 2,
	    yes = 3
	}
	export interface VersionStopped$EnumInterface {
	    no: 1;
	    noUnlessException: 2;
	    yes: 3;
	}
	export type VersionStopped = keyof VersionStopped$EnumInterface;
	export const versionStoppedDatatype: X3EnumDataType<keyof VersionStopped$EnumInterface, unknown>;
	//# sourceMappingURL=version-stopped.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/version-entered.d.ts
declare module '@sage/x3-stock-data/lib/enums/version-entered' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum VersionEnteredEnum {
	    exclusive = 1,
	    priority = 2
	}
	export interface VersionEntered$EnumInterface {
	    exclusive: 1;
	    priority: 2;
	}
	export type VersionEntered = keyof VersionEntered$EnumInterface;
	export const versionEnteredDatatype: X3EnumDataType<keyof VersionEntered$EnumInterface, unknown>;
	//# sourceMappingURL=version-entered.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/value-change.d.ts
declare module '@sage/x3-stock-data/lib/enums/value-change' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValueChangeEnum {
	    global = 1,
	    fifo = 2,
	    lot = 3
	}
	export interface ValueChange$EnumInterface {
	    global: 1;
	    fifo: 2;
	    lot: 3;
	}
	export type ValueChange = keyof ValueChange$EnumInterface;
	export const valueChangeDatatype: X3EnumDataType<keyof ValueChange$EnumInterface, unknown>;
	//# sourceMappingURL=value-change.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/valuation-variance-absorption.d.ts
declare module '@sage/x3-stock-data/lib/enums/valuation-variance-absorption' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValuationVarianceAbsorptionEnum {
	    no = 1,
	    absorptionOnSite = 2,
	    absorptionOnSiteLot = 3
	}
	export interface ValuationVarianceAbsorption$EnumInterface {
	    no: 1;
	    absorptionOnSite: 2;
	    absorptionOnSiteLot: 3;
	}
	export type ValuationVarianceAbsorption = keyof ValuationVarianceAbsorption$EnumInterface;
	export const valuationVarianceAbsorptionDatatype: X3EnumDataType<keyof ValuationVarianceAbsorption$EnumInterface, unknown>;
	//# sourceMappingURL=valuation-variance-absorption.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/valuation-method.d.ts
declare module '@sage/x3-stock-data/lib/enums/valuation-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValuationMethodEnum {
	    standardCost = 1,
	    revisedStandardCost = 2,
	    lastCost = 3,
	    movingAverageCost = 4,
	    fifoCost = 5,
	    averageLotCost = 6,
	    orderCost = 7,
	    lifoCost = 8,
	    primaryIssueMethod = 9,
	    budgetCost = 10,
	    simulatedCost = 11,
	    priceList = 12,
	    secondaryIssueMethod = 13
	}
	export interface ValuationMethod$EnumInterface {
	    standardCost: 1;
	    revisedStandardCost: 2;
	    lastCost: 3;
	    movingAverageCost: 4;
	    fifoCost: 5;
	    averageLotCost: 6;
	    orderCost: 7;
	    lifoCost: 8;
	    primaryIssueMethod: 9;
	    budgetCost: 10;
	    simulatedCost: 11;
	    priceList: 12;
	    secondaryIssueMethod: 13;
	}
	export type ValuationMethod = keyof ValuationMethod$EnumInterface;
	export const valuationMethodDatatype: X3EnumDataType<keyof ValuationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=valuation-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/valuation-method-758.d.ts
declare module '@sage/x3-stock-data/lib/enums/valuation-method-758' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ValuationMethod758Enum {
	    none = 1,
	    managementControl = 2,
	    specific = 3
	}
	export interface ValuationMethod758$EnumInterface {
	    none: 1;
	    managementControl: 2;
	    specific: 3;
	}
	export type ValuationMethod758 = keyof ValuationMethod758$EnumInterface;
	export const valuationMethod758Datatype: X3EnumDataType<keyof ValuationMethod758$EnumInterface, unknown>;
	//# sourceMappingURL=valuation-method-758.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/type-of-stock-transaction.d.ts
declare module '@sage/x3-stock-data/lib/enums/type-of-stock-transaction' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfStockTransactionEnum {
	    miscellaneousReceipt = 1,
	    miscellaneousIssue = 2,
	    stockChange = 3,
	    lotModification = 4,
	    putawayPlan = 5,
	    counting = 6,
	    assemblyDisassembly = 7,
	    qualityControl = 8,
	    reorderPlan = 9,
	    shipmentPickingPlan = 10,
	    packing = 11,
	    pickTickets = 12
	}
	export interface TypeOfStockTransaction$EnumInterface {
	    miscellaneousReceipt: 1;
	    miscellaneousIssue: 2;
	    stockChange: 3;
	    lotModification: 4;
	    putawayPlan: 5;
	    counting: 6;
	    assemblyDisassembly: 7;
	    qualityControl: 8;
	    reorderPlan: 9;
	    shipmentPickingPlan: 10;
	    packing: 11;
	    pickTickets: 12;
	}
	export type TypeOfStockTransaction = keyof TypeOfStockTransaction$EnumInterface;
	export const typeOfStockTransactionDatatype: X3EnumDataType<keyof TypeOfStockTransaction$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-stock-transaction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/type-of-cost-calculation.d.ts
declare module '@sage/x3-stock-data/lib/enums/type-of-cost-calculation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfCostCalculationEnum {
	    noCalculation = 1,
	    productCost = 2,
	    referenceProductCost = 3,
	    zeroCost = 4,
	    priceNotFound = 5,
	    calculated = 6,
	    zeroCalculated = 7,
	    intermediateCalculation = 8
	}
	export interface TypeOfCostCalculation$EnumInterface {
	    noCalculation: 1;
	    productCost: 2;
	    referenceProductCost: 3;
	    zeroCost: 4;
	    priceNotFound: 5;
	    calculated: 6;
	    zeroCalculated: 7;
	    intermediateCalculation: 8;
	}
	export type TypeOfCostCalculation = keyof TypeOfCostCalculation$EnumInterface;
	export const typeOfCostCalculationDatatype: X3EnumDataType<keyof TypeOfCostCalculation$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-cost-calculation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/type-of-calculation-table.d.ts
declare module '@sage/x3-stock-data/lib/enums/type-of-calculation-table' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TypeOfCalculationTableEnum {
	    simpleCalculationTable = 1,
	    conversionTable = 2,
	    doubleEntryTable = 3
	}
	export interface TypeOfCalculationTable$EnumInterface {
	    simpleCalculationTable: 1;
	    conversionTable: 2;
	    doubleEntryTable: 3;
	}
	export type TypeOfCalculationTable = keyof TypeOfCalculationTable$EnumInterface;
	export const typeOfCalculationTableDatatype: X3EnumDataType<keyof TypeOfCalculationTable$EnumInterface, unknown>;
	//# sourceMappingURL=type-of-calculation-table.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/transfer-selection.d.ts
declare module '@sage/x3-stock-data/lib/enums/transfer-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransferSelectionEnum {
	    site = 1,
	    customer = 2,
	    supplier = 3
	}
	export interface TransferSelection$EnumInterface {
	    site: 1;
	    customer: 2;
	    supplier: 3;
	}
	export type TransferSelection = keyof TransferSelection$EnumInterface;
	export const transferSelectionDatatype: X3EnumDataType<keyof TransferSelection$EnumInterface, unknown>;
	//# sourceMappingURL=transfer-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/transfer-replenishment-status.d.ts
declare module '@sage/x3-stock-data/lib/enums/transfer-replenishment-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransferReplenishmentStatusEnum {
	    pending = 1,
	    allocated = 2,
	    beingShipped = 3
	}
	export interface TransferReplenishmentStatus$EnumInterface {
	    pending: 1;
	    allocated: 2;
	    beingShipped: 3;
	}
	export type TransferReplenishmentStatus = keyof TransferReplenishmentStatus$EnumInterface;
	export const transferReplenishmentStatusDatatype: X3EnumDataType<keyof TransferReplenishmentStatus$EnumInterface, unknown>;
	//# sourceMappingURL=transfer-replenishment-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/transaction-type-selection.d.ts
declare module '@sage/x3-stock-data/lib/enums/transaction-type-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransactionTypeSelectionEnum {
	    allTypes = 1,
	    miscellaneousReceipt = 2,
	    miscellaneousIssue = 3,
	    supplierReceipt = 4,
	    customerShipment = 5,
	    workOrderReceipt = 6,
	    workOrderIssue = 7,
	    locationChange = 8,
	    qualityControl = 9,
	    statusChange = 10,
	    transferReceipt = 11,
	    returnReceipt = 12,
	    deliveryReturn = 13,
	    stockCount = 14
	}
	export interface TransactionTypeSelection$EnumInterface {
	    allTypes: 1;
	    miscellaneousReceipt: 2;
	    miscellaneousIssue: 3;
	    supplierReceipt: 4;
	    customerShipment: 5;
	    workOrderReceipt: 6;
	    workOrderIssue: 7;
	    locationChange: 8;
	    qualityControl: 9;
	    statusChange: 10;
	    transferReceipt: 11;
	    returnReceipt: 12;
	    deliveryReturn: 13;
	    stockCount: 14;
	}
	export type TransactionTypeSelection = keyof TransactionTypeSelection$EnumInterface;
	export const transactionTypeSelectionDatatype: X3EnumDataType<keyof TransactionTypeSelection$EnumInterface, unknown>;
	//# sourceMappingURL=transaction-type-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/transaction-status.d.ts
declare module '@sage/x3-stock-data/lib/enums/transaction-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransactionStatusEnum {
	    accordingToProductOrder = 1,
	    statusA = 2,
	    statusQ = 3,
	    statusAQ = 4,
	    statusR = 5,
	    statusAR = 6,
	    statusQR = 7,
	    statusAQR = 8
	}
	export interface TransactionStatus$EnumInterface {
	    accordingToProductOrder: 1;
	    statusA: 2;
	    statusQ: 3;
	    statusAQ: 4;
	    statusR: 5;
	    statusAR: 6;
	    statusQR: 7;
	    statusAQR: 8;
	}
	export type TransactionStatus = keyof TransactionStatus$EnumInterface;
	export const transactionStatusDatatype: X3EnumDataType<keyof TransactionStatus$EnumInterface, unknown>;
	//# sourceMappingURL=transaction-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/transaction-lot-management.d.ts
declare module '@sage/x3-stock-data/lib/enums/transaction-lot-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransactionLotManagementEnum {
	    free = 1,
	    newLot = 2,
	    supplierLot = 3,
	    receiptNumberWorkOrderNumber = 4,
	    fifoAllLots = 5,
	    fifoUnexpiredLots = 6,
	    fifoExpiredLots = 7,
	    fefoAllLots = 8,
	    fefoUnexpiredLots = 9,
	    fefoExpiredLots = 10,
	    accordingToProduct = 11
	}
	export interface TransactionLotManagement$EnumInterface {
	    free: 1;
	    newLot: 2;
	    supplierLot: 3;
	    receiptNumberWorkOrderNumber: 4;
	    fifoAllLots: 5;
	    fifoUnexpiredLots: 6;
	    fifoExpiredLots: 7;
	    fefoAllLots: 8;
	    fefoUnexpiredLots: 9;
	    fefoExpiredLots: 10;
	    accordingToProduct: 11;
	}
	export type TransactionLotManagement = keyof TransactionLotManagement$EnumInterface;
	export const transactionLotManagementDatatype: X3EnumDataType<keyof TransactionLotManagement$EnumInterface, unknown>;
	//# sourceMappingURL=transaction-lot-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/transaction-location-managemen.d.ts
declare module '@sage/x3-stock-data/lib/enums/transaction-location-managemen' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TransactionLocationManagemenEnum {
	    noEntry = 1,
	    freeEntry = 2,
	    accordingToProduct = 3,
	    accordingToTransaction = 4,
	    automatic = 5
	}
	export interface TransactionLocationManagemen$EnumInterface {
	    noEntry: 1;
	    freeEntry: 2;
	    accordingToProduct: 3;
	    accordingToTransaction: 4;
	    automatic: 5;
	}
	export type TransactionLocationManagemen = keyof TransactionLocationManagemen$EnumInterface;
	export const transactionLocationManagemenDatatype: X3EnumDataType<keyof TransactionLocationManagemen$EnumInterface, unknown>;
	//# sourceMappingURL=transaction-location-managemen.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/traceability-management-mode.d.ts
declare module '@sage/x3-stock-data/lib/enums/traceability-management-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TraceabilityManagementModeEnum {
	    noTraceability = 1,
	    detailedTraceability = 2,
	    summaryTraceability = 3
	}
	export interface TraceabilityManagementMode$EnumInterface {
	    noTraceability: 1;
	    detailedTraceability: 2;
	    summaryTraceability: 3;
	}
	export type TraceabilityManagementMode = keyof TraceabilityManagementMode$EnumInterface;
	export const traceabilityManagementModeDatatype: X3EnumDataType<keyof TraceabilityManagementMode$EnumInterface, unknown>;
	//# sourceMappingURL=traceability-management-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/traceability-level.d.ts
declare module '@sage/x3-stock-data/lib/enums/traceability-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TraceabilityLevelEnum {
	    byDefault = 1,
	    lot = 2,
	    subLot = 3,
	    serialNumber = 4
	}
	export interface TraceabilityLevel$EnumInterface {
	    byDefault: 1;
	    lot: 2;
	    subLot: 3;
	    serialNumber: 4;
	}
	export type TraceabilityLevel = keyof TraceabilityLevel$EnumInterface;
	export const traceabilityLevelDatatype: X3EnumDataType<keyof TraceabilityLevel$EnumInterface, unknown>;
	//# sourceMappingURL=traceability-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/trace-level-in-stock-updates.d.ts
declare module '@sage/x3-stock-data/lib/enums/trace-level-in-stock-updates' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TraceLevelInStockUpdatesEnum {
	    noTrace = 1,
	    standardTraceMessages = 2,
	    detailedTraceTableUpdates = 3,
	    detailedTraceFieldUpdates = 4
	}
	export interface TraceLevelInStockUpdates$EnumInterface {
	    noTrace: 1;
	    standardTraceMessages: 2;
	    detailedTraceTableUpdates: 3;
	    detailedTraceFieldUpdates: 4;
	}
	export type TraceLevelInStockUpdates = keyof TraceLevelInStockUpdates$EnumInterface;
	export const traceLevelInStockUpdatesDatatype: X3EnumDataType<keyof TraceLevelInStockUpdates$EnumInterface, unknown>;
	//# sourceMappingURL=trace-level-in-stock-updates.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/title-of-location.d.ts
declare module '@sage/x3-stock-data/lib/enums/title-of-location' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TitleOfLocationEnum {
	    receipt = 1,
	    stock = 2,
	    picking = 3,
	    workstation = 4,
	    delivery = 5,
	    store = 6,
	    customerReturn = 7,
	    returnFromReturn = 8,
	    toBeDefined = 9,
	    toBeDefined1 = 10,
	    toBeDefined2 = 11
	}
	export interface TitleOfLocation$EnumInterface {
	    receipt: 1;
	    stock: 2;
	    picking: 3;
	    workstation: 4;
	    delivery: 5;
	    store: 6;
	    customerReturn: 7;
	    returnFromReturn: 8;
	    toBeDefined: 9;
	    toBeDefined1: 10;
	    toBeDefined2: 11;
	}
	export type TitleOfLocation = keyof TitleOfLocation$EnumInterface;
	export const titleOfLocationDatatype: X3EnumDataType<keyof TitleOfLocation$EnumInterface, unknown>;
	//# sourceMappingURL=title-of-location.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/title-of-location-for-stock-management-rules.d.ts
declare module '@sage/x3-stock-data/lib/enums/title-of-location-for-stock-management-rules' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TitleOfLocationForStockManagementRulesEnum {
	    v0 = 1,
	    receipt = 2,
	    stock = 3,
	    picking = 4,
	    workstation = 5,
	    delivery = 6,
	    store = 7,
	    customerReturn = 8,
	    returnFromReturn = 9,
	    toBeDefined = 10,
	    toBeDefined1 = 11,
	    toBeDefined2 = 12
	}
	export interface TitleOfLocationForStockManagementRules$EnumInterface {
	    v0: 1;
	    receipt: 2;
	    stock: 3;
	    picking: 4;
	    workstation: 5;
	    delivery: 6;
	    store: 7;
	    customerReturn: 8;
	    returnFromReturn: 9;
	    toBeDefined: 10;
	    toBeDefined1: 11;
	    toBeDefined2: 12;
	}
	export type TitleOfLocationForStockManagementRules = keyof TitleOfLocationForStockManagementRules$EnumInterface;
	export const titleOfLocationForStockManagementRulesDatatype: X3EnumDataType<keyof TitleOfLocationForStockManagementRules$EnumInterface, unknown>;
	//# sourceMappingURL=title-of-location-for-stock-management-rules.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/take-qc-stock-into-account.d.ts
declare module '@sage/x3-stock-data/lib/enums/take-qc-stock-into-account' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum TakeQcStockIntoAccountEnum {
	    no = 1,
	    yesInStartingStock = 2,
	    yesAtDateEndControl = 3
	}
	export interface TakeQcStockIntoAccount$EnumInterface {
	    no: 1;
	    yesInStartingStock: 2;
	    yesAtDateEndControl: 3;
	}
	export type TakeQcStockIntoAccount = keyof TakeQcStockIntoAccount$EnumInterface;
	export const takeQcStockIntoAccountDatatype: X3EnumDataType<keyof TakeQcStockIntoAccount$EnumInterface, unknown>;
	//# sourceMappingURL=take-qc-stock-into-account.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/symbol-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/symbol-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SymbolTypeEnum {
	    question = 1,
	    variable = 2,
	    scenario = 3,
	    selection = 4,
	    optionsVariants = 5,
	    linkTable = 6,
	    procedure = 7,
	    message = 8,
	    formsTemplates = 9,
	    free10 = 10,
	    comment = 11,
	    entryPoint = 12,
	    masterProduct = 13,
	    productSite = 14,
	    productTotals = 15,
	    soldProducts = 16,
	    bomHeader = 17,
	    bomDetail = 18,
	    routeHeader = 19,
	    routeOperation = 20,
	    productSales = 21,
	    operationScheduling = 22,
	    productCosts = 23,
	    materialCost = 24,
	    machineCost = 25,
	    laborCost = 26,
	    subcontractCost = 27,
	    supplierProduct = 28,
	    free = 29,
	    formula = 30
	}
	export interface SymbolType$EnumInterface {
	    question: 1;
	    variable: 2;
	    scenario: 3;
	    selection: 4;
	    optionsVariants: 5;
	    linkTable: 6;
	    procedure: 7;
	    message: 8;
	    formsTemplates: 9;
	    free10: 10;
	    comment: 11;
	    entryPoint: 12;
	    masterProduct: 13;
	    productSite: 14;
	    productTotals: 15;
	    soldProducts: 16;
	    bomHeader: 17;
	    bomDetail: 18;
	    routeHeader: 19;
	    routeOperation: 20;
	    productSales: 21;
	    operationScheduling: 22;
	    productCosts: 23;
	    materialCost: 24;
	    machineCost: 25;
	    laborCost: 26;
	    subcontractCost: 27;
	    supplierProduct: 28;
	    free: 29;
	    formula: 30;
	}
	export type SymbolType = keyof SymbolType$EnumInterface;
	export const symbolTypeDatatype: X3EnumDataType<keyof SymbolType$EnumInterface, unknown>;
	//# sourceMappingURL=symbol-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/symbol-control.d.ts
declare module '@sage/x3-stock-data/lib/enums/symbol-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SymbolControlEnum {
	    noControl = 1,
	    listOfValues = 2,
	    table = 3,
	    formsTemplates = 4,
	    ranges = 5,
	    miscellaneousTable = 6
	}
	export interface SymbolControl$EnumInterface {
	    noControl: 1;
	    listOfValues: 2;
	    table: 3;
	    formsTemplates: 4;
	    ranges: 5;
	    miscellaneousTable: 6;
	}
	export type SymbolControl = keyof SymbolControl$EnumInterface;
	export const symbolControlDatatype: X3EnumDataType<keyof SymbolControl$EnumInterface, unknown>;
	//# sourceMappingURL=symbol-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/supply-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/supply-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SupplyTypeEnum {
	    external = 1,
	    internalIntersite = 2,
	    externalAndInternal = 3
	}
	export interface SupplyType$EnumInterface {
	    external: 1;
	    internalIntersite: 2;
	    externalAndInternal: 3;
	}
	export type SupplyType = keyof SupplyType$EnumInterface;
	export const supplyTypeDatatype: X3EnumDataType<keyof SupplyType$EnumInterface, unknown>;
	//# sourceMappingURL=supply-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/suggestion-splitting.d.ts
declare module '@sage/x3-stock-data/lib/enums/suggestion-splitting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SuggestionSplittingEnum {
	    none = 1,
	    parallel = 2,
	    successive = 3
	}
	export interface SuggestionSplitting$EnumInterface {
	    none: 1;
	    parallel: 2;
	    successive: 3;
	}
	export type SuggestionSplitting = keyof SuggestionSplitting$EnumInterface;
	export const suggestionSplittingDatatype: X3EnumDataType<keyof SuggestionSplitting$EnumInterface, unknown>;
	//# sourceMappingURL=suggestion-splitting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/suggested-locations.d.ts
declare module '@sage/x3-stock-data/lib/enums/suggested-locations' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SuggestedLocationsEnum {
	    allLocations = 1,
	    basedOnProductSetup = 2
	}
	export interface SuggestedLocations$EnumInterface {
	    allLocations: 1;
	    basedOnProductSetup: 2;
	}
	export type SuggestedLocations = keyof SuggestedLocations$EnumInterface;
	export const suggestedLocationsDatatype: X3EnumDataType<keyof SuggestedLocations$EnumInterface, unknown>;
	//# sourceMappingURL=suggested-locations.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/suggested-location.d.ts
declare module '@sage/x3-stock-data/lib/enums/suggested-location' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SuggestedLocationEnum {
	    none = 1,
	    storageLocation = 2,
	    receivingLocation = 3,
	    pickingLocation = 4,
	    floorStockLocation = 5,
	    bpLocation = 6
	}
	export interface SuggestedLocation$EnumInterface {
	    none: 1;
	    storageLocation: 2;
	    receivingLocation: 3;
	    pickingLocation: 4;
	    floorStockLocation: 5;
	    bpLocation: 6;
	}
	export type SuggestedLocation = keyof SuggestedLocation$EnumInterface;
	export const suggestedLocationDatatype: X3EnumDataType<keyof SuggestedLocation$EnumInterface, unknown>;
	//# sourceMappingURL=suggested-location.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/subcontract-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/subcontract-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SubcontractTypeEnum {
	    site = 1,
	    supplier = 2
	}
	export interface SubcontractType$EnumInterface {
	    site: 1;
	    supplier: 2;
	}
	export type SubcontractType = keyof SubcontractType$EnumInterface;
	export const subcontractTypeDatatype: X3EnumDataType<keyof SubcontractType$EnumInterface, unknown>;
	//# sourceMappingURL=subcontract-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/storage-location-code.d.ts
declare module '@sage/x3-stock-data/lib/enums/storage-location-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StorageLocationCodeEnum {
	    empty = 1,
	    occupied = 2,
	    full = 3
	}
	export interface StorageLocationCode$EnumInterface {
	    empty: 1;
	    occupied: 2;
	    full: 3;
	}
	export type StorageLocationCode = keyof StorageLocationCode$EnumInterface;
	export const storageLocationCodeDatatype: X3EnumDataType<keyof StorageLocationCode$EnumInterface, unknown>;
	//# sourceMappingURL=storage-location-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-version-mode.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-version-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockVersionModeEnum {
	    no = 1,
	    major = 2,
	    majorAndMinor = 3
	}
	export interface StockVersionMode$EnumInterface {
	    no: 1;
	    major: 2;
	    majorAndMinor: 3;
	}
	export type StockVersionMode = keyof StockVersionMode$EnumInterface;
	export const stockVersionModeDatatype: X3EnumDataType<keyof StockVersionMode$EnumInterface, unknown>;
	//# sourceMappingURL=stock-version-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-user-defined-fields.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-user-defined-fields' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockUserDefinedFieldsEnum {
	    lotCustomText1 = 1,
	    lotCustomText2 = 2,
	    lotCustomNumber = 3,
	    lotCustomDate = 4
	}
	export interface StockUserDefinedFields$EnumInterface {
	    lotCustomText1: 1;
	    lotCustomText2: 2;
	    lotCustomNumber: 3;
	    lotCustomDate: 4;
	}
	export type StockUserDefinedFields = keyof StockUserDefinedFields$EnumInterface;
	export const stockUserDefinedFieldsDatatype: X3EnumDataType<keyof StockUserDefinedFields$EnumInterface, unknown>;
	//# sourceMappingURL=stock-user-defined-fields.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-transaction-validation.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-transaction-validation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockTransactionValidationEnum {
	    noValidation = 1,
	    withoutSummary = 2,
	    withSummary = 3
	}
	export interface StockTransactionValidation$EnumInterface {
	    noValidation: 1;
	    withoutSummary: 2;
	    withSummary: 3;
	}
	export type StockTransactionValidation = keyof StockTransactionValidation$EnumInterface;
	export const stockTransactionValidationDatatype: X3EnumDataType<keyof StockTransactionValidation$EnumInterface, unknown>;
	//# sourceMappingURL=stock-transaction-validation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-transaction-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-transaction-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockTransactionTypeEnum {
	    miscellaneousReceipt = 1,
	    miscellaneousIssue = 2,
	    supplierReceipt = 3,
	    customerDelivery = 4,
	    workOrderReceipt = 5,
	    workOrderIssue = 6,
	    locationChange = 7,
	    qualityControl = 8,
	    statusChange = 9,
	    intersiteTransferReceiptNotActive = 10,
	    receiptReturn = 11,
	    deliveryReturn = 12,
	    count = 13,
	    intersiteTransfer = 14,
	    transferForSubcontractNotActive = 15,
	    subcontractReceipt = 16,
	    loanDelivery = 17,
	    loanDeliveryReturn = 18,
	    stockReturn = 19,
	    subcontractDelivery = 20,
	    resplitting = 21,
	    putawayPlan = 22,
	    valueChange = 23,
	    serviceRequest = 24,
	    replenishment = 25,
	    stockChange = 26,
	    internalTransferIssue = 27,
	    internalTransferReceipt = 28,
	    subcontractIssue = 29,
	    loanReceiptNotActive = 30,
	    loanReceiptReturnNotActive = 31,
	    subcontractReceiptReturn = 32,
	    subcontractDeliveryReturn = 33,
	    analysisRequest = 34,
	    stockValueAdjustment = 35,
	    licensePlateNumberChange = 36
	}
	export interface StockTransactionType$EnumInterface {
	    miscellaneousReceipt: 1;
	    miscellaneousIssue: 2;
	    supplierReceipt: 3;
	    customerDelivery: 4;
	    workOrderReceipt: 5;
	    workOrderIssue: 6;
	    locationChange: 7;
	    qualityControl: 8;
	    statusChange: 9;
	    intersiteTransferReceiptNotActive: 10;
	    receiptReturn: 11;
	    deliveryReturn: 12;
	    count: 13;
	    intersiteTransfer: 14;
	    transferForSubcontractNotActive: 15;
	    subcontractReceipt: 16;
	    loanDelivery: 17;
	    loanDeliveryReturn: 18;
	    stockReturn: 19;
	    subcontractDelivery: 20;
	    resplitting: 21;
	    putawayPlan: 22;
	    valueChange: 23;
	    serviceRequest: 24;
	    replenishment: 25;
	    stockChange: 26;
	    internalTransferIssue: 27;
	    internalTransferReceipt: 28;
	    subcontractIssue: 29;
	    loanReceiptNotActive: 30;
	    loanReceiptReturnNotActive: 31;
	    subcontractReceiptReturn: 32;
	    subcontractDeliveryReturn: 33;
	    analysisRequest: 34;
	    stockValueAdjustment: 35;
	    licensePlateNumberChange: 36;
	}
	export type StockTransactionType = keyof StockTransactionType$EnumInterface;
	export const stockTransactionTypeDatatype: X3EnumDataType<keyof StockTransactionType$EnumInterface, unknown>;
	//# sourceMappingURL=stock-transaction-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-transaction-status.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-transaction-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockTransactionStatusEnum {
	    updated = 1,
	    suspended = 2
	}
	export interface StockTransactionStatus$EnumInterface {
	    updated: 1;
	    suspended: 2;
	}
	export type StockTransactionStatus = keyof StockTransactionStatus$EnumInterface;
	export const stockTransactionStatusDatatype: X3EnumDataType<keyof StockTransactionStatus$EnumInterface, unknown>;
	//# sourceMappingURL=stock-transaction-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-take-sequence.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-take-sequence' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockTakeSequenceEnum {
	    productLocation = 1,
	    locationProduct = 2
	}
	export interface StockTakeSequence$EnumInterface {
	    productLocation: 1;
	    locationProduct: 2;
	}
	export type StockTakeSequence = keyof StockTakeSequence$EnumInterface;
	export const stockTakeSequenceDatatype: X3EnumDataType<keyof StockTakeSequence$EnumInterface, unknown>;
	//# sourceMappingURL=stock-take-sequence.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-status-enum.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-status-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockStatusEnumEnum {
	    accepted = 1,
	    qualityControl = 2,
	    rejected = 3
	}
	export interface StockStatusEnum$EnumInterface {
	    accepted: 1;
	    qualityControl: 2;
	    rejected: 3;
	}
	export type StockStatusEnum = keyof StockStatusEnum$EnumInterface;
	export const stockStatusEnumDatatype: X3EnumDataType<keyof StockStatusEnum$EnumInterface, unknown>;
	//# sourceMappingURL=stock-status-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-shortage-adjustment.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-shortage-adjustment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockShortageAdjustmentEnum {
	    noProcess = 1,
	    suspendedTransactions = 2,
	    backordersMaterialIssues = 3,
	    backordersSalesOrders = 4
	}
	export interface StockShortageAdjustment$EnumInterface {
	    noProcess: 1;
	    suspendedTransactions: 2;
	    backordersMaterialIssues: 3;
	    backordersSalesOrders: 4;
	}
	export type StockShortageAdjustment = keyof StockShortageAdjustment$EnumInterface;
	export const stockShortageAdjustmentDatatype: X3EnumDataType<keyof StockShortageAdjustment$EnumInterface, unknown>;
	//# sourceMappingURL=stock-shortage-adjustment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-sequence-numbers.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-sequence-numbers' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockSequenceNumbersEnum {
	    chronologicalStock = 1,
	    qualityAnalysis = 2,
	    chronologicalFifo = 3,
	    palletNumbers = 4,
	    containerNumbers = 5,
	    transfers = 6,
	    counts = 7,
	    globalLotNumber = 8,
	    wipHistory = 9,
	    miscellaneousReceiptTransactionDocument = 10,
	    miscellaneousIssueTransactionDocument = 11,
	    configurator = 12,
	    serialNumber = 13,
	    stockCountSessions = 14,
	    stockChanges = 15,
	    putAwayPlanReport = 16,
	    assembly = 17,
	    disassembly = 18,
	    putAwayPlanReorderPlan = 19,
	    consumptionAreaReorder = 20,
	    suggestions = 21,
	    valueChange = 22,
	    pickingList = 23,
	    pickTicket = 24,
	    packingPackageNumber = 25
	}
	export interface StockSequenceNumbers$EnumInterface {
	    chronologicalStock: 1;
	    qualityAnalysis: 2;
	    chronologicalFifo: 3;
	    palletNumbers: 4;
	    containerNumbers: 5;
	    transfers: 6;
	    counts: 7;
	    globalLotNumber: 8;
	    wipHistory: 9;
	    miscellaneousReceiptTransactionDocument: 10;
	    miscellaneousIssueTransactionDocument: 11;
	    configurator: 12;
	    serialNumber: 13;
	    stockCountSessions: 14;
	    stockChanges: 15;
	    putAwayPlanReport: 16;
	    assembly: 17;
	    disassembly: 18;
	    putAwayPlanReorderPlan: 19;
	    consumptionAreaReorder: 20;
	    suggestions: 21;
	    valueChange: 22;
	    pickingList: 23;
	    pickTicket: 24;
	    packingPackageNumber: 25;
	}
	export type StockSequenceNumbers = keyof StockSequenceNumbers$EnumInterface;
	export const stockSequenceNumbersDatatype: X3EnumDataType<keyof StockSequenceNumbers$EnumInterface, unknown>;
	//# sourceMappingURL=stock-sequence-numbers.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-search-filter.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-search-filter' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockSearchFilterEnum {
	    none = 1,
	    location = 2,
	    lot = 3,
	    sublot = 4,
	    serial = 5,
	    status = 6,
	    packingUnit = 7,
	    pacStkConversionFactor = 8,
	    identifier1 = 9,
	    identifier2 = 10,
	    licensePlateNumber = 11,
	    customField1 = 12,
	    customField2 = 13
	}
	export interface StockSearchFilter$EnumInterface {
	    none: 1;
	    location: 2;
	    lot: 3;
	    sublot: 4;
	    serial: 5;
	    status: 6;
	    packingUnit: 7;
	    pacStkConversionFactor: 8;
	    identifier1: 9;
	    identifier2: 10;
	    licensePlateNumber: 11;
	    customField1: 12;
	    customField2: 13;
	}
	export type StockSearchFilter = keyof StockSearchFilter$EnumInterface;
	export const stockSearchFilterDatatype: X3EnumDataType<keyof StockSearchFilter$EnumInterface, unknown>;
	//# sourceMappingURL=stock-search-filter.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-posting.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-posting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockPostingEnum {
	    no = 1,
	    yes = 2,
	    yesAutoDeletion = 3
	}
	export interface StockPosting$EnumInterface {
	    no: 1;
	    yes: 2;
	    yesAutoDeletion: 3;
	}
	export type StockPosting = keyof StockPosting$EnumInterface;
	export const stockPostingDatatype: X3EnumDataType<keyof StockPosting$EnumInterface, unknown>;
	//# sourceMappingURL=stock-posting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-mvt-origin.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-mvt-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockMvtOriginEnum {
	    aucun = 1,
	    documentOfOrigin = 2,
	    ligneDocument = 3,
	    receipts = 4,
	    document = 5
	}
	export interface StockMvtOrigin$EnumInterface {
	    aucun: 1;
	    documentOfOrigin: 2;
	    ligneDocument: 3;
	    receipts: 4;
	    document: 5;
	}
	export type StockMvtOrigin = keyof StockMvtOrigin$EnumInterface;
	export const stockMvtOriginDatatype: X3EnumDataType<keyof StockMvtOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=stock-mvt-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-movement-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-movement-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockMovementTypeEnum {
	    allReceipts = 1,
	    allIssues = 2,
	    miscellaneousReceipts = 3,
	    miscellaneousIssues = 4,
	    supplierReceipts = 5,
	    customerShipments = 6,
	    workOrderReceipts = 7,
	    workOrderIssues = 8,
	    locationChange = 9,
	    qualityControl = 10,
	    statusChange = 11,
	    intersiteTransferReceipt = 12,
	    returnOfReceipt = 13,
	    deliveryReturn = 14,
	    counting = 15,
	    intersiteTransfer = 16,
	    transferForSubcontracting = 17,
	    receiptForSubcontracting = 18,
	    loanDelivery = 19,
	    loanReturn = 20,
	    returnToStock = 21
	}
	export interface StockMovementType$EnumInterface {
	    allReceipts: 1;
	    allIssues: 2;
	    miscellaneousReceipts: 3;
	    miscellaneousIssues: 4;
	    supplierReceipts: 5;
	    customerShipments: 6;
	    workOrderReceipts: 7;
	    workOrderIssues: 8;
	    locationChange: 9;
	    qualityControl: 10;
	    statusChange: 11;
	    intersiteTransferReceipt: 12;
	    returnOfReceipt: 13;
	    deliveryReturn: 14;
	    counting: 15;
	    intersiteTransfer: 16;
	    transferForSubcontracting: 17;
	    receiptForSubcontracting: 18;
	    loanDelivery: 19;
	    loanReturn: 20;
	    returnToStock: 21;
	}
	export type StockMovementType = keyof StockMovementType$EnumInterface;
	export const stockMovementTypeDatatype: X3EnumDataType<keyof StockMovementType$EnumInterface, unknown>;
	//# sourceMappingURL=stock-movement-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-movement-date-choice.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-movement-date-choice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockMovementDateChoiceEnum {
	    creationDate = 1,
	    allocationDate = 2,
	    postingDate = 3
	}
	export interface StockMovementDateChoice$EnumInterface {
	    creationDate: 1;
	    allocationDate: 2;
	    postingDate: 3;
	}
	export type StockMovementDateChoice = keyof StockMovementDateChoice$EnumInterface;
	export const stockMovementDateChoiceDatatype: X3EnumDataType<keyof StockMovementDateChoice$EnumInterface, unknown>;
	//# sourceMappingURL=stock-movement-date-choice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-issue-code.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-issue-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockIssueCodeEnum {
	    byLot = 1,
	    fifo = 2,
	    fefo = 3
	}
	export interface StockIssueCode$EnumInterface {
	    byLot: 1;
	    fifo: 2;
	    fefo: 3;
	}
	export type StockIssueCode = keyof StockIssueCode$EnumInterface;
	export const stockIssueCodeDatatype: X3EnumDataType<keyof StockIssueCode$EnumInterface, unknown>;
	//# sourceMappingURL=stock-issue-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-inquiry-classification.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-inquiry-classification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockInquiryClassificationEnum {
	    site = 1,
	    product = 2,
	    lot = 3,
	    location = 4,
	    status = 5,
	    unit = 6,
	    allocationDate7 = 7,
	    serialNumber = 8,
	    allocationDate = 9,
	    dateCreated10 = 10,
	    dateCreated = 11,
	    identifier1 = 12
	}
	export interface StockInquiryClassification$EnumInterface {
	    site: 1;
	    product: 2;
	    lot: 3;
	    location: 4;
	    status: 5;
	    unit: 6;
	    allocationDate7: 7;
	    serialNumber: 8;
	    allocationDate: 9;
	    dateCreated10: 10;
	    dateCreated: 11;
	    identifier1: 12;
	}
	export type StockInquiryClassification = keyof StockInquiryClassification$EnumInterface;
	export const stockInquiryClassificationDatatype: X3EnumDataType<keyof StockInquiryClassification$EnumInterface, unknown>;
	//# sourceMappingURL=stock-inquiry-classification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-inquiries.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-inquiries' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockInquiriesEnum {
	    stockBySite = 1,
	    stockByLotLocation = 2,
	    lotLocationDetails = 3,
	    locationsByWarehouse = 4,
	    dedicatedLocations = 5,
	    locationsByProduct = 6,
	    substituteValue7 = 7,
	    substituteValue8 = 8,
	    expiredStock = 9,
	    serialNumbers = 10,
	    stockTransactions = 11,
	    stockAtDate = 12,
	    projectedStock = 13,
	    forwardTraceability = 14,
	    backwardTraceability = 15,
	    suspendedTransactions = 16,
	    productsBeingCounted = 17,
	    availableStock = 18,
	    documentTraceability = 19,
	    majorVersions = 20,
	    minorVersions = 21
	}
	export interface StockInquiries$EnumInterface {
	    stockBySite: 1;
	    stockByLotLocation: 2;
	    lotLocationDetails: 3;
	    locationsByWarehouse: 4;
	    dedicatedLocations: 5;
	    locationsByProduct: 6;
	    substituteValue7: 7;
	    substituteValue8: 8;
	    expiredStock: 9;
	    serialNumbers: 10;
	    stockTransactions: 11;
	    stockAtDate: 12;
	    projectedStock: 13;
	    forwardTraceability: 14;
	    backwardTraceability: 15;
	    suspendedTransactions: 16;
	    productsBeingCounted: 17;
	    availableStock: 18;
	    documentTraceability: 19;
	    majorVersions: 20;
	    minorVersions: 21;
	}
	export type StockInquiries = keyof StockInquiries$EnumInterface;
	export const stockInquiriesDatatype: X3EnumDataType<keyof StockInquiries$EnumInterface, unknown>;
	//# sourceMappingURL=stock-inquiries.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-data-calculation-errors.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-data-calculation-errors' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockDataCalculationErrorsEnum {
	    nullCalculationResult = 1,
	    insufficientHistory = 2,
	    undefinedHistoryProcessing = 3,
	    undefinedServiceRate = 4,
	    absentServiceRate = 5,
	    nullOrderProcessingCost = 6,
	    nullStockCarryingCost = 7,
	    nullProductStandardCost = 8
	}
	export interface StockDataCalculationErrors$EnumInterface {
	    nullCalculationResult: 1;
	    insufficientHistory: 2;
	    undefinedHistoryProcessing: 3;
	    undefinedServiceRate: 4;
	    absentServiceRate: 5;
	    nullOrderProcessingCost: 6;
	    nullStockCarryingCost: 7;
	    nullProductStandardCost: 8;
	}
	export type StockDataCalculationErrors = keyof StockDataCalculationErrors$EnumInterface;
	export const stockDataCalculationErrorsDatatype: X3EnumDataType<keyof StockDataCalculationErrors$EnumInterface, unknown>;
	//# sourceMappingURL=stock-data-calculation-errors.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-count-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-count-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockCountTypeEnum {
	    product = 1,
	    locations = 2
	}
	export interface StockCountType$EnumInterface {
	    product: 1;
	    locations: 2;
	}
	export type StockCountType = keyof StockCountType$EnumInterface;
	export const stockCountTypeDatatype: X3EnumDataType<keyof StockCountType$EnumInterface, unknown>;
	//# sourceMappingURL=stock-count-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-count-status-list.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-count-status-list' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockCountStatusListEnum {
	    toBeCounted = 1,
	    cancelled = 2,
	    counted = 3,
	    partialValidation = 4,
	    validated = 5,
	    closed = 6
	}
	export interface StockCountStatusList$EnumInterface {
	    toBeCounted: 1;
	    cancelled: 2;
	    counted: 3;
	    partialValidation: 4;
	    validated: 5;
	    closed: 6;
	}
	export type StockCountStatusList = keyof StockCountStatusList$EnumInterface;
	export const stockCountStatusListDatatype: X3EnumDataType<keyof StockCountStatusList$EnumInterface, unknown>;
	//# sourceMappingURL=stock-count-status-list.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-count-session-status.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-count-session-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockCountSessionStatusEnum {
	    inCreation = 1,
	    toBeCounted = 2,
	    closed = 3
	}
	export interface StockCountSessionStatus$EnumInterface {
	    inCreation: 1;
	    toBeCounted: 2;
	    closed: 3;
	}
	export type StockCountSessionStatus = keyof StockCountSessionStatus$EnumInterface;
	export const stockCountSessionStatusDatatype: X3EnumDataType<keyof StockCountSessionStatus$EnumInterface, unknown>;
	//# sourceMappingURL=stock-count-session-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-count-list-choice.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-count-list-choice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockCountListChoiceEnum {
	    manualSelection = 1,
	    cycleStockCount = 2,
	    annualStockCount = 3
	}
	export interface StockCountListChoice$EnumInterface {
	    manualSelection: 1;
	    cycleStockCount: 2;
	    annualStockCount: 3;
	}
	export type StockCountListChoice = keyof StockCountListChoice$EnumInterface;
	export const stockCountListChoiceDatatype: X3EnumDataType<keyof StockCountListChoice$EnumInterface, unknown>;
	//# sourceMappingURL=stock-count-list-choice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-count-lines-selection.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-count-lines-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockCountLinesSelectionEnum {
	    all = 1,
	    counted = 2,
	    toBeCounted = 3,
	    countedWithVariances = 4,
	    counted1 = 5,
	    counted2 = 6
	}
	export interface StockCountLinesSelection$EnumInterface {
	    all: 1;
	    counted: 2;
	    toBeCounted: 3;
	    countedWithVariances: 4;
	    counted1: 5;
	    counted2: 6;
	}
	export type StockCountLinesSelection = keyof StockCountLinesSelection$EnumInterface;
	export const stockCountLinesSelectionDatatype: X3EnumDataType<keyof StockCountLinesSelection$EnumInterface, unknown>;
	//# sourceMappingURL=stock-count-lines-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-count-grouping-status.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-count-grouping-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockCountGroupingStatusEnum {
	    toBeCounted = 1,
	    counted = 2,
	    abandon = 3,
	    validated = 4,
	    substituteValue5 = 5,
	    substituteValue6 = 6,
	    insertNull = 7,
	    partialCount = 8,
	    substituteValue9 = 9,
	    partialValidation = 10
	}
	export interface StockCountGroupingStatus$EnumInterface {
	    toBeCounted: 1;
	    counted: 2;
	    abandon: 3;
	    validated: 4;
	    substituteValue5: 5;
	    substituteValue6: 6;
	    insertNull: 7;
	    partialCount: 8;
	    substituteValue9: 9;
	    partialValidation: 10;
	}
	export type StockCountGroupingStatus = keyof StockCountGroupingStatus$EnumInterface;
	export const stockCountGroupingStatusDatatype: X3EnumDataType<keyof StockCountGroupingStatus$EnumInterface, unknown>;
	//# sourceMappingURL=stock-count-grouping-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-count-detail-status.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-count-detail-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockCountDetailStatusEnum {
	    toBeCounted = 1,
	    counted = 2,
	    abandoned = 3,
	    validated = 4
	}
	export interface StockCountDetailStatus$EnumInterface {
	    toBeCounted: 1;
	    counted: 2;
	    abandoned: 3;
	    validated: 4;
	}
	export type StockCountDetailStatus = keyof StockCountDetailStatus$EnumInterface;
	export const stockCountDetailStatusDatatype: X3EnumDataType<keyof StockCountDetailStatus$EnumInterface, unknown>;
	//# sourceMappingURL=stock-count-detail-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/stock-change-access.d.ts
declare module '@sage/x3-stock-data/lib/enums/stock-change-access' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum StockChangeAccessEnum {
	    stockLine = 1,
	    containerNumber = 2
	}
	export interface StockChangeAccess$EnumInterface {
	    stockLine: 1;
	    containerNumber: 2;
	}
	export type StockChangeAccess = keyof StockChangeAccess$EnumInterface;
	export const stockChangeAccessDatatype: X3EnumDataType<keyof StockChangeAccess$EnumInterface, unknown>;
	//# sourceMappingURL=stock-change-access.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/sort-put-away-plan.d.ts
declare module '@sage/x3-stock-data/lib/enums/sort-put-away-plan' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortPutAwayPlanEnum {
	    none = 1,
	    allocationDate = 2,
	    product = 3,
	    location = 4,
	    journalTypeNumber = 5
	}
	export interface SortPutAwayPlan$EnumInterface {
	    none: 1;
	    allocationDate: 2;
	    product: 3;
	    location: 4;
	    journalTypeNumber: 5;
	}
	export type SortPutAwayPlan = keyof SortPutAwayPlan$EnumInterface;
	export const sortPutAwayPlanDatatype: X3EnumDataType<keyof SortPutAwayPlan$EnumInterface, unknown>;
	//# sourceMappingURL=sort-put-away-plan.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/sort-by-coef.d.ts
declare module '@sage/x3-stock-data/lib/enums/sort-by-coef' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SortByCoefEnum {
	    no = 1,
	    descending = 2,
	    ascending = 3
	}
	export interface SortByCoef$EnumInterface {
	    no: 1;
	    descending: 2;
	    ascending: 3;
	}
	export type SortByCoef = keyof SortByCoef$EnumInterface;
	export const sortByCoefDatatype: X3EnumDataType<keyof SortByCoef$EnumInterface, unknown>;
	//# sourceMappingURL=sort-by-coef.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/serial-number-count.d.ts
declare module '@sage/x3-stock-data/lib/enums/serial-number-count' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SerialNumberCountEnum {
	    none = 1,
	    notControlled = 2,
	    validated = 3
	}
	export interface SerialNumberCount$EnumInterface {
	    none: 1;
	    notControlled: 2;
	    validated: 3;
	}
	export type SerialNumberCount = keyof SerialNumberCount$EnumInterface;
	export const serialNumberCountDatatype: X3EnumDataType<keyof SerialNumberCount$EnumInterface, unknown>;
	//# sourceMappingURL=serial-number-count.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/sequence-selection.d.ts
declare module '@sage/x3-stock-data/lib/enums/sequence-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SequenceSelectionEnum {
	    productNumber = 1,
	    productDescription = 2,
	    searchKey = 3,
	    productLine = 4,
	    cfgDocumentNumber = 5
	}
	export interface SequenceSelection$EnumInterface {
	    productNumber: 1;
	    productDescription: 2;
	    searchKey: 3;
	    productLine: 4;
	    cfgDocumentNumber: 5;
	}
	export type SequenceSelection = keyof SequenceSelection$EnumInterface;
	export const sequenceSelectionDatatype: X3EnumDataType<keyof SequenceSelection$EnumInterface, unknown>;
	//# sourceMappingURL=sequence-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/sequence-of-lots.d.ts
declare module '@sage/x3-stock-data/lib/enums/sequence-of-lots' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SequenceOfLotsEnum {
	    byLot = 1,
	    fifo = 2,
	    fefo = 3,
	    lifo = 4
	}
	export interface SequenceOfLots$EnumInterface {
	    byLot: 1;
	    fifo: 2;
	    fefo: 3;
	    lifo: 4;
	}
	export type SequenceOfLots = keyof SequenceOfLots$EnumInterface;
	export const sequenceOfLotsDatatype: X3EnumDataType<keyof SequenceOfLots$EnumInterface, unknown>;
	//# sourceMappingURL=sequence-of-lots.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/selection-of-serial-nos.d.ts
declare module '@sage/x3-stock-data/lib/enums/selection-of-serial-nos' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionOfSerialNosEnum {
	    add = 1,
	    subtract = 2
	}
	export interface SelectionOfSerialNos$EnumInterface {
	    add: 1;
	    subtract: 2;
	}
	export type SelectionOfSerialNos = keyof SelectionOfSerialNos$EnumInterface;
	export const selectionOfSerialNosDatatype: X3EnumDataType<keyof SelectionOfSerialNos$EnumInterface, unknown>;
	//# sourceMappingURL=selection-of-serial-nos.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/selection-classification.d.ts
declare module '@sage/x3-stock-data/lib/enums/selection-classification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectionClassificationEnum {
	    productNumber = 1,
	    orderNumber = 2,
	    subcontractor = 3
	}
	export interface SelectionClassification$EnumInterface {
	    productNumber: 1;
	    orderNumber: 2;
	    subcontractor: 3;
	}
	export type SelectionClassification = keyof SelectionClassification$EnumInterface;
	export const selectionClassificationDatatype: X3EnumDataType<keyof SelectionClassification$EnumInterface, unknown>;
	//# sourceMappingURL=selection-classification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/select-stock-movement-dates.d.ts
declare module '@sage/x3-stock-data/lib/enums/select-stock-movement-dates' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectStockMovementDatesEnum {
	    creationDate = 1,
	    allocationDate = 2
	}
	export interface SelectStockMovementDates$EnumInterface {
	    creationDate: 1;
	    allocationDate: 2;
	}
	export type SelectStockMovementDates = keyof SelectStockMovementDates$EnumInterface;
	export const selectStockMovementDatesDatatype: X3EnumDataType<keyof SelectStockMovementDates$EnumInterface, unknown>;
	//# sourceMappingURL=select-stock-movement-dates.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/select-date-of-put-away-plan.d.ts
declare module '@sage/x3-stock-data/lib/enums/select-date-of-put-away-plan' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SelectDateOfPutAwayPlanEnum {
	    creationDate = 1,
	    allocationDate = 2
	}
	export interface SelectDateOfPutAwayPlan$EnumInterface {
	    creationDate: 1;
	    allocationDate: 2;
	}
	export type SelectDateOfPutAwayPlan = keyof SelectDateOfPutAwayPlan$EnumInterface;
	export const selectDateOfPutAwayPlanDatatype: X3EnumDataType<keyof SelectDateOfPutAwayPlan$EnumInterface, unknown>;
	//# sourceMappingURL=select-date-of-put-away-plan.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/segment-type-edi.d.ts
declare module '@sage/x3-stock-data/lib/enums/segment-type-edi' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SegmentTypeEdiEnum {
	    moaMonetaryAmount = 1,
	    pcdPercentage = 2,
	    qtyQuantity = 3,
	    cuxCurrency = 4,
	    dtmDate = 5,
	    rffReference = 6,
	    nadCtaComAddress = 7,
	    ftxText = 8,
	    cciCavOgaOrganization = 9,
	    notManaged = 10
	}
	export interface SegmentTypeEdi$EnumInterface {
	    moaMonetaryAmount: 1;
	    pcdPercentage: 2;
	    qtyQuantity: 3;
	    cuxCurrency: 4;
	    dtmDate: 5;
	    rffReference: 6;
	    nadCtaComAddress: 7;
	    ftxText: 8;
	    cciCavOgaOrganization: 9;
	    notManaged: 10;
	}
	export type SegmentTypeEdi = keyof SegmentTypeEdi$EnumInterface;
	export const segmentTypeEdiDatatype: X3EnumDataType<keyof SegmentTypeEdi$EnumInterface, unknown>;
	//# sourceMappingURL=segment-type-edi.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/search-equivalence.d.ts
declare module '@sage/x3-stock-data/lib/enums/search-equivalence' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SearchEquivalenceEnum {
	    noSearch = 1,
	    searchEquivalence = 2,
	    alwaysCreate = 3,
	    searchAutomaticSelection = 4
	}
	export interface SearchEquivalence$EnumInterface {
	    noSearch: 1;
	    searchEquivalence: 2;
	    alwaysCreate: 3;
	    searchAutomaticSelection: 4;
	}
	export type SearchEquivalence = keyof SearchEquivalence$EnumInterface;
	export const searchEquivalenceDatatype: X3EnumDataType<keyof SearchEquivalence$EnumInterface, unknown>;
	//# sourceMappingURL=search-equivalence.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/scenario-line-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/scenario-line-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ScenarioLineTypeEnum {
	    selectParentProduct = 1,
	    createParentProduct = 2,
	    selectComponents = 3,
	    listComponents = 4,
	    createComponents = 5,
	    unused = 6,
	    listOperations = 7,
	    createOperations = 8,
	    finalControls = 9
	}
	export interface ScenarioLineType$EnumInterface {
	    selectParentProduct: 1;
	    createParentProduct: 2;
	    selectComponents: 3;
	    listComponents: 4;
	    createComponents: 5;
	    unused: 6;
	    listOperations: 7;
	    createOperations: 8;
	    finalControls: 9;
	}
	export type ScenarioLineType = keyof ScenarioLineType$EnumInterface;
	export const scenarioLineTypeDatatype: X3EnumDataType<keyof ScenarioLineType$EnumInterface, unknown>;
	//# sourceMappingURL=scenario-line-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/safety-stock-reconstitution.d.ts
declare module '@sage/x3-stock-data/lib/enums/safety-stock-reconstitution' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum SafetyStockReconstitutionEnum {
	    always = 1,
	    atFirstRequirement = 2
	}
	export interface SafetyStockReconstitution$EnumInterface {
	    always: 1;
	    atFirstRequirement: 2;
	}
	export type SafetyStockReconstitution = keyof SafetyStockReconstitution$EnumInterface;
	export const safetyStockReconstitutionDatatype: X3EnumDataType<keyof SafetyStockReconstitution$EnumInterface, unknown>;
	//# sourceMappingURL=safety-stock-reconstitution.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/replenishment-source.d.ts
declare module '@sage/x3-stock-data/lib/enums/replenishment-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReplenishmentSourceEnum {
	    replenishment = 1,
	    consumption = 2,
	    shortage = 3
	}
	export interface ReplenishmentSource$EnumInterface {
	    replenishment: 1;
	    consumption: 2;
	    shortage: 3;
	}
	export type ReplenishmentSource = keyof ReplenishmentSource$EnumInterface;
	export const replenishmentSourceDatatype: X3EnumDataType<keyof ReplenishmentSource$EnumInterface, unknown>;
	//# sourceMappingURL=replenishment-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/replanning-sort-order.d.ts
declare module '@sage/x3-stock-data/lib/enums/replanning-sort-order' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReplanningSortOrderEnum {
	    byProduct = 1,
	    byOrderType = 2,
	    byMessageType = 3,
	    byDate = 4
	}
	export interface ReplanningSortOrder$EnumInterface {
	    byProduct: 1;
	    byOrderType: 2;
	    byMessageType: 3;
	    byDate: 4;
	}
	export type ReplanningSortOrder = keyof ReplanningSortOrder$EnumInterface;
	export const replanningSortOrderDatatype: X3EnumDataType<keyof ReplanningSortOrder$EnumInterface, unknown>;
	//# sourceMappingURL=replanning-sort-order.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/replan-quantities.d.ts
declare module '@sage/x3-stock-data/lib/enums/replan-quantities' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReplanQuantitiesEnum {
	    none = 1,
	    decrease = 2,
	    increase = 3,
	    decreaseIncrease = 4
	}
	export interface ReplanQuantities$EnumInterface {
	    none: 1;
	    decrease: 2;
	    increase: 3;
	    decreaseIncrease: 4;
	}
	export type ReplanQuantities = keyof ReplanQuantities$EnumInterface;
	export const replanQuantitiesDatatype: X3EnumDataType<keyof ReplanQuantities$EnumInterface, unknown>;
	//# sourceMappingURL=replan-quantities.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/replan-date.d.ts
declare module '@sage/x3-stock-data/lib/enums/replan-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReplanDateEnum {
	    none = 1,
	    early = 2,
	    late = 3,
	    earlyLate = 4
	}
	export interface ReplanDate$EnumInterface {
	    none: 1;
	    early: 2;
	    late: 3;
	    earlyLate: 4;
	}
	export type ReplanDate = keyof ReplanDate$EnumInterface;
	export const replanDateDatatype: X3EnumDataType<keyof ReplanDate$EnumInterface, unknown>;
	//# sourceMappingURL=replan-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/reordering-management-mode.d.ts
declare module '@sage/x3-stock-data/lib/enums/reordering-management-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReorderingManagementModeEnum {
	    notManaged = 1,
	    byMrp = 2,
	    byMps = 3,
	    byRop = 4,
	    byPeriod = 5
	}
	export interface ReorderingManagementMode$EnumInterface {
	    notManaged: 1;
	    byMrp: 2;
	    byMps: 3;
	    byRop: 4;
	    byPeriod: 5;
	}
	export type ReorderingManagementMode = keyof ReorderingManagementMode$EnumInterface;
	export const reorderingManagementModeDatatype: X3EnumDataType<keyof ReorderingManagementMode$EnumInterface, unknown>;
	//# sourceMappingURL=reordering-management-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/reorder-situation.d.ts
declare module '@sage/x3-stock-data/lib/enums/reorder-situation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReorderSituationEnum {
	    waitingReorder = 1,
	    reorderPlan = 2
	}
	export interface ReorderSituation$EnumInterface {
	    waitingReorder: 1;
	    reorderPlan: 2;
	}
	export type ReorderSituation = keyof ReorderSituation$EnumInterface;
	export const reorderSituationDatatype: X3EnumDataType<keyof ReorderSituation$EnumInterface, unknown>;
	//# sourceMappingURL=reorder-situation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/reorder-selection-outside-of-m.d.ts
declare module '@sage/x3-stock-data/lib/enums/reorder-selection-outside-of-m' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReorderSelectionOutsideOfMEnum {
	    no = 1,
	    yes = 2,
	    calculationOnly = 3
	}
	export interface ReorderSelectionOutsideOfM$EnumInterface {
	    no: 1;
	    yes: 2;
	    calculationOnly: 3;
	}
	export type ReorderSelectionOutsideOfM = keyof ReorderSelectionOutsideOfM$EnumInterface;
	export const reorderSelectionOutsideOfMDatatype: X3EnumDataType<keyof ReorderSelectionOutsideOfM$EnumInterface, unknown>;
	//# sourceMappingURL=reorder-selection-outside-of-m.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/reorder-calculation-method.d.ts
declare module '@sage/x3-stock-data/lib/enums/reorder-calculation-method' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReorderCalculationMethodEnum {
	    entered = 1,
	    calculated = 2
	}
	export interface ReorderCalculationMethod$EnumInterface {
	    entered: 1;
	    calculated: 2;
	}
	export type ReorderCalculationMethod = keyof ReorderCalculationMethod$EnumInterface;
	export const reorderCalculationMethodDatatype: X3EnumDataType<keyof ReorderCalculationMethod$EnumInterface, unknown>;
	//# sourceMappingURL=reorder-calculation-method.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/release-mode-management.d.ts
declare module '@sage/x3-stock-data/lib/enums/release-mode-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ReleaseModeManagementEnum {
	    immediately = 1,
	    temporarilyBlocked = 2,
	    blocked = 3
	}
	export interface ReleaseModeManagement$EnumInterface {
	    immediately: 1;
	    temporarilyBlocked: 2;
	    blocked: 3;
	}
	export type ReleaseModeManagement = keyof ReleaseModeManagement$EnumInterface;
	export const releaseModeManagementDatatype: X3EnumDataType<keyof ReleaseModeManagement$EnumInterface, unknown>;
	//# sourceMappingURL=release-mode-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/re-planning-selection.d.ts
declare module '@sage/x3-stock-data/lib/enums/re-planning-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum RePlanningSelectionEnum {
	    noProcessing = 1,
	    messagesOnly = 2,
	    simulation = 3
	}
	export interface RePlanningSelection$EnumInterface {
	    noProcessing: 1;
	    messagesOnly: 2;
	    simulation: 3;
	}
	export type RePlanningSelection = keyof RePlanningSelection$EnumInterface;
	export const rePlanningSelectionDatatype: X3EnumDataType<keyof RePlanningSelection$EnumInterface, unknown>;
	//# sourceMappingURL=re-planning-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/quantity-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/quantity-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QuantityTypeEnum {
	    physicalQuantity = 1,
	    activeQuantity = 2
	}
	export interface QuantityType$EnumInterface {
	    physicalQuantity: 1;
	    activeQuantity: 2;
	}
	export type QuantityType = keyof QuantityType$EnumInterface;
	export const quantityTypeDatatype: X3EnumDataType<keyof QuantityType$EnumInterface, unknown>;
	//# sourceMappingURL=quantity-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/quality-filter.d.ts
declare module '@sage/x3-stock-data/lib/enums/quality-filter' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QualityFilterEnum {
	    a = 1,
	    q = 2,
	    aQ = 3,
	    r = 4,
	    aR = 5,
	    qR = 6,
	    aQR = 7
	}
	export interface QualityFilter$EnumInterface {
	    a: 1;
	    q: 2;
	    aQ: 3;
	    r: 4;
	    aR: 5;
	    qR: 6;
	    aQR: 7;
	}
	export type QualityFilter = keyof QualityFilter$EnumInterface;
	export const qualityFilterDatatype: X3EnumDataType<keyof QualityFilter$EnumInterface, unknown>;
	//# sourceMappingURL=quality-filter.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/quality-filter-1.d.ts
declare module '@sage/x3-stock-data/lib/enums/quality-filter-1' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QualityFilter1Enum {
	    statusA = 1,
	    statusQ = 2,
	    statusAq = 3,
	    statusR = 4,
	    statusAr = 5,
	    statusQr = 6,
	    statusAqr = 7
	}
	export interface QualityFilter1$EnumInterface {
	    statusA: 1;
	    statusQ: 2;
	    statusAq: 3;
	    statusR: 4;
	    statusAr: 5;
	    statusQr: 6;
	    statusAqr: 7;
	}
	export type QualityFilter1 = keyof QualityFilter1$EnumInterface;
	export const qualityFilter1Datatype: X3EnumDataType<keyof QualityFilter1$EnumInterface, unknown>;
	//# sourceMappingURL=quality-filter-1.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/qty-pre-charged.d.ts
declare module '@sage/x3-stock-data/lib/enums/qty-pre-charged' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QtyPreChargedEnum {
	    allNotAllocatedAllocated = 1,
	    notAllocated = 2,
	    allocated = 3
	}
	export interface QtyPreCharged$EnumInterface {
	    allNotAllocatedAllocated: 1;
	    notAllocated: 2;
	    allocated: 3;
	}
	export type QtyPreCharged = keyof QtyPreCharged$EnumInterface;
	export const qtyPreChargedDatatype: X3EnumDataType<keyof QtyPreCharged$EnumInterface, unknown>;
	//# sourceMappingURL=qty-pre-charged.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/qty-assembly-disassembly.d.ts
declare module '@sage/x3-stock-data/lib/enums/qty-assembly-disassembly' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum QtyAssemblyDisassemblyEnum {
	    withoutShrinkage = 1,
	    withShrinkage = 2
	}
	export interface QtyAssemblyDisassembly$EnumInterface {
	    withoutShrinkage: 1;
	    withShrinkage: 2;
	}
	export type QtyAssemblyDisassembly = keyof QtyAssemblyDisassembly$EnumInterface;
	export const qtyAssemblyDisassemblyDatatype: X3EnumDataType<keyof QtyAssemblyDisassembly$EnumInterface, unknown>;
	//# sourceMappingURL=qty-assembly-disassembly.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/put-away-plan-situation.d.ts
declare module '@sage/x3-stock-data/lib/enums/put-away-plan-situation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PutAwayPlanSituationEnum {
	    awaitingPutAway = 1,
	    putAwayPlan = 2
	}
	export interface PutAwayPlanSituation$EnumInterface {
	    awaitingPutAway: 1;
	    putAwayPlan: 2;
	}
	export type PutAwayPlanSituation = keyof PutAwayPlanSituation$EnumInterface;
	export const putAwayPlanSituationDatatype: X3EnumDataType<keyof PutAwayPlanSituation$EnumInterface, unknown>;
	//# sourceMappingURL=put-away-plan-situation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/prototype-or-active-version.d.ts
declare module '@sage/x3-stock-data/lib/enums/prototype-or-active-version' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PrototypeOrActiveVersionEnum {
	    no = 1,
	    yesExceptOnHold = 2,
	    yes = 3
	}
	export interface PrototypeOrActiveVersion$EnumInterface {
	    no: 1;
	    yesExceptOnHold: 2;
	    yes: 3;
	}
	export type PrototypeOrActiveVersion = keyof PrototypeOrActiveVersion$EnumInterface;
	export const prototypeOrActiveVersionDatatype: X3EnumDataType<keyof PrototypeOrActiveVersion$EnumInterface, unknown>;
	//# sourceMappingURL=prototype-or-active-version.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/proposal-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/proposal-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProposalTypeEnum {
	    cancelsAndReplaces = 1,
	    complement = 2,
	    virtual = 3
	}
	export interface ProposalType$EnumInterface {
	    cancelsAndReplaces: 1;
	    complement: 2;
	    virtual: 3;
	}
	export type ProposalType = keyof ProposalType$EnumInterface;
	export const proposalTypeDatatype: X3EnumDataType<keyof ProposalType$EnumInterface, unknown>;
	//# sourceMappingURL=proposal-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/product-line-field-titles.d.ts
declare module '@sage/x3-stock-data/lib/enums/product-line-field-titles' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ProductLineFieldTitlesEnum {
	    notDefined = 1,
	    metal = 2,
	    size = 3,
	    ground = 4,
	    finishing = 5,
	    gears = 6,
	    chainSets = 7,
	    withDecimal = 8
	}
	export interface ProductLineFieldTitles$EnumInterface {
	    notDefined: 1;
	    metal: 2;
	    size: 3;
	    ground: 4;
	    finishing: 5;
	    gears: 6;
	    chainSets: 7;
	    withDecimal: 8;
	}
	export type ProductLineFieldTitles = keyof ProductLineFieldTitles$EnumInterface;
	export const productLineFieldTitlesDatatype: X3EnumDataType<keyof ProductLineFieldTitles$EnumInterface, unknown>;
	//# sourceMappingURL=product-line-field-titles.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/price-column.d.ts
declare module '@sage/x3-stock-data/lib/enums/price-column' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PriceColumnEnum {
	    noCalculation = 1,
	    formula = 2,
	    basePrice = 3,
	    priceList = 4,
	    standardCost = 5,
	    revisedStandardCost = 6,
	    lastPrice = 7,
	    calculatedByScenario = 8,
	    budget = 9
	}
	export interface PriceColumn$EnumInterface {
	    noCalculation: 1;
	    formula: 2;
	    basePrice: 3;
	    priceList: 4;
	    standardCost: 5;
	    revisedStandardCost: 6;
	    lastPrice: 7;
	    calculatedByScenario: 8;
	    budget: 9;
	}
	export type PriceColumn = keyof PriceColumn$EnumInterface;
	export const priceColumnDatatype: X3EnumDataType<keyof PriceColumn$EnumInterface, unknown>;
	//# sourceMappingURL=price-column.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/price-account.d.ts
declare module '@sage/x3-stock-data/lib/enums/price-account' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PriceAccountEnum {
	    standardCost = 1,
	    revisedStandardCost = 2
	}
	export interface PriceAccount$EnumInterface {
	    standardCost: 1;
	    revisedStandardCost: 2;
	}
	export type PriceAccount = keyof PriceAccount$EnumInterface;
	export const priceAccountDatatype: X3EnumDataType<keyof PriceAccount$EnumInterface, unknown>;
	//# sourceMappingURL=price-account.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/preparation-source.d.ts
declare module '@sage/x3-stock-data/lib/enums/preparation-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PreparationSourceEnum {
	    order = 1,
	    loanOrder = 2,
	    subcontractRepl = 3,
	    subcontractShortage = 4
	}
	export interface PreparationSource$EnumInterface {
	    order: 1;
	    loanOrder: 2;
	    subcontractRepl: 3;
	    subcontractShortage: 4;
	}
	export type PreparationSource = keyof PreparationSource$EnumInterface;
	export const preparationSourceDatatype: X3EnumDataType<keyof PreparationSource$EnumInterface, unknown>;
	//# sourceMappingURL=preparation-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/preparation-plan-sort.d.ts
declare module '@sage/x3-stock-data/lib/enums/preparation-plan-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PreparationPlanSortEnum {
	    documentNumber = 1,
	    shipmentDate = 2,
	    product = 3
	}
	export interface PreparationPlanSort$EnumInterface {
	    documentNumber: 1;
	    shipmentDate: 2;
	    product: 3;
	}
	export type PreparationPlanSort = keyof PreparationPlanSort$EnumInterface;
	export const preparationPlanSortDatatype: X3EnumDataType<keyof PreparationPlanSort$EnumInterface, unknown>;
	//# sourceMappingURL=preparation-plan-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/preparation-code-setup.d.ts
declare module '@sage/x3-stock-data/lib/enums/preparation-code-setup' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PreparationCodeSetupEnum {
	    substituteValue1 = 1,
	    product = 2,
	    productCategory = 3,
	    productGroup1 = 4,
	    productGroup2 = 5,
	    productGroup3 = 6,
	    productGroup4 = 7,
	    productGroup5 = 8,
	    customer = 9,
	    customerCategory = 10,
	    customerGroup1 = 11,
	    customerGroup2 = 12,
	    customerGroup3 = 13,
	    customerGroup4 = 14,
	    customerGroup5 = 15
	}
	export interface PreparationCodeSetup$EnumInterface {
	    substituteValue1: 1;
	    product: 2;
	    productCategory: 3;
	    productGroup1: 4;
	    productGroup2: 5;
	    productGroup3: 6;
	    productGroup4: 7;
	    productGroup5: 8;
	    customer: 9;
	    customerCategory: 10;
	    customerGroup1: 11;
	    customerGroup2: 12;
	    customerGroup3: 13;
	    customerGroup4: 14;
	    customerGroup5: 15;
	}
	export type PreparationCodeSetup = keyof PreparationCodeSetup$EnumInterface;
	export const preparationCodeSetupDatatype: X3EnumDataType<keyof PreparationCodeSetup$EnumInterface, unknown>;
	//# sourceMappingURL=preparation-code-setup.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/planning-transactions.d.ts
declare module '@sage/x3-stock-data/lib/enums/planning-transactions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PlanningTransactionsEnum {
	    enterpriseWorkbench = 1,
	    productWorkbench = 2,
	    orderGrouping = 3,
	    operationWorkbench = 4,
	    materialIssueWorkbench = 5,
	    productionWorkbench = 6,
	    materialReturnWorkbench = 7,
	    weighingPlan = 8,
	    trackingWorkbenchMonitoring = 9,
	    technicalRecordWorkbench = 10
	}
	export interface PlanningTransactions$EnumInterface {
	    enterpriseWorkbench: 1;
	    productWorkbench: 2;
	    orderGrouping: 3;
	    operationWorkbench: 4;
	    materialIssueWorkbench: 5;
	    productionWorkbench: 6;
	    materialReturnWorkbench: 7;
	    weighingPlan: 8;
	    trackingWorkbenchMonitoring: 9;
	    technicalRecordWorkbench: 10;
	}
	export type PlanningTransactions = keyof PlanningTransactions$EnumInterface;
	export const planningTransactionsDatatype: X3EnumDataType<keyof PlanningTransactions$EnumInterface, unknown>;
	//# sourceMappingURL=planning-transactions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/picking-note-status.d.ts
declare module '@sage/x3-stock-data/lib/enums/picking-note-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PickingNoteStatusEnum {
	    inProcess = 1,
	    deliverable = 2,
	    delivered = 3,
	    canceled = 4
	}
	export interface PickingNoteStatus$EnumInterface {
	    inProcess: 1;
	    deliverable: 2;
	    delivered: 3;
	    canceled: 4;
	}
	export type PickingNoteStatus = keyof PickingNoteStatus$EnumInterface;
	export const pickingNoteStatusDatatype: X3EnumDataType<keyof PickingNoteStatus$EnumInterface, unknown>;
	//# sourceMappingURL=picking-note-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/picking-note-source.d.ts
declare module '@sage/x3-stock-data/lib/enums/picking-note-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PickingNoteSourceEnum {
	    order = 1,
	    loanOrder = 2,
	    subcontractRequirement = 3
	}
	export interface PickingNoteSource$EnumInterface {
	    order: 1;
	    loanOrder: 2;
	    subcontractRequirement: 3;
	}
	export type PickingNoteSource = keyof PickingNoteSource$EnumInterface;
	export const pickingNoteSourceDatatype: X3EnumDataType<keyof PickingNoteSource$EnumInterface, unknown>;
	//# sourceMappingURL=picking-note-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/pick-ticket-sorting.d.ts
declare module '@sage/x3-stock-data/lib/enums/pick-ticket-sorting' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PickTicketSortingEnum {
	    shippingDate = 1,
	    pickTicketNumber = 2,
	    shipToCustomer = 3,
	    picker = 4
	}
	export interface PickTicketSorting$EnumInterface {
	    shippingDate: 1;
	    pickTicketNumber: 2;
	    shipToCustomer: 3;
	    picker: 4;
	}
	export type PickTicketSorting = keyof PickTicketSorting$EnumInterface;
	export const pickTicketSortingDatatype: X3EnumDataType<keyof PickTicketSorting$EnumInterface, unknown>;
	//# sourceMappingURL=pick-ticket-sorting.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/pallet-container-management.d.ts
declare module '@sage/x3-stock-data/lib/enums/pallet-container-management' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PalletContainerManagementEnum {
	    notManaged = 1,
	    freeEntry = 2,
	    controlledEntry = 3,
	    automaticAssignment = 4
	}
	export interface PalletContainerManagement$EnumInterface {
	    notManaged: 1;
	    freeEntry: 2;
	    controlledEntry: 3;
	    automaticAssignment: 4;
	}
	export type PalletContainerManagement = keyof PalletContainerManagement$EnumInterface;
	export const palletContainerManagementDatatype: X3EnumDataType<keyof PalletContainerManagement$EnumInterface, unknown>;
	//# sourceMappingURL=pallet-container-management.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/packing-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/packing-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PackingTypeEnum {
	    declarative = 1,
	    postpacking = 2
	}
	export interface PackingType$EnumInterface {
	    declarative: 1;
	    postpacking: 2;
	}
	export type PackingType = keyof PackingType$EnumInterface;
	export const packingTypeDatatype: X3EnumDataType<keyof PackingType$EnumInterface, unknown>;
	//# sourceMappingURL=packing-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/packing-sort.d.ts
declare module '@sage/x3-stock-data/lib/enums/packing-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PackingSortEnum {
	    document = 1,
	    package = 2,
	    deliveredCustomer = 3,
	    picker = 4
	}
	export interface PackingSort$EnumInterface {
	    document: 1;
	    package: 2;
	    deliveredCustomer: 3;
	    picker: 4;
	}
	export type PackingSort = keyof PackingSort$EnumInterface;
	export const packingSortDatatype: X3EnumDataType<keyof PackingSort$EnumInterface, unknown>;
	//# sourceMappingURL=packing-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/packing-sequence.d.ts
declare module '@sage/x3-stock-data/lib/enums/packing-sequence' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum PackingSequenceEnum {
	    no = 1,
	    free = 2,
	    newLot = 3
	}
	export interface PackingSequence$EnumInterface {
	    no: 1;
	    free: 2;
	    newLot: 3;
	}
	export type PackingSequence = keyof PackingSequence$EnumInterface;
	export const packingSequenceDatatype: X3EnumDataType<keyof PackingSequence$EnumInterface, unknown>;
	//# sourceMappingURL=packing-sequence.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/origin-of-put-away-plan.d.ts
declare module '@sage/x3-stock-data/lib/enums/origin-of-put-away-plan' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OriginOfPutAwayPlanEnum {
	    awaitingPutAway = 1,
	    replenishment = 2
	}
	export interface OriginOfPutAwayPlan$EnumInterface {
	    awaitingPutAway: 1;
	    replenishment: 2;
	}
	export type OriginOfPutAwayPlan = keyof OriginOfPutAwayPlan$EnumInterface;
	export const originOfPutAwayPlanDatatype: X3EnumDataType<keyof OriginOfPutAwayPlan$EnumInterface, unknown>;
	//# sourceMappingURL=origin-of-put-away-plan.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/orders-to-be-replanned.d.ts
declare module '@sage/x3-stock-data/lib/enums/orders-to-be-replanned' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OrdersToBeReplannedEnum {
	    wof = 1,
	    wop = 2,
	    pof = 3,
	    pop = 4,
	    trf = 5,
	    trp = 6,
	    eof = 7,
	    eop = 8
	}
	export interface OrdersToBeReplanned$EnumInterface {
	    wof: 1;
	    wop: 2;
	    pof: 3;
	    pop: 4;
	    trf: 5;
	    trp: 6;
	    eof: 7;
	    eop: 8;
	}
	export type OrdersToBeReplanned = keyof OrdersToBeReplanned$EnumInterface;
	export const ordersToBeReplannedDatatype: X3EnumDataType<keyof OrdersToBeReplanned$EnumInterface, unknown>;
	//# sourceMappingURL=orders-to-be-replanned.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/options-variants-entry.d.ts
declare module '@sage/x3-stock-data/lib/enums/options-variants-entry' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OptionsVariantsEntryEnum {
	    enter0Or1 = 1,
	    freeEntry = 2,
	    noEntry = 3
	}
	export interface OptionsVariantsEntry$EnumInterface {
	    enter0Or1: 1;
	    freeEntry: 2;
	    noEntry: 3;
	}
	export type OptionsVariantsEntry = keyof OptionsVariantsEntry$EnumInterface;
	export const optionsVariantsEntryDatatype: X3EnumDataType<keyof OptionsVariantsEntry$EnumInterface, unknown>;
	//# sourceMappingURL=options-variants-entry.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/occupation-code.d.ts
declare module '@sage/x3-stock-data/lib/enums/occupation-code' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum OccupationCodeEnum {
	    free = 1,
	    occupied = 2,
	    freeOccupied = 3
	}
	export interface OccupationCode$EnumInterface {
	    free: 1;
	    occupied: 2;
	    freeOccupied: 3;
	}
	export type OccupationCode = keyof OccupationCode$EnumInterface;
	export const occupationCodeDatatype: X3EnumDataType<keyof OccupationCode$EnumInterface, unknown>;
	//# sourceMappingURL=occupation-code.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/no-yes-indifferent.d.ts
declare module '@sage/x3-stock-data/lib/enums/no-yes-indifferent' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum NoYesIndifferentEnum {
	    no = 1,
	    yes = 2,
	    indifferent = 3
	}
	export interface NoYesIndifferent$EnumInterface {
	    no: 1;
	    yes: 2;
	    indifferent: 3;
	}
	export type NoYesIndifferent = keyof NoYesIndifferent$EnumInterface;
	export const noYesIndifferentDatatype: X3EnumDataType<keyof NoYesIndifferent$EnumInterface, unknown>;
	//# sourceMappingURL=no-yes-indifferent.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/mrp-phases.d.ts
declare module '@sage/x3-stock-data/lib/enums/mrp-phases' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MrpPhasesEnum {
	    initialization = 1,
	    previousPurgeProcess = 2,
	    productExtraction = 3,
	    unused = 4,
	    wipExtraction = 5,
	    calculationSuggestions = 6,
	    wipUpdate = 7,
	    print = 8,
	    totalDuration = 9
	}
	export interface MrpPhases$EnumInterface {
	    initialization: 1;
	    previousPurgeProcess: 2;
	    productExtraction: 3;
	    unused: 4;
	    wipExtraction: 5;
	    calculationSuggestions: 6;
	    wipUpdate: 7;
	    print: 8;
	    totalDuration: 9;
	}
	export type MrpPhases = keyof MrpPhases$EnumInterface;
	export const mrpPhasesDatatype: X3EnumDataType<keyof MrpPhases$EnumInterface, unknown>;
	//# sourceMappingURL=mrp-phases.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/monthly-stock-process.d.ts
declare module '@sage/x3-stock-data/lib/enums/monthly-stock-process' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MonthlyStockProcessEnum {
	    noCorrectionOfPreviousMovements = 1,
	    correctionOfPreviousMovements = 2
	}
	export interface MonthlyStockProcess$EnumInterface {
	    noCorrectionOfPreviousMovements: 1;
	    correctionOfPreviousMovements: 2;
	}
	export type MonthlyStockProcess = keyof MonthlyStockProcess$EnumInterface;
	export const monthlyStockProcessDatatype: X3EnumDataType<keyof MonthlyStockProcess$EnumInterface, unknown>;
	//# sourceMappingURL=monthly-stock-process.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/monthly-stock-process-control.d.ts
declare module '@sage/x3-stock-data/lib/enums/monthly-stock-process-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MonthlyStockProcessControlEnum {
	    noControl = 1,
	    nonBlockingControl = 2,
	    blockingControl = 3
	}
	export interface MonthlyStockProcessControl$EnumInterface {
	    noControl: 1;
	    nonBlockingControl: 2;
	    blockingControl: 3;
	}
	export type MonthlyStockProcessControl = keyof MonthlyStockProcessControl$EnumInterface;
	export const monthlyStockProcessControlDatatype: X3EnumDataType<keyof MonthlyStockProcessControl$EnumInterface, unknown>;
	//# sourceMappingURL=monthly-stock-process-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/module-750.d.ts
declare module '@sage/x3-stock-data/lib/enums/module-750' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum Module750Enum {
	    entry1 = 1,
	    entry2 = 2
	}
	export interface Module750$EnumInterface {
	    entry1: 1;
	    entry2: 2;
	}
	export type Module750 = keyof Module750$EnumInterface;
	export const module750Datatype: X3EnumDataType<keyof Module750$EnumInterface, unknown>;
	//# sourceMappingURL=module-750.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/modification-lot-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/modification-lot-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ModificationLotTypeEnum {
	    renumbering = 1,
	    mixing = 2
	}
	export interface ModificationLotType$EnumInterface {
	    renumbering: 1;
	    mixing: 2;
	}
	export type ModificationLotType = keyof ModificationLotType$EnumInterface;
	export const modificationLotTypeDatatype: X3EnumDataType<keyof ModificationLotType$EnumInterface, unknown>;
	//# sourceMappingURL=modification-lot-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/mode-of-operation.d.ts
declare module '@sage/x3-stock-data/lib/enums/mode-of-operation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ModeOfOperationEnum {
	    group = 1,
	    split = 2,
	    unlink = 3
	}
	export interface ModeOfOperation$EnumInterface {
	    group: 1;
	    split: 2;
	    unlink: 3;
	}
	export type ModeOfOperation = keyof ModeOfOperation$EnumInterface;
	export const modeOfOperationDatatype: X3EnumDataType<keyof ModeOfOperation$EnumInterface, unknown>;
	//# sourceMappingURL=mode-of-operation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/material-requirements-planning.d.ts
declare module '@sage/x3-stock-data/lib/enums/material-requirements-planning' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialRequirementsPlanningEnum {
	    masterProductionPlanning = 1,
	    materialRequirementsPlanning = 2
	}
	export interface MaterialRequirementsPlanning$EnumInterface {
	    masterProductionPlanning: 1;
	    materialRequirementsPlanning: 2;
	}
	export type MaterialRequirementsPlanning = keyof MaterialRequirementsPlanning$EnumInterface;
	export const materialRequirementsPlanningDatatype: X3EnumDataType<keyof MaterialRequirementsPlanning$EnumInterface, unknown>;
	//# sourceMappingURL=material-requirements-planning.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/material-cost-group.d.ts
declare module '@sage/x3-stock-data/lib/enums/material-cost-group' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum MaterialCostGroupEnum {
	    materialCost1 = 1,
	    materialCost2 = 2,
	    materialCost3 = 3,
	    materialCost4 = 4,
	    materialCost5 = 5,
	    materialCost6 = 6,
	    materialCost7 = 7,
	    materialCost8 = 8,
	    materialCost9 = 9,
	    materialCost10 = 10,
	    materialCost11 = 11,
	    materialCost12 = 12,
	    materialCost13 = 13,
	    materialCost14 = 14,
	    materialCost15 = 15,
	    materialCost16 = 16,
	    materialCost17 = 17,
	    materialCost18 = 18,
	    materialCost19 = 19,
	    materialCost20 = 20
	}
	export interface MaterialCostGroup$EnumInterface {
	    materialCost1: 1;
	    materialCost2: 2;
	    materialCost3: 3;
	    materialCost4: 4;
	    materialCost5: 5;
	    materialCost6: 6;
	    materialCost7: 7;
	    materialCost8: 8;
	    materialCost9: 9;
	    materialCost10: 10;
	    materialCost11: 11;
	    materialCost12: 12;
	    materialCost13: 13;
	    materialCost14: 14;
	    materialCost15: 15;
	    materialCost16: 16;
	    materialCost17: 17;
	    materialCost18: 18;
	    materialCost19: 19;
	    materialCost20: 20;
	}
	export type MaterialCostGroup = keyof MaterialCostGroup$EnumInterface;
	export const materialCostGroupDatatype: X3EnumDataType<keyof MaterialCostGroup$EnumInterface, unknown>;
	//# sourceMappingURL=material-cost-group.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/manufacture-lead-time-mrp-mp.d.ts
declare module '@sage/x3-stock-data/lib/enums/manufacture-lead-time-mrp-mp' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ManufactureLeadTimeMrpMpEnum {
	    productLeadTimes = 1,
	    routingProductLeadTimes = 2,
	    alwaysRoutingLeadTimes = 3
	}
	export interface ManufactureLeadTimeMrpMp$EnumInterface {
	    productLeadTimes: 1;
	    routingProductLeadTimes: 2;
	    alwaysRoutingLeadTimes: 3;
	}
	export type ManufactureLeadTimeMrpMp = keyof ManufactureLeadTimeMrpMp$EnumInterface;
	export const manufactureLeadTimeMrpMpDatatype: X3EnumDataType<keyof ManufactureLeadTimeMrpMp$EnumInterface, unknown>;
	//# sourceMappingURL=manufacture-lead-time-mrp-mp.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/lot-modif-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/lot-modif-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LotModifTypeEnum {
	    lotCharacteristicsModification = 1,
	    renumberingMixingAndSplitting = 2
	}
	export interface LotModifType$EnumInterface {
	    lotCharacteristicsModification: 1;
	    renumberingMixingAndSplitting: 2;
	}
	export type LotModifType = keyof LotModifType$EnumInterface;
	export const lotModifTypeDatatype: X3EnumDataType<keyof LotModifType$EnumInterface, unknown>;
	//# sourceMappingURL=lot-modif-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/lot-management-mode.d.ts
declare module '@sage/x3-stock-data/lib/enums/lot-management-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LotManagementModeEnum {
	    notManaged = 1,
	    optionalLot = 2,
	    mandatoryLot = 3,
	    lotAndSublot = 4
	}
	export interface LotManagementMode$EnumInterface {
	    notManaged: 1;
	    optionalLot: 2;
	    mandatoryLot: 3;
	    lotAndSublot: 4;
	}
	export type LotManagementMode = keyof LotManagementMode$EnumInterface;
	export const lotManagementModeDatatype: X3EnumDataType<keyof LotManagementMode$EnumInterface, unknown>;
	//# sourceMappingURL=lot-management-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/lot-classification.d.ts
declare module '@sage/x3-stock-data/lib/enums/lot-classification' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LotClassificationEnum {
	    byLot = 1,
	    fifo = 2,
	    fefo = 3
	}
	export interface LotClassification$EnumInterface {
	    byLot: 1;
	    fifo: 2;
	    fefo: 3;
	}
	export type LotClassification = keyof LotClassification$EnumInterface;
	export const lotClassificationDatatype: X3EnumDataType<keyof LotClassification$EnumInterface, unknown>;
	//# sourceMappingURL=lot-classification.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/lot-characteristics-level.d.ts
declare module '@sage/x3-stock-data/lib/enums/lot-characteristics-level' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LotCharacteristicsLevelEnum {
	    sublot = 1,
	    lot = 2
	}
	export interface LotCharacteristicsLevel$EnumInterface {
	    sublot: 1;
	    lot: 2;
	}
	export type LotCharacteristicsLevel = keyof LotCharacteristicsLevel$EnumInterface;
	export const lotCharacteristicsLevelDatatype: X3EnumDataType<keyof LotCharacteristicsLevel$EnumInterface, unknown>;
	//# sourceMappingURL=lot-characteristics-level.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/location-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/location-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LocationTypeEnum {
	    dedicatedSingleProduct = 1,
	    dedicatedMultipleProduct = 2,
	    dynamicSingleProduct = 3,
	    dynamicMultipleProduct = 4,
	    unlimitedArrangement = 5,
	    stockAtBusinessPartner = 6,
	    subcontract = 7
	}
	export interface LocationType$EnumInterface {
	    dedicatedSingleProduct: 1;
	    dedicatedMultipleProduct: 2;
	    dynamicSingleProduct: 3;
	    dynamicMultipleProduct: 4;
	    unlimitedArrangement: 5;
	    stockAtBusinessPartner: 6;
	    subcontract: 7;
	}
	export type LocationType = keyof LocationType$EnumInterface;
	export const locationTypeDatatype: X3EnumDataType<keyof LocationType$EnumInterface, unknown>;
	//# sourceMappingURL=location-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/location-type-sequence.d.ts
declare module '@sage/x3-stock-data/lib/enums/location-type-sequence' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LocationTypeSequenceEnum {
	    locationTypeAlternateTypes = 1,
	    allLocationTypesAlternateTypes = 2
	}
	export interface LocationTypeSequence$EnumInterface {
	    locationTypeAlternateTypes: 1;
	    allLocationTypesAlternateTypes: 2;
	}
	export type LocationTypeSequence = keyof LocationTypeSequence$EnumInterface;
	export const locationTypeSequenceDatatype: X3EnumDataType<keyof LocationTypeSequence$EnumInterface, unknown>;
	//# sourceMappingURL=location-type-sequence.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/location-category.d.ts
declare module '@sage/x3-stock-data/lib/enums/location-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LocationCategoryEnum {
	    internal = 1,
	    dock = 2,
	    customer = 3,
	    subcontract = 4
	}
	export interface LocationCategory$EnumInterface {
	    internal: 1;
	    dock: 2;
	    customer: 3;
	    subcontract: 4;
	}
	export type LocationCategory = keyof LocationCategory$EnumInterface;
	export const locationCategoryDatatype: X3EnumDataType<keyof LocationCategory$EnumInterface, unknown>;
	//# sourceMappingURL=location-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/local-menu.d.ts
declare module '@sage/x3-stock-data/lib/enums/local-menu' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LocalMenuEnum {
	    localMenu1 = 1,
	    localMenu = 2
	}
	export interface LocalMenu$EnumInterface {
	    localMenu1: 1;
	    localMenu: 2;
	}
	export type LocalMenu = keyof LocalMenu$EnumInterface;
	export const localMenuDatatype: X3EnumDataType<keyof LocalMenu$EnumInterface, unknown>;
	//# sourceMappingURL=local-menu.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/line-type-2731.d.ts
declare module '@sage/x3-stock-data/lib/enums/line-type-2731' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LineType2731Enum {
	    parentProduct = 1,
	    component = 2
	}
	export interface LineType2731$EnumInterface {
	    parentProduct: 1;
	    component: 2;
	}
	export type LineType2731 = keyof LineType2731$EnumInterface;
	export const lineType2731Datatype: X3EnumDataType<keyof LineType2731$EnumInterface, unknown>;
	//# sourceMappingURL=line-type-2731.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/line-grouping.d.ts
declare module '@sage/x3-stock-data/lib/enums/line-grouping' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LineGroupingEnum {
	    noGrouping = 1,
	    groupLinesOnTheScreen = 2,
	    stA = 3,
	    stQ = 4,
	    stAQ = 5,
	    stR = 6,
	    stAR = 7,
	    stQR = 8,
	    stAQR = 9
	}
	export interface LineGrouping$EnumInterface {
	    noGrouping: 1;
	    groupLinesOnTheScreen: 2;
	    stA: 3;
	    stQ: 4;
	    stAQ: 5;
	    stR: 6;
	    stAR: 7;
	    stQR: 8;
	    stAQR: 9;
	}
	export type LineGrouping = keyof LineGrouping$EnumInterface;
	export const lineGroupingDatatype: X3EnumDataType<keyof LineGrouping$EnumInterface, unknown>;
	//# sourceMappingURL=line-grouping.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/license-plate-number-entry.d.ts
declare module '@sage/x3-stock-data/lib/enums/license-plate-number-entry' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LicensePlateNumberEntryEnum {
	    optional = 1,
	    mandatory = 2
	}
	export interface LicensePlateNumberEntry$EnumInterface {
	    optional: 1;
	    mandatory: 2;
	}
	export type LicensePlateNumberEntry = keyof LicensePlateNumberEntry$EnumInterface;
	export const licensePlateNumberEntryDatatype: X3EnumDataType<keyof LicensePlateNumberEntry$EnumInterface, unknown>;
	//# sourceMappingURL=license-plate-number-entry.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/late-suggestion-end-date.d.ts
declare module '@sage/x3-stock-data/lib/enums/late-suggestion-end-date' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LateSuggestionEndDateEnum {
	    firstPossibleDate = 1,
	    firstPossibleDateLeadtime = 2
	}
	export interface LateSuggestionEndDate$EnumInterface {
	    firstPossibleDate: 1;
	    firstPossibleDateLeadtime: 2;
	}
	export type LateSuggestionEndDate = keyof LateSuggestionEndDate$EnumInterface;
	export const lateSuggestionEndDateDatatype: X3EnumDataType<keyof LateSuggestionEndDate$EnumInterface, unknown>;
	//# sourceMappingURL=late-suggestion-end-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/label-printing.d.ts
declare module '@sage/x3-stock-data/lib/enums/label-printing' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum LabelPrintingEnum {
	    noPrint = 1,
	    stockLabel = 2,
	    substituteValue3 = 3,
	    transfertDocument = 4,
	    analysisDocument = 5,
	    createdContainerLabel = 6,
	    stockLabelAndCreatedContainerLabel = 7
	}
	export interface LabelPrinting$EnumInterface {
	    noPrint: 1;
	    stockLabel: 2;
	    substituteValue3: 3;
	    transfertDocument: 4;
	    analysisDocument: 5;
	    createdContainerLabel: 6;
	    stockLabelAndCreatedContainerLabel: 7;
	}
	export type LabelPrinting = keyof LabelPrinting$EnumInterface;
	export const labelPrintingDatatype: X3EnumDataType<keyof LabelPrinting$EnumInterface, unknown>;
	//# sourceMappingURL=label-printing.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/journal-type-selection.d.ts
declare module '@sage/x3-stock-data/lib/enums/journal-type-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum JournalTypeSelectionEnum {
	    allTypes = 1,
	    customer = 2,
	    salesOrder = 3,
	    preparation = 4,
	    shipment = 5,
	    salesInvoice = 6,
	    receipt = 7,
	    transfer = 8,
	    supplierReturn = 9,
	    count = 10,
	    workOrder = 11,
	    suggestedWorkOrder = 12,
	    productionTracking = 13,
	    customerReturn = 14,
	    purchaseOrder = 15,
	    productionDeclaration = 16,
	    miscellaneousStockInactive = 17,
	    purchaseInvoice = 18,
	    salesCredit = 19,
	    miscellaneousReceipt = 20,
	    miscellaneousIssue = 21,
	    locationChange = 22,
	    intersiteTransfer = 23,
	    intersiteTransferReceipt = 24,
	    subcontractTransfer = 25,
	    subcontractReceipt = 26,
	    stockReturn = 27,
	    putAwayPlan = 28,
	    qualityControl = 29,
	    stockChange = 30,
	    valueChange = 31,
	    assembly = 32,
	    disassembly = 33,
	    serviceRequest = 34,
	    reorderConsumptionPlan = 35,
	    lotModification = 36,
	    subcontractOrder = 37,
	    trackingWithoutWorkOrder = 38
	}
	export interface JournalTypeSelection$EnumInterface {
	    allTypes: 1;
	    customer: 2;
	    salesOrder: 3;
	    preparation: 4;
	    shipment: 5;
	    salesInvoice: 6;
	    receipt: 7;
	    transfer: 8;
	    supplierReturn: 9;
	    count: 10;
	    workOrder: 11;
	    suggestedWorkOrder: 12;
	    productionTracking: 13;
	    customerReturn: 14;
	    purchaseOrder: 15;
	    productionDeclaration: 16;
	    miscellaneousStockInactive: 17;
	    purchaseInvoice: 18;
	    salesCredit: 19;
	    miscellaneousReceipt: 20;
	    miscellaneousIssue: 21;
	    locationChange: 22;
	    intersiteTransfer: 23;
	    intersiteTransferReceipt: 24;
	    subcontractTransfer: 25;
	    subcontractReceipt: 26;
	    stockReturn: 27;
	    putAwayPlan: 28;
	    qualityControl: 29;
	    stockChange: 30;
	    valueChange: 31;
	    assembly: 32;
	    disassembly: 33;
	    serviceRequest: 34;
	    reorderConsumptionPlan: 35;
	    lotModification: 36;
	    subcontractOrder: 37;
	    trackingWithoutWorkOrder: 38;
	}
	export type JournalTypeSelection = keyof JournalTypeSelection$EnumInterface;
	export const journalTypeSelectionDatatype: X3EnumDataType<keyof JournalTypeSelection$EnumInterface, unknown>;
	//# sourceMappingURL=journal-type-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/inter-company.d.ts
declare module '@sage/x3-stock-data/lib/enums/inter-company' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum InterCompanyEnum {
	    displayAll = 1,
	    onlyDisplayIntercompanyOrders = 2,
	    doNotDisplayIntercompanyOrders = 3
	}
	export interface InterCompany$EnumInterface {
	    displayAll: 1;
	    onlyDisplayIntercompanyOrders: 2;
	    doNotDisplayIntercompanyOrders: 3;
	}
	export type InterCompany = keyof InterCompany$EnumInterface;
	export const interCompanyDatatype: X3EnumDataType<keyof InterCompany$EnumInterface, unknown>;
	//# sourceMappingURL=inter-company.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/index.d.ts
declare module '@sage/x3-stock-data/lib/enums/index' {
	export * from '@sage/x3-stock-data/lib/enums/abc-class-calculation';
	export * from '@sage/x3-stock-data/lib/enums/abreviations-menu-252';
	export * from '@sage/x3-stock-data/lib/enums/adc-flow-type';
	export * from '@sage/x3-stock-data/lib/enums/adjustment-of-stock-shortages';
	export * from '@sage/x3-stock-data/lib/enums/allocation-messages';
	export * from '@sage/x3-stock-data/lib/enums/assembly-type';
	export * from '@sage/x3-stock-data/lib/enums/assignment-mode';
	export * from '@sage/x3-stock-data/lib/enums/average-cost-initialization';
	export * from '@sage/x3-stock-data/lib/enums/blocked-stock';
	export * from '@sage/x3-stock-data/lib/enums/calendar-correction';
	export * from '@sage/x3-stock-data/lib/enums/catalog-types';
	export * from '@sage/x3-stock-data/lib/enums/choose-quantity-column';
	export * from '@sage/x3-stock-data/lib/enums/choose-standard-process';
	export * from '@sage/x3-stock-data/lib/enums/combined-transactions';
	export * from '@sage/x3-stock-data/lib/enums/component-requirements';
	export * from '@sage/x3-stock-data/lib/enums/component-rounding-2727';
	export * from '@sage/x3-stock-data/lib/enums/component-rounding-2728';
	export * from '@sage/x3-stock-data/lib/enums/component-rounding';
	export * from '@sage/x3-stock-data/lib/enums/config-scenarios-entry-mode';
	export * from '@sage/x3-stock-data/lib/enums/configurator-actions';
	export * from '@sage/x3-stock-data/lib/enums/configurator-field-control';
	export * from '@sage/x3-stock-data/lib/enums/configurator-selection-type';
	export * from '@sage/x3-stock-data/lib/enums/configurator-symbol-origin';
	export * from '@sage/x3-stock-data/lib/enums/configurator-system-variables';
	export * from '@sage/x3-stock-data/lib/enums/consolidations-previsions-roun';
	export * from '@sage/x3-stock-data/lib/enums/constraints-options-variants';
	export * from '@sage/x3-stock-data/lib/enums/consumption-reorder-plan-sort';
	export * from '@sage/x3-stock-data/lib/enums/container-status';
	export * from '@sage/x3-stock-data/lib/enums/cost-source';
	export * from '@sage/x3-stock-data/lib/enums/count-and-auc-differences';
	export * from '@sage/x3-stock-data/lib/enums/count-difference-adjustment';
	export * from '@sage/x3-stock-data/lib/enums/count-worksheet-selection';
	export * from '@sage/x3-stock-data/lib/enums/crystal-report-stock';
	export * from '@sage/x3-stock-data/lib/enums/default-lot';
	export * from '@sage/x3-stock-data/lib/enums/default-uom';
	export * from '@sage/x3-stock-data/lib/enums/definition-level-2742';
	export * from '@sage/x3-stock-data/lib/enums/destination-choice';
	export * from '@sage/x3-stock-data/lib/enums/detail-stock-selection';
	export * from '@sage/x3-stock-data/lib/enums/dimension-cost-group';
	export * from '@sage/x3-stock-data/lib/enums/document-category';
	export * from '@sage/x3-stock-data/lib/enums/document-for-labels';
	export * from '@sage/x3-stock-data/lib/enums/element';
	export * from '@sage/x3-stock-data/lib/enums/entered-stock-line-status';
	export * from '@sage/x3-stock-data/lib/enums/entry-type-enum';
	export * from '@sage/x3-stock-data/lib/enums/expiration-lead-time-units';
	export * from '@sage/x3-stock-data/lib/enums/expiration-taken-into-account';
	export * from '@sage/x3-stock-data/lib/enums/ficlotvcr-status-source-doc';
	export * from '@sage/x3-stock-data/lib/enums/filter-coefficient';
	export * from '@sage/x3-stock-data/lib/enums/filter-location';
	export * from '@sage/x3-stock-data/lib/enums/forecast-grouping';
	export * from '@sage/x3-stock-data/lib/enums/inter-company';
	export * from '@sage/x3-stock-data/lib/enums/journal-type-selection';
	export * from '@sage/x3-stock-data/lib/enums/label-printing';
	export * from '@sage/x3-stock-data/lib/enums/late-suggestion-end-date';
	export * from '@sage/x3-stock-data/lib/enums/license-plate-number-entry';
	export * from '@sage/x3-stock-data/lib/enums/line-grouping';
	export * from '@sage/x3-stock-data/lib/enums/line-type-2731';
	export * from '@sage/x3-stock-data/lib/enums/local-menu';
	export * from '@sage/x3-stock-data/lib/enums/location-category';
	export * from '@sage/x3-stock-data/lib/enums/location-type-sequence';
	export * from '@sage/x3-stock-data/lib/enums/location-type';
	export * from '@sage/x3-stock-data/lib/enums/lot-characteristics-level';
	export * from '@sage/x3-stock-data/lib/enums/lot-classification';
	export * from '@sage/x3-stock-data/lib/enums/lot-management-mode';
	export * from '@sage/x3-stock-data/lib/enums/lot-modif-type';
	export * from '@sage/x3-stock-data/lib/enums/manufacture-lead-time-mrp-mp';
	export * from '@sage/x3-stock-data/lib/enums/material-cost-group';
	export * from '@sage/x3-stock-data/lib/enums/material-requirements-planning';
	export * from '@sage/x3-stock-data/lib/enums/mode-of-operation';
	export * from '@sage/x3-stock-data/lib/enums/modification-lot-type';
	export * from '@sage/x3-stock-data/lib/enums/module-750';
	export * from '@sage/x3-stock-data/lib/enums/monthly-stock-process-control';
	export * from '@sage/x3-stock-data/lib/enums/monthly-stock-process';
	export * from '@sage/x3-stock-data/lib/enums/mrp-phases';
	export * from '@sage/x3-stock-data/lib/enums/no-yes-indifferent';
	export * from '@sage/x3-stock-data/lib/enums/occupation-code';
	export * from '@sage/x3-stock-data/lib/enums/options-variants-entry';
	export * from '@sage/x3-stock-data/lib/enums/orders-to-be-replanned';
	export * from '@sage/x3-stock-data/lib/enums/origin-of-put-away-plan';
	export * from '@sage/x3-stock-data/lib/enums/packing-sequence';
	export * from '@sage/x3-stock-data/lib/enums/packing-sort';
	export * from '@sage/x3-stock-data/lib/enums/packing-type';
	export * from '@sage/x3-stock-data/lib/enums/pallet-container-management';
	export * from '@sage/x3-stock-data/lib/enums/pick-ticket-sorting';
	export * from '@sage/x3-stock-data/lib/enums/picking-note-source';
	export * from '@sage/x3-stock-data/lib/enums/picking-note-status';
	export * from '@sage/x3-stock-data/lib/enums/planning-transactions';
	export * from '@sage/x3-stock-data/lib/enums/preparation-code-setup';
	export * from '@sage/x3-stock-data/lib/enums/preparation-plan-sort';
	export * from '@sage/x3-stock-data/lib/enums/preparation-source';
	export * from '@sage/x3-stock-data/lib/enums/price-account';
	export * from '@sage/x3-stock-data/lib/enums/price-column';
	export * from '@sage/x3-stock-data/lib/enums/product-line-field-titles';
	export * from '@sage/x3-stock-data/lib/enums/proposal-type';
	export * from '@sage/x3-stock-data/lib/enums/prototype-or-active-version';
	export * from '@sage/x3-stock-data/lib/enums/put-away-plan-situation';
	export * from '@sage/x3-stock-data/lib/enums/qty-assembly-disassembly';
	export * from '@sage/x3-stock-data/lib/enums/qty-pre-charged';
	export * from '@sage/x3-stock-data/lib/enums/quality-filter-1';
	export * from '@sage/x3-stock-data/lib/enums/quality-filter';
	export * from '@sage/x3-stock-data/lib/enums/quantity-type';
	export * from '@sage/x3-stock-data/lib/enums/re-planning-selection';
	export * from '@sage/x3-stock-data/lib/enums/release-mode-management';
	export * from '@sage/x3-stock-data/lib/enums/reorder-calculation-method';
	export * from '@sage/x3-stock-data/lib/enums/reorder-selection-outside-of-m';
	export * from '@sage/x3-stock-data/lib/enums/reorder-situation';
	export * from '@sage/x3-stock-data/lib/enums/reordering-management-mode';
	export * from '@sage/x3-stock-data/lib/enums/replan-date';
	export * from '@sage/x3-stock-data/lib/enums/replan-quantities';
	export * from '@sage/x3-stock-data/lib/enums/replanning-sort-order';
	export * from '@sage/x3-stock-data/lib/enums/replenishment-source';
	export * from '@sage/x3-stock-data/lib/enums/safety-stock-reconstitution';
	export * from '@sage/x3-stock-data/lib/enums/scenario-line-type';
	export * from '@sage/x3-stock-data/lib/enums/search-equivalence';
	export * from '@sage/x3-stock-data/lib/enums/segment-type-edi';
	export * from '@sage/x3-stock-data/lib/enums/select-date-of-put-away-plan';
	export * from '@sage/x3-stock-data/lib/enums/select-stock-movement-dates';
	export * from '@sage/x3-stock-data/lib/enums/selection-classification';
	export * from '@sage/x3-stock-data/lib/enums/selection-of-serial-nos';
	export * from '@sage/x3-stock-data/lib/enums/sequence-of-lots';
	export * from '@sage/x3-stock-data/lib/enums/sequence-selection';
	export * from '@sage/x3-stock-data/lib/enums/serial-number-count';
	export * from '@sage/x3-stock-data/lib/enums/sort-by-coef';
	export * from '@sage/x3-stock-data/lib/enums/sort-put-away-plan';
	export * from '@sage/x3-stock-data/lib/enums/stock-change-access';
	export * from '@sage/x3-stock-data/lib/enums/stock-count-detail-status';
	export * from '@sage/x3-stock-data/lib/enums/stock-count-grouping-status';
	export * from '@sage/x3-stock-data/lib/enums/stock-count-lines-selection';
	export * from '@sage/x3-stock-data/lib/enums/stock-count-list-choice';
	export * from '@sage/x3-stock-data/lib/enums/stock-count-session-status';
	export * from '@sage/x3-stock-data/lib/enums/stock-count-status-list';
	export * from '@sage/x3-stock-data/lib/enums/stock-count-type';
	export * from '@sage/x3-stock-data/lib/enums/stock-data-calculation-errors';
	export * from '@sage/x3-stock-data/lib/enums/stock-inquiries';
	export * from '@sage/x3-stock-data/lib/enums/stock-inquiry-classification';
	export * from '@sage/x3-stock-data/lib/enums/stock-issue-code';
	export * from '@sage/x3-stock-data/lib/enums/stock-movement-date-choice';
	export * from '@sage/x3-stock-data/lib/enums/stock-movement-type';
	export * from '@sage/x3-stock-data/lib/enums/stock-mvt-origin';
	export * from '@sage/x3-stock-data/lib/enums/stock-posting';
	export * from '@sage/x3-stock-data/lib/enums/stock-search-filter';
	export * from '@sage/x3-stock-data/lib/enums/stock-sequence-numbers';
	export * from '@sage/x3-stock-data/lib/enums/stock-shortage-adjustment';
	export * from '@sage/x3-stock-data/lib/enums/stock-status-enum';
	export * from '@sage/x3-stock-data/lib/enums/stock-take-sequence';
	export * from '@sage/x3-stock-data/lib/enums/stock-transaction-status';
	export * from '@sage/x3-stock-data/lib/enums/stock-transaction-type';
	export * from '@sage/x3-stock-data/lib/enums/stock-transaction-validation';
	export * from '@sage/x3-stock-data/lib/enums/stock-user-defined-fields';
	export * from '@sage/x3-stock-data/lib/enums/stock-version-mode';
	export * from '@sage/x3-stock-data/lib/enums/storage-location-code';
	export * from '@sage/x3-stock-data/lib/enums/subcontract-type';
	export * from '@sage/x3-stock-data/lib/enums/suggested-location';
	export * from '@sage/x3-stock-data/lib/enums/suggested-locations';
	export * from '@sage/x3-stock-data/lib/enums/suggestion-splitting';
	export * from '@sage/x3-stock-data/lib/enums/supply-type';
	export * from '@sage/x3-stock-data/lib/enums/symbol-control';
	export * from '@sage/x3-stock-data/lib/enums/symbol-type';
	export * from '@sage/x3-stock-data/lib/enums/take-qc-stock-into-account';
	export * from '@sage/x3-stock-data/lib/enums/title-of-location-for-stock-management-rules';
	export * from '@sage/x3-stock-data/lib/enums/title-of-location';
	export * from '@sage/x3-stock-data/lib/enums/trace-level-in-stock-updates';
	export * from '@sage/x3-stock-data/lib/enums/traceability-level';
	export * from '@sage/x3-stock-data/lib/enums/traceability-management-mode';
	export * from '@sage/x3-stock-data/lib/enums/transaction-location-managemen';
	export * from '@sage/x3-stock-data/lib/enums/transaction-lot-management';
	export * from '@sage/x3-stock-data/lib/enums/transaction-status';
	export * from '@sage/x3-stock-data/lib/enums/transaction-type-selection';
	export * from '@sage/x3-stock-data/lib/enums/transfer-replenishment-status';
	export * from '@sage/x3-stock-data/lib/enums/transfer-selection';
	export * from '@sage/x3-stock-data/lib/enums/type-of-calculation-table';
	export * from '@sage/x3-stock-data/lib/enums/type-of-cost-calculation';
	export * from '@sage/x3-stock-data/lib/enums/type-of-stock-transaction';
	export * from '@sage/x3-stock-data/lib/enums/valuation-method-758';
	export * from '@sage/x3-stock-data/lib/enums/valuation-method';
	export * from '@sage/x3-stock-data/lib/enums/valuation-variance-absorption';
	export * from '@sage/x3-stock-data/lib/enums/value-change';
	export * from '@sage/x3-stock-data/lib/enums/version-entered';
	export * from '@sage/x3-stock-data/lib/enums/version-stopped';
	export * from '@sage/x3-stock-data/lib/enums/wip-classification';
	export * from '@sage/x3-stock-data/lib/enums/wip-protection';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/forecast-grouping.d.ts
declare module '@sage/x3-stock-data/lib/enums/forecast-grouping' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ForecastGroupingEnum {
	    weekByWeek = 1,
	    totalOverWeek1 = 2,
	    totalOverWeek2 = 3,
	    totalOverWeek3 = 4,
	    totalOverLastWeek = 5
	}
	export interface ForecastGrouping$EnumInterface {
	    weekByWeek: 1;
	    totalOverWeek1: 2;
	    totalOverWeek2: 3;
	    totalOverWeek3: 4;
	    totalOverLastWeek: 5;
	}
	export type ForecastGrouping = keyof ForecastGrouping$EnumInterface;
	export const forecastGroupingDatatype: X3EnumDataType<keyof ForecastGrouping$EnumInterface, unknown>;
	//# sourceMappingURL=forecast-grouping.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/filter-location.d.ts
declare module '@sage/x3-stock-data/lib/enums/filter-location' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FilterLocationEnum {
	    noFilter = 1,
	    localLocation = 2,
	    location1Product = 3,
	    location2Product = 4,
	    location3Product = 5
	}
	export interface FilterLocation$EnumInterface {
	    noFilter: 1;
	    localLocation: 2;
	    location1Product: 3;
	    location2Product: 4;
	    location3Product: 5;
	}
	export type FilterLocation = keyof FilterLocation$EnumInterface;
	export const filterLocationDatatype: X3EnumDataType<keyof FilterLocation$EnumInterface, unknown>;
	//# sourceMappingURL=filter-location.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/filter-coefficient.d.ts
declare module '@sage/x3-stock-data/lib/enums/filter-coefficient' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FilterCoefficientEnum {
	    noFilter = 1,
	    coefficient2 = 2,
	    coefficient3 = 3,
	    coefficient = 4
	}
	export interface FilterCoefficient$EnumInterface {
	    noFilter: 1;
	    coefficient2: 2;
	    coefficient3: 3;
	    coefficient: 4;
	}
	export type FilterCoefficient = keyof FilterCoefficient$EnumInterface;
	export const filterCoefficientDatatype: X3EnumDataType<keyof FilterCoefficient$EnumInterface, unknown>;
	//# sourceMappingURL=filter-coefficient.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/ficlotvcr-status-source-doc.d.ts
declare module '@sage/x3-stock-data/lib/enums/ficlotvcr-status-source-doc' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum FiclotvcrStatusSourceDocEnum {
	    delivery = 1,
	    analysisRequest = 2
	}
	export interface FiclotvcrStatusSourceDoc$EnumInterface {
	    delivery: 1;
	    analysisRequest: 2;
	}
	export type FiclotvcrStatusSourceDoc = keyof FiclotvcrStatusSourceDoc$EnumInterface;
	export const ficlotvcrStatusSourceDocDatatype: X3EnumDataType<keyof FiclotvcrStatusSourceDoc$EnumInterface, unknown>;
	//# sourceMappingURL=ficlotvcr-status-source-doc.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/expiration-taken-into-account.d.ts
declare module '@sage/x3-stock-data/lib/enums/expiration-taken-into-account' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExpirationTakenIntoAccountEnum {
	    no = 1,
	    yes = 2,
	    yesWithMargin = 3
	}
	export interface ExpirationTakenIntoAccount$EnumInterface {
	    no: 1;
	    yes: 2;
	    yesWithMargin: 3;
	}
	export type ExpirationTakenIntoAccount = keyof ExpirationTakenIntoAccount$EnumInterface;
	export const expirationTakenIntoAccountDatatype: X3EnumDataType<keyof ExpirationTakenIntoAccount$EnumInterface, unknown>;
	//# sourceMappingURL=expiration-taken-into-account.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/expiration-lead-time-units.d.ts
declare module '@sage/x3-stock-data/lib/enums/expiration-lead-time-units' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ExpirationLeadTimeUnitsEnum {
	    calendarDays = 1,
	    month = 2
	}
	export interface ExpirationLeadTimeUnits$EnumInterface {
	    calendarDays: 1;
	    month: 2;
	}
	export type ExpirationLeadTimeUnits = keyof ExpirationLeadTimeUnits$EnumInterface;
	export const expirationLeadTimeUnitsDatatype: X3EnumDataType<keyof ExpirationLeadTimeUnits$EnumInterface, unknown>;
	//# sourceMappingURL=expiration-lead-time-units.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/entry-type-enum.d.ts
declare module '@sage/x3-stock-data/lib/enums/entry-type-enum' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EntryTypeEnumEnum {
	    customer = 1,
	    salesOrder = 2,
	    picking = 3,
	    delivery = 4,
	    salesInvoice = 5,
	    receipt = 6,
	    transferInactive = 7,
	    supplierReturn = 8,
	    count = 9,
	    workOrder = 10,
	    suggestion = 11,
	    productionTracking = 12,
	    customerReturn = 13,
	    purchaseOrder = 14,
	    productionDeclaration = 15,
	    miscellaneousStockInactive = 16,
	    supplierInvoice = 17,
	    salesCredit = 18,
	    miscellaneousReceipt = 19,
	    miscellaneousIssue = 20,
	    locationChangeInactive = 21,
	    intersiteTransferInactive = 22,
	    intersiteTransferReceiptInactive = 23,
	    transferForSubcontractingInactive = 24,
	    receiptForSubcontractingInactive = 25,
	    returnToStockInactive = 26,
	    putawayPlan = 27,
	    qualityControl = 28,
	    stockChange = 29,
	    valueChange = 30,
	    assembly = 31,
	    disassembly = 32,
	    serviceRequest = 33,
	    reorderPlan = 34,
	    lotModification = 35,
	    subcontractOrder = 36,
	    trackingWoWo = 37,
	    shipment = 38,
	    transport = 39,
	    project = 40
	}
	export interface EntryTypeEnum$EnumInterface {
	    customer: 1;
	    salesOrder: 2;
	    picking: 3;
	    delivery: 4;
	    salesInvoice: 5;
	    receipt: 6;
	    transferInactive: 7;
	    supplierReturn: 8;
	    count: 9;
	    workOrder: 10;
	    suggestion: 11;
	    productionTracking: 12;
	    customerReturn: 13;
	    purchaseOrder: 14;
	    productionDeclaration: 15;
	    miscellaneousStockInactive: 16;
	    supplierInvoice: 17;
	    salesCredit: 18;
	    miscellaneousReceipt: 19;
	    miscellaneousIssue: 20;
	    locationChangeInactive: 21;
	    intersiteTransferInactive: 22;
	    intersiteTransferReceiptInactive: 23;
	    transferForSubcontractingInactive: 24;
	    receiptForSubcontractingInactive: 25;
	    returnToStockInactive: 26;
	    putawayPlan: 27;
	    qualityControl: 28;
	    stockChange: 29;
	    valueChange: 30;
	    assembly: 31;
	    disassembly: 32;
	    serviceRequest: 33;
	    reorderPlan: 34;
	    lotModification: 35;
	    subcontractOrder: 36;
	    trackingWoWo: 37;
	    shipment: 38;
	    transport: 39;
	    project: 40;
	}
	export type EntryTypeEnum = keyof EntryTypeEnum$EnumInterface;
	export const entryTypeEnumDatatype: X3EnumDataType<keyof EntryTypeEnum$EnumInterface, unknown>;
	//# sourceMappingURL=entry-type-enum.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/entered-stock-line-status.d.ts
declare module '@sage/x3-stock-data/lib/enums/entered-stock-line-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum EnteredStockLineStatusEnum {
	    newLine = 1,
	    oldLine = 2,
	    changedUnit = 3,
	    notControlled = 4,
	    controlled = 5,
	    analysisRequested = 6,
	    suspended = 7
	}
	export interface EnteredStockLineStatus$EnumInterface {
	    newLine: 1;
	    oldLine: 2;
	    changedUnit: 3;
	    notControlled: 4;
	    controlled: 5;
	    analysisRequested: 6;
	    suspended: 7;
	}
	export type EnteredStockLineStatus = keyof EnteredStockLineStatus$EnumInterface;
	export const enteredStockLineStatusDatatype: X3EnumDataType<keyof EnteredStockLineStatus$EnumInterface, unknown>;
	//# sourceMappingURL=entered-stock-line-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/element.d.ts
declare module '@sage/x3-stock-data/lib/enums/element' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ElementEnum {
	    programSrcAdx = 1,
	    reportRpt = 2,
	    screenDico = 3,
	    functionDico = 4,
	    objectDico = 5,
	    windowDico = 6,
	    inquiryDico = 7,
	    actionDico = 8,
	    reportDico = 9
	}
	export interface Element$EnumInterface {
	    programSrcAdx: 1;
	    reportRpt: 2;
	    screenDico: 3;
	    functionDico: 4;
	    objectDico: 5;
	    windowDico: 6;
	    inquiryDico: 7;
	    actionDico: 8;
	    reportDico: 9;
	}
	export type Element = keyof Element$EnumInterface;
	export const elementDatatype: X3EnumDataType<keyof Element$EnumInterface, unknown>;
	//# sourceMappingURL=element.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/document-for-labels.d.ts
declare module '@sage/x3-stock-data/lib/enums/document-for-labels' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentForLabelsEnum {
	    receipt = 1,
	    workOrder = 2,
	    customerReturn = 3,
	    productionReporting = 4,
	    miscellaneousStock = 5,
	    materialReturn = 6
	}
	export interface DocumentForLabels$EnumInterface {
	    receipt: 1;
	    workOrder: 2;
	    customerReturn: 3;
	    productionReporting: 4;
	    miscellaneousStock: 5;
	    materialReturn: 6;
	}
	export type DocumentForLabels = keyof DocumentForLabels$EnumInterface;
	export const documentForLabelsDatatype: X3EnumDataType<keyof DocumentForLabels$EnumInterface, unknown>;
	//# sourceMappingURL=document-for-labels.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/document-category.d.ts
declare module '@sage/x3-stock-data/lib/enums/document-category' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DocumentCategoryEnum {
	    no = 1,
	    sales = 2,
	    production = 3,
	    internal = 4
	}
	export interface DocumentCategory$EnumInterface {
	    no: 1;
	    sales: 2;
	    production: 3;
	    internal: 4;
	}
	export type DocumentCategory = keyof DocumentCategory$EnumInterface;
	export const documentCategoryDatatype: X3EnumDataType<keyof DocumentCategory$EnumInterface, unknown>;
	//# sourceMappingURL=document-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/dimension-cost-group.d.ts
declare module '@sage/x3-stock-data/lib/enums/dimension-cost-group' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DimensionCostGroupEnum {
	    subtotal1 = 1,
	    subtotal2 = 2,
	    subtotal3 = 3,
	    subtotal4 = 4,
	    subtotal5 = 5,
	    subtotal6 = 6,
	    subtotal7 = 7,
	    subtotal8 = 8,
	    subtotal9 = 9,
	    subtotal10 = 10,
	    subtotal11 = 11,
	    subtotal12 = 12,
	    subtotal13 = 13,
	    subtotal14 = 14,
	    subtotal15 = 15
	}
	export interface DimensionCostGroup$EnumInterface {
	    subtotal1: 1;
	    subtotal2: 2;
	    subtotal3: 3;
	    subtotal4: 4;
	    subtotal5: 5;
	    subtotal6: 6;
	    subtotal7: 7;
	    subtotal8: 8;
	    subtotal9: 9;
	    subtotal10: 10;
	    subtotal11: 11;
	    subtotal12: 12;
	    subtotal13: 13;
	    subtotal14: 14;
	    subtotal15: 15;
	}
	export type DimensionCostGroup = keyof DimensionCostGroup$EnumInterface;
	export const dimensionCostGroupDatatype: X3EnumDataType<keyof DimensionCostGroup$EnumInterface, unknown>;
	//# sourceMappingURL=dimension-cost-group.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/detail-stock-selection.d.ts
declare module '@sage/x3-stock-data/lib/enums/detail-stock-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DetailStockSelectionEnum {
	    lot = 1,
	    serial = 2,
	    unitQuantity = 3
	}
	export interface DetailStockSelection$EnumInterface {
	    lot: 1;
	    serial: 2;
	    unitQuantity: 3;
	}
	export type DetailStockSelection = keyof DetailStockSelection$EnumInterface;
	export const detailStockSelectionDatatype: X3EnumDataType<keyof DetailStockSelection$EnumInterface, unknown>;
	//# sourceMappingURL=detail-stock-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/destination-choice.d.ts
declare module '@sage/x3-stock-data/lib/enums/destination-choice' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DestinationChoiceEnum {
	    internal = 1,
	    intersite = 2,
	    customer = 3,
	    subcontractTransfer = 4,
	    subcontractReturn = 5
	}
	export interface DestinationChoice$EnumInterface {
	    internal: 1;
	    intersite: 2;
	    customer: 3;
	    subcontractTransfer: 4;
	    subcontractReturn: 5;
	}
	export type DestinationChoice = keyof DestinationChoice$EnumInterface;
	export const destinationChoiceDatatype: X3EnumDataType<keyof DestinationChoice$EnumInterface, unknown>;
	//# sourceMappingURL=destination-choice.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/definition-level-2742.d.ts
declare module '@sage/x3-stock-data/lib/enums/definition-level-2742' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefinitionLevel2742Enum {
	    file = 1,
	    category = 2,
	    categoryWithMovementCode = 3,
	    siteCategory = 4,
	    siteCategoryWithMovementCode = 5
	}
	export interface DefinitionLevel2742$EnumInterface {
	    file: 1;
	    category: 2;
	    categoryWithMovementCode: 3;
	    siteCategory: 4;
	    siteCategoryWithMovementCode: 5;
	}
	export type DefinitionLevel2742 = keyof DefinitionLevel2742$EnumInterface;
	export const definitionLevel2742Datatype: X3EnumDataType<keyof DefinitionLevel2742$EnumInterface, unknown>;
	//# sourceMappingURL=definition-level-2742.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/default-uom.d.ts
declare module '@sage/x3-stock-data/lib/enums/default-uom' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefaultUomEnum {
	    stockUnit = 1,
	    productPurchaseUnit = 2,
	    supplierPurchaseUnit = 3,
	    productPackingUnit1 = 4,
	    productPackingUnit2 = 5,
	    supplierPackingUnit = 6,
	    productSalesUnit = 7,
	    documentLineUnit = 8
	}
	export interface DefaultUom$EnumInterface {
	    stockUnit: 1;
	    productPurchaseUnit: 2;
	    supplierPurchaseUnit: 3;
	    productPackingUnit1: 4;
	    productPackingUnit2: 5;
	    supplierPackingUnit: 6;
	    productSalesUnit: 7;
	    documentLineUnit: 8;
	}
	export type DefaultUom = keyof DefaultUom$EnumInterface;
	export const defaultUomDatatype: X3EnumDataType<keyof DefaultUom$EnumInterface, unknown>;
	//# sourceMappingURL=default-uom.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/default-lot.d.ts
declare module '@sage/x3-stock-data/lib/enums/default-lot' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum DefaultLotEnum {
	    none = 1,
	    supplierLot = 2,
	    documentNumber = 3
	}
	export interface DefaultLot$EnumInterface {
	    none: 1;
	    supplierLot: 2;
	    documentNumber: 3;
	}
	export type DefaultLot = keyof DefaultLot$EnumInterface;
	export const defaultLotDatatype: X3EnumDataType<keyof DefaultLot$EnumInterface, unknown>;
	//# sourceMappingURL=default-lot.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/crystal-report-stock.d.ts
declare module '@sage/x3-stock-data/lib/enums/crystal-report-stock' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CrystalReportStockEnum {
	    dummyValue = 0
	}
	export interface CrystalReportStock$EnumInterface {
	    dummyValue: 0;
	}
	export type CrystalReportStock = keyof CrystalReportStock$EnumInterface;
	export const crystalReportStockDatatype: X3EnumDataType<"dummyValue", unknown>;
	//# sourceMappingURL=crystal-report-stock.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/count-worksheet-selection.d.ts
declare module '@sage/x3-stock-data/lib/enums/count-worksheet-selection' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CountWorksheetSelectionEnum {
	    manualEntry = 1,
	    cycleCounting = 2,
	    annualCount = 3,
	    zeroStockCount = 4
	}
	export interface CountWorksheetSelection$EnumInterface {
	    manualEntry: 1;
	    cycleCounting: 2;
	    annualCount: 3;
	    zeroStockCount: 4;
	}
	export type CountWorksheetSelection = keyof CountWorksheetSelection$EnumInterface;
	export const countWorksheetSelectionDatatype: X3EnumDataType<keyof CountWorksheetSelection$EnumInterface, unknown>;
	//# sourceMappingURL=count-worksheet-selection.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/count-difference-adjustment.d.ts
declare module '@sage/x3-stock-data/lib/enums/count-difference-adjustment' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CountDifferenceAdjustmentEnum {
	    formerPrices = 1,
	    newPrices = 2
	}
	export interface CountDifferenceAdjustment$EnumInterface {
	    formerPrices: 1;
	    newPrices: 2;
	}
	export type CountDifferenceAdjustment = keyof CountDifferenceAdjustment$EnumInterface;
	export const countDifferenceAdjustmentDatatype: X3EnumDataType<keyof CountDifferenceAdjustment$EnumInterface, unknown>;
	//# sourceMappingURL=count-difference-adjustment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/count-and-auc-differences.d.ts
declare module '@sage/x3-stock-data/lib/enums/count-and-auc-differences' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CountAndAucDifferencesEnum {
	    noAucModification = 1,
	    adjustment = 2,
	    differenceAdjustment03 = 3,
	    differenceAdjustment0 = 4
	}
	export interface CountAndAucDifferences$EnumInterface {
	    noAucModification: 1;
	    adjustment: 2;
	    differenceAdjustment03: 3;
	    differenceAdjustment0: 4;
	}
	export type CountAndAucDifferences = keyof CountAndAucDifferences$EnumInterface;
	export const countAndAucDifferencesDatatype: X3EnumDataType<keyof CountAndAucDifferences$EnumInterface, unknown>;
	//# sourceMappingURL=count-and-auc-differences.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/cost-source.d.ts
declare module '@sage/x3-stock-data/lib/enums/cost-source' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CostSourceEnum {
	    entered = 1,
	    standardCost = 2,
	    revisedStandardCost = 3,
	    lastCost = 4,
	    historicalAuc = 5,
	    fifoCost = 6,
	    lotAverageCost = 7,
	    orderCost = 8,
	    lifoCost = 9,
	    lastPurchasePrice = 10
	}
	export interface CostSource$EnumInterface {
	    entered: 1;
	    standardCost: 2;
	    revisedStandardCost: 3;
	    lastCost: 4;
	    historicalAuc: 5;
	    fifoCost: 6;
	    lotAverageCost: 7;
	    orderCost: 8;
	    lifoCost: 9;
	    lastPurchasePrice: 10;
	}
	export type CostSource = keyof CostSource$EnumInterface;
	export const costSourceDatatype: X3EnumDataType<keyof CostSource$EnumInterface, unknown>;
	//# sourceMappingURL=cost-source.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/container-status.d.ts
declare module '@sage/x3-stock-data/lib/enums/container-status' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ContainerStatusEnum {
	    free = 1,
	    inStock = 2
	}
	export interface ContainerStatus$EnumInterface {
	    free: 1;
	    inStock: 2;
	}
	export type ContainerStatus = keyof ContainerStatus$EnumInterface;
	export const containerStatusDatatype: X3EnumDataType<keyof ContainerStatus$EnumInterface, unknown>;
	//# sourceMappingURL=container-status.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/consumption-reorder-plan-sort.d.ts
declare module '@sage/x3-stock-data/lib/enums/consumption-reorder-plan-sort' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConsumptionReorderPlanSortEnum {
	    location = 1,
	    product = 2,
	    sourceLocation = 3,
	    sourceProduct = 4
	}
	export interface ConsumptionReorderPlanSort$EnumInterface {
	    location: 1;
	    product: 2;
	    sourceLocation: 3;
	    sourceProduct: 4;
	}
	export type ConsumptionReorderPlanSort = keyof ConsumptionReorderPlanSort$EnumInterface;
	export const consumptionReorderPlanSortDatatype: X3EnumDataType<keyof ConsumptionReorderPlanSort$EnumInterface, unknown>;
	//# sourceMappingURL=consumption-reorder-plan-sort.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/constraints-options-variants.d.ts
declare module '@sage/x3-stock-data/lib/enums/constraints-options-variants' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConstraintsOptionsVariantsEnum {
	    mandatoryChoice = 1,
	    linkedWith = 2,
	    notAllowedWith = 3
	}
	export interface ConstraintsOptionsVariants$EnumInterface {
	    mandatoryChoice: 1;
	    linkedWith: 2;
	    notAllowedWith: 3;
	}
	export type ConstraintsOptionsVariants = keyof ConstraintsOptionsVariants$EnumInterface;
	export const constraintsOptionsVariantsDatatype: X3EnumDataType<keyof ConstraintsOptionsVariants$EnumInterface, unknown>;
	//# sourceMappingURL=constraints-options-variants.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/consolidations-previsions-roun.d.ts
declare module '@sage/x3-stock-data/lib/enums/consolidations-previsions-roun' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConsolidationsPrevisionsRounEnum {
	    noRounding = 1,
	    roundToTheNearest = 2,
	    roundDown = 3,
	    roundUp = 4
	}
	export interface ConsolidationsPrevisionsRoun$EnumInterface {
	    noRounding: 1;
	    roundToTheNearest: 2;
	    roundDown: 3;
	    roundUp: 4;
	}
	export type ConsolidationsPrevisionsRoun = keyof ConsolidationsPrevisionsRoun$EnumInterface;
	export const consolidationsPrevisionsRounDatatype: X3EnumDataType<keyof ConsolidationsPrevisionsRoun$EnumInterface, unknown>;
	//# sourceMappingURL=consolidations-previsions-roun.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/configurator-system-variables.d.ts
declare module '@sage/x3-stock-data/lib/enums/configurator-system-variables' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConfiguratorSystemVariablesEnum {
	    site = 1,
	    processDate = 2,
	    currency = 3,
	    log = 4,
	    bpNumber = 5,
	    bpReference = 6,
	    purgeDate = 7,
	    parentProductQuantity = 8,
	    noHistory = 9,
	    listOfParentProducts = 10,
	    listComponents = 11,
	    parentProduct = 12,
	    routing = 13,
	    totalCost = 14,
	    materialCost = 15,
	    machineCost = 16,
	    laborCost = 17,
	    subcontractCost = 18,
	    overheadCost = 19,
	    calculatedUnitCost = 20,
	    productNumber = 21,
	    productDescription = 22,
	    productLine = 23,
	    numField1 = 24,
	    numField2 = 25,
	    numField3 = 26,
	    numField4 = 27,
	    numField5 = 28,
	    numField6 = 29,
	    alphaField1 = 30,
	    alphaField2 = 31,
	    alphaField3 = 32,
	    alphaField4 = 33,
	    alphaField5 = 34,
	    alphaField6 = 35,
	    linkTableOk = 36,
	    roundedVariableCalculation = 37,
	    manageLevelSettting = 38,
	    masterScenario = 39,
	    selectionTableFilter = 40,
	    referenceOfParentProduct = 41,
	    genericDesig1 = 42,
	    genericDesig2 = 43,
	    genericDesig3 = 44,
	    memoPurgeDelay = 45,
	    dynamicAmount = 46,
	    dynamicTable = 47,
	    blowDownTheBill = 48,
	    bomCode = 49,
	    referenceBomCode = 50,
	    routingCode = 51,
	    referenceRoutingCode = 52,
	    supplierProduct = 53,
	    customerProduct = 54,
	    supplierProductDescription = 55,
	    customerProductDescription = 56,
	    filterForResponseTable = 57
	}
	export interface ConfiguratorSystemVariables$EnumInterface {
	    site: 1;
	    processDate: 2;
	    currency: 3;
	    log: 4;
	    bpNumber: 5;
	    bpReference: 6;
	    purgeDate: 7;
	    parentProductQuantity: 8;
	    noHistory: 9;
	    listOfParentProducts: 10;
	    listComponents: 11;
	    parentProduct: 12;
	    routing: 13;
	    totalCost: 14;
	    materialCost: 15;
	    machineCost: 16;
	    laborCost: 17;
	    subcontractCost: 18;
	    overheadCost: 19;
	    calculatedUnitCost: 20;
	    productNumber: 21;
	    productDescription: 22;
	    productLine: 23;
	    numField1: 24;
	    numField2: 25;
	    numField3: 26;
	    numField4: 27;
	    numField5: 28;
	    numField6: 29;
	    alphaField1: 30;
	    alphaField2: 31;
	    alphaField3: 32;
	    alphaField4: 33;
	    alphaField5: 34;
	    alphaField6: 35;
	    linkTableOk: 36;
	    roundedVariableCalculation: 37;
	    manageLevelSettting: 38;
	    masterScenario: 39;
	    selectionTableFilter: 40;
	    referenceOfParentProduct: 41;
	    genericDesig1: 42;
	    genericDesig2: 43;
	    genericDesig3: 44;
	    memoPurgeDelay: 45;
	    dynamicAmount: 46;
	    dynamicTable: 47;
	    blowDownTheBill: 48;
	    bomCode: 49;
	    referenceBomCode: 50;
	    routingCode: 51;
	    referenceRoutingCode: 52;
	    supplierProduct: 53;
	    customerProduct: 54;
	    supplierProductDescription: 55;
	    customerProductDescription: 56;
	    filterForResponseTable: 57;
	}
	export type ConfiguratorSystemVariables = keyof ConfiguratorSystemVariables$EnumInterface;
	export const configuratorSystemVariablesDatatype: X3EnumDataType<keyof ConfiguratorSystemVariables$EnumInterface, unknown>;
	//# sourceMappingURL=configurator-system-variables.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/configurator-symbol-origin.d.ts
declare module '@sage/x3-stock-data/lib/enums/configurator-symbol-origin' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConfiguratorSymbolOriginEnum {
	    user = 1,
	    system2 = 2,
	    system3 = 3,
	    system4 = 4
	}
	export interface ConfiguratorSymbolOrigin$EnumInterface {
	    user: 1;
	    system2: 2;
	    system3: 3;
	    system4: 4;
	}
	export type ConfiguratorSymbolOrigin = keyof ConfiguratorSymbolOrigin$EnumInterface;
	export const configuratorSymbolOriginDatatype: X3EnumDataType<keyof ConfiguratorSymbolOrigin$EnumInterface, unknown>;
	//# sourceMappingURL=configurator-symbol-origin.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/configurator-selection-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/configurator-selection-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConfiguratorSelectionTypeEnum {
	    selectProducts = 1,
	    selectOptionsVariants = 2
	}
	export interface ConfiguratorSelectionType$EnumInterface {
	    selectProducts: 1;
	    selectOptionsVariants: 2;
	}
	export type ConfiguratorSelectionType = keyof ConfiguratorSelectionType$EnumInterface;
	export const configuratorSelectionTypeDatatype: X3EnumDataType<keyof ConfiguratorSelectionType$EnumInterface, unknown>;
	//# sourceMappingURL=configurator-selection-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/configurator-field-control.d.ts
declare module '@sage/x3-stock-data/lib/enums/configurator-field-control' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConfiguratorFieldControlEnum {
	    mandatoryEntry = 1,
	    optionalEntry = 2,
	    display = 3,
	    hidden = 4
	}
	export interface ConfiguratorFieldControl$EnumInterface {
	    mandatoryEntry: 1;
	    optionalEntry: 2;
	    display: 3;
	    hidden: 4;
	}
	export type ConfiguratorFieldControl = keyof ConfiguratorFieldControl$EnumInterface;
	export const configuratorFieldControlDatatype: X3EnumDataType<keyof ConfiguratorFieldControl$EnumInterface, unknown>;
	//# sourceMappingURL=configurator-field-control.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/configurator-actions.d.ts
declare module '@sage/x3-stock-data/lib/enums/configurator-actions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConfiguratorActionsEnum {
	    noAction = 1,
	    noSelection = 2,
	    select0Or1Line = 3,
	    select1Line = 4,
	    select0ToNLines = 5,
	    select1ToNLines = 6,
	    reWork = 7,
	    information = 8,
	    blocking = 9
	}
	export interface ConfiguratorActions$EnumInterface {
	    noAction: 1;
	    noSelection: 2;
	    select0Or1Line: 3;
	    select1Line: 4;
	    select0ToNLines: 5;
	    select1ToNLines: 6;
	    reWork: 7;
	    information: 8;
	    blocking: 9;
	}
	export type ConfiguratorActions = keyof ConfiguratorActions$EnumInterface;
	export const configuratorActionsDatatype: X3EnumDataType<keyof ConfiguratorActions$EnumInterface, unknown>;
	//# sourceMappingURL=configurator-actions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/config-scenarios-entry-mode.d.ts
declare module '@sage/x3-stock-data/lib/enums/config-scenarios-entry-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ConfigScenariosEntryModeEnum {
	    standard = 1,
	    assisted = 2,
	    questionByQuestion = 3
	}
	export interface ConfigScenariosEntryMode$EnumInterface {
	    standard: 1;
	    assisted: 2;
	    questionByQuestion: 3;
	}
	export type ConfigScenariosEntryMode = keyof ConfigScenariosEntryMode$EnumInterface;
	export const configScenariosEntryModeDatatype: X3EnumDataType<keyof ConfigScenariosEntryMode$EnumInterface, unknown>;
	//# sourceMappingURL=config-scenarios-entry-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/component-rounding.d.ts
declare module '@sage/x3-stock-data/lib/enums/component-rounding' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ComponentRoundingEnum {
	    theNearest = 1,
	    higher = 2,
	    lower = 3
	}
	export interface ComponentRounding$EnumInterface {
	    theNearest: 1;
	    higher: 2;
	    lower: 3;
	}
	export type ComponentRounding = keyof ComponentRounding$EnumInterface;
	export const componentRoundingDatatype: X3EnumDataType<keyof ComponentRounding$EnumInterface, unknown>;
	//# sourceMappingURL=component-rounding.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/component-rounding-2728.d.ts
declare module '@sage/x3-stock-data/lib/enums/component-rounding-2728' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ComponentRounding2728Enum {
	    toTheNearest = 1,
	    higher = 2,
	    lower = 3
	}
	export interface ComponentRounding2728$EnumInterface {
	    toTheNearest: 1;
	    higher: 2;
	    lower: 3;
	}
	export type ComponentRounding2728 = keyof ComponentRounding2728$EnumInterface;
	export const componentRounding2728Datatype: X3EnumDataType<keyof ComponentRounding2728$EnumInterface, unknown>;
	//# sourceMappingURL=component-rounding-2728.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/component-rounding-2727.d.ts
declare module '@sage/x3-stock-data/lib/enums/component-rounding-2727' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ComponentRounding2727Enum {
	    theNearest = 1,
	    higher = 2,
	    lower = 3
	}
	export interface ComponentRounding2727$EnumInterface {
	    theNearest: 1;
	    higher: 2;
	    lower: 3;
	}
	export type ComponentRounding2727 = keyof ComponentRounding2727$EnumInterface;
	export const componentRounding2727Datatype: X3EnumDataType<keyof ComponentRounding2727$EnumInterface, unknown>;
	//# sourceMappingURL=component-rounding-2727.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/component-requirements.d.ts
declare module '@sage/x3-stock-data/lib/enums/component-requirements' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ComponentRequirementsEnum {
	    byProduct = 1,
	    byLevelProduct = 2,
	    byLevelParentProduct = 3,
	    byBom = 4
	}
	export interface ComponentRequirements$EnumInterface {
	    byProduct: 1;
	    byLevelProduct: 2;
	    byLevelParentProduct: 3;
	    byBom: 4;
	}
	export type ComponentRequirements = keyof ComponentRequirements$EnumInterface;
	export const componentRequirementsDatatype: X3EnumDataType<keyof ComponentRequirements$EnumInterface, unknown>;
	//# sourceMappingURL=component-requirements.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/combined-transactions.d.ts
declare module '@sage/x3-stock-data/lib/enums/combined-transactions' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CombinedTransactionsEnum {
	    no = 1,
	    prodCompWithoutScrap = 2,
	    prodCompWithScrap = 3,
	    onlyCompWithoutScrap = 4,
	    onlyCompWithScrap = 5
	}
	export interface CombinedTransactions$EnumInterface {
	    no: 1;
	    prodCompWithoutScrap: 2;
	    prodCompWithScrap: 3;
	    onlyCompWithoutScrap: 4;
	    onlyCompWithScrap: 5;
	}
	export type CombinedTransactions = keyof CombinedTransactions$EnumInterface;
	export const combinedTransactionsDatatype: X3EnumDataType<keyof CombinedTransactions$EnumInterface, unknown>;
	//# sourceMappingURL=combined-transactions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/choose-standard-process.d.ts
declare module '@sage/x3-stock-data/lib/enums/choose-standard-process' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ChooseStandardProcessEnum {
	    forSelections = 1,
	    forScenarios = 2,
	    masterScenario = 3
	}
	export interface ChooseStandardProcess$EnumInterface {
	    forSelections: 1;
	    forScenarios: 2;
	    masterScenario: 3;
	}
	export type ChooseStandardProcess = keyof ChooseStandardProcess$EnumInterface;
	export const chooseStandardProcessDatatype: X3EnumDataType<keyof ChooseStandardProcess$EnumInterface, unknown>;
	//# sourceMappingURL=choose-standard-process.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/choose-quantity-column.d.ts
declare module '@sage/x3-stock-data/lib/enums/choose-quantity-column' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum ChooseQuantityColumnEnum {
	    no = 1,
	    stockUnitColumn = 2,
	    salesUnitColumn = 3
	}
	export interface ChooseQuantityColumn$EnumInterface {
	    no: 1;
	    stockUnitColumn: 2;
	    salesUnitColumn: 3;
	}
	export type ChooseQuantityColumn = keyof ChooseQuantityColumn$EnumInterface;
	export const chooseQuantityColumnDatatype: X3EnumDataType<keyof ChooseQuantityColumn$EnumInterface, unknown>;
	//# sourceMappingURL=choose-quantity-column.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/catalog-types.d.ts
declare module '@sage/x3-stock-data/lib/enums/catalog-types' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CatalogTypesEnum {
	    tablesAtable = 1,
	    functionsAfonction = 2,
	    objectsAobjet = 3,
	    screensAmsk = 4,
	    subProgramsAsubprog = 5,
	    programsAprog = 6,
	    reportsAreport = 7,
	    windowsAwindow = 8,
	    inquiriesAconsult = 9
	}
	export interface CatalogTypes$EnumInterface {
	    tablesAtable: 1;
	    functionsAfonction: 2;
	    objectsAobjet: 3;
	    screensAmsk: 4;
	    subProgramsAsubprog: 5;
	    programsAprog: 6;
	    reportsAreport: 7;
	    windowsAwindow: 8;
	    inquiriesAconsult: 9;
	}
	export type CatalogTypes = keyof CatalogTypes$EnumInterface;
	export const catalogTypesDatatype: X3EnumDataType<keyof CatalogTypes$EnumInterface, unknown>;
	//# sourceMappingURL=catalog-types.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/calendar-correction.d.ts
declare module '@sage/x3-stock-data/lib/enums/calendar-correction' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum CalendarCorrectionEnum {
	    no = 1,
	    value = 2,
	    quantity = 3
	}
	export interface CalendarCorrection$EnumInterface {
	    no: 1;
	    value: 2;
	    quantity: 3;
	}
	export type CalendarCorrection = keyof CalendarCorrection$EnumInterface;
	export const calendarCorrectionDatatype: X3EnumDataType<keyof CalendarCorrection$EnumInterface, unknown>;
	//# sourceMappingURL=calendar-correction.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/blocked-stock.d.ts
declare module '@sage/x3-stock-data/lib/enums/blocked-stock' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum BlockedStockEnum {
	    no = 1,
	    yes = 2,
	    partial = 3
	}
	export interface BlockedStock$EnumInterface {
	    no: 1;
	    yes: 2;
	    partial: 3;
	}
	export type BlockedStock = keyof BlockedStock$EnumInterface;
	export const blockedStockDatatype: X3EnumDataType<keyof BlockedStock$EnumInterface, unknown>;
	//# sourceMappingURL=blocked-stock.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/average-cost-initialization.d.ts
declare module '@sage/x3-stock-data/lib/enums/average-cost-initialization' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AverageCostInitializationEnum {
	    monthly = 1,
	    annual = 2,
	    moving = 3
	}
	export interface AverageCostInitialization$EnumInterface {
	    monthly: 1;
	    annual: 2;
	    moving: 3;
	}
	export type AverageCostInitialization = keyof AverageCostInitialization$EnumInterface;
	export const averageCostInitializationDatatype: X3EnumDataType<keyof AverageCostInitialization$EnumInterface, unknown>;
	//# sourceMappingURL=average-cost-initialization.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/assignment-mode.d.ts
declare module '@sage/x3-stock-data/lib/enums/assignment-mode' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssignmentModeEnum {
	    simple = 1,
	    multiple = 2
	}
	export interface AssignmentMode$EnumInterface {
	    simple: 1;
	    multiple: 2;
	}
	export type AssignmentMode = keyof AssignmentMode$EnumInterface;
	export const assignmentModeDatatype: X3EnumDataType<keyof AssignmentMode$EnumInterface, unknown>;
	//# sourceMappingURL=assignment-mode.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/assembly-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/assembly-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AssemblyTypeEnum {
	    assembly = 1,
	    disassembly = 2
	}
	export interface AssemblyType$EnumInterface {
	    assembly: 1;
	    disassembly: 2;
	}
	export type AssemblyType = keyof AssemblyType$EnumInterface;
	export const assemblyTypeDatatype: X3EnumDataType<keyof AssemblyType$EnumInterface, unknown>;
	//# sourceMappingURL=assembly-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/allocation-messages.d.ts
declare module '@sage/x3-stock-data/lib/enums/allocation-messages' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AllocationMessagesEnum {
	    cancelled = 1
	}
	export interface AllocationMessages$EnumInterface {
	    cancelled: 1;
	}
	export type AllocationMessages = keyof AllocationMessages$EnumInterface;
	export const allocationMessagesDatatype: X3EnumDataType<"cancelled", unknown>;
	//# sourceMappingURL=allocation-messages.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/adjustment-of-stock-shortages.d.ts
declare module '@sage/x3-stock-data/lib/enums/adjustment-of-stock-shortages' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AdjustmentOfStockShortagesEnum {
	    noProcessing = 1,
	    suspendedTransactions = 2,
	    shortagesOnNonValidatedIssues = 3,
	    shortagesOnOrderWo = 4
	}
	export interface AdjustmentOfStockShortages$EnumInterface {
	    noProcessing: 1;
	    suspendedTransactions: 2;
	    shortagesOnNonValidatedIssues: 3;
	    shortagesOnOrderWo: 4;
	}
	export type AdjustmentOfStockShortages = keyof AdjustmentOfStockShortages$EnumInterface;
	export const adjustmentOfStockShortagesDatatype: X3EnumDataType<keyof AdjustmentOfStockShortages$EnumInterface, unknown>;
	//# sourceMappingURL=adjustment-of-stock-shortages.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/adc-flow-type.d.ts
declare module '@sage/x3-stock-data/lib/enums/adc-flow-type' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AdcFlowTypeEnum {
	    issueFlow = 1,
	    stockChange = 2,
	    containerOperation = 3,
	    pickTicket = 4
	}
	export interface AdcFlowType$EnumInterface {
	    issueFlow: 1;
	    stockChange: 2;
	    containerOperation: 3;
	    pickTicket: 4;
	}
	export type AdcFlowType = keyof AdcFlowType$EnumInterface;
	export const adcFlowTypeDatatype: X3EnumDataType<keyof AdcFlowType$EnumInterface, unknown>;
	//# sourceMappingURL=adc-flow-type.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/abreviations-menu-252.d.ts
declare module '@sage/x3-stock-data/lib/enums/abreviations-menu-252' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AbreviationsMenu252Enum {
	    x1 = 1,
	    substituteValue2 = 2,
	    d = 3,
	    b = 4,
	    x = 5
	}
	export interface AbreviationsMenu252$EnumInterface {
	    x1: 1;
	    substituteValue2: 2;
	    d: 3;
	    b: 4;
	    x: 5;
	}
	export type AbreviationsMenu252 = keyof AbreviationsMenu252$EnumInterface;
	export const abreviationsMenu252Datatype: X3EnumDataType<keyof AbreviationsMenu252$EnumInterface, unknown>;
	//# sourceMappingURL=abreviations-menu-252.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/shared/x3-stock-data/build/lib/enums/abc-class-calculation.d.ts
declare module '@sage/x3-stock-data/lib/enums/abc-class-calculation' {
	import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
	export enum AbcClassCalculationEnum {
	    calculationWithoutUpdate = 1,
	    calculationWithUpdate = 2,
	    updateOnly = 3
	}
	export interface AbcClassCalculation$EnumInterface {
	    calculationWithoutUpdate: 1;
	    calculationWithUpdate: 2;
	    updateOnly: 3;
	}
	export type AbcClassCalculation = keyof AbcClassCalculation$EnumInterface;
	export const abcClassCalculationDatatype: X3EnumDataType<keyof AbcClassCalculation$EnumInterface, unknown>;
	//# sourceMappingURL=abc-class-calculation.d.ts.map
}
declare module '@sage/x3-stock-data' {
	export * from '@sage/x3-stock-data/index';
}
