/*
 * ATTENTION: An "eval-source-map" devtool has been used.
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file with attached SourceMaps in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	// runtime can't be in strict mode because a global variable is assign and maybe created.
/******/ 	var __webpack_modules__ = ({

/***/ "./lib/stickers/mobile-stock-site.ts":
/*!*******************************************!*\
  !*** ./lib/stickers/mobile-stock-site.ts ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
eval("\nvar __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {\n    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;\n    if (typeof Reflect === \"object\" && typeof Reflect.decorate === \"function\") r = Reflect.decorate(decorators, target, key, desc);\n    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;\n    return c > 3 && r && Object.defineProperty(target, key, r), r;\n};\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.MobileStockSite = void 0;\nconst user_parameters_values_1 = __webpack_require__(/*! @sage/x3-system/lib/client-functions/user-parameters-values */ \"../x3-system/lib/client-functions/user-parameters-values.ts\");\nconst xtrem_client_1 = __webpack_require__(/*! @sage/xtrem-client */ \"@sage/xtrem-client\");\nconst ui = __webpack_require__(/*! @sage/xtrem-ui */ \"@sage/xtrem-ui\");\nvar MobileFlowTypeEnum;\n(function (MobileFlowTypeEnum) {\n    MobileFlowTypeEnum[MobileFlowTypeEnum[\"issue\"] = 1] = \"issue\";\n    MobileFlowTypeEnum[MobileFlowTypeEnum[\"stockChange\"] = 2] = \"stockChange\";\n    MobileFlowTypeEnum[MobileFlowTypeEnum[\"lpnOperation\"] = 3] = \"lpnOperation\";\n    MobileFlowTypeEnum[MobileFlowTypeEnum[\"pickTicket\"] = 4] = \"pickTicket\";\n})(MobileFlowTypeEnum || (MobileFlowTypeEnum = {}));\nlet MobileStockSite = class MobileStockSite extends ui.Sticker {\n    async _setMobileSettings(_selectedSite) {\n        if (_selectedSite) {\n            this.$.storage.set('mobile-selected-stock-site', _selectedSite);\n            const MobileSettingsLpnOperation = await this._readMobileSettings(_selectedSite, MobileFlowTypeEnum.lpnOperation);\n            this.$.storage.set('mobile-settings-lpn-operation', JSON.stringify(MobileSettingsLpnOperation ?? {}));\n            const MobileSettingsStockChange = await this._readMobileSettings(_selectedSite, MobileFlowTypeEnum.stockChange);\n            this.$.storage.set('mobile-settings-stock-change', JSON.stringify(MobileSettingsStockChange ?? {}));\n            const MobileSettingsIssue = await this._readMobileSettings(_selectedSite, MobileFlowTypeEnum.issue);\n            this.$.storage.set('mobile-settings-issue', JSON.stringify(MobileSettingsIssue ?? {}));\n            const MobileSettingsPickTicket = await this._readMobileSettings(_selectedSite, MobileFlowTypeEnum.pickTicket);\n            this.$.storage.set('mobile-settings-pick-ticket', JSON.stringify(MobileSettingsPickTicket ?? {}));\n            this.$.sticker.updateMenuItem(_selectedSite);\n        }\n    }\n    // (X3-261705) TODO: Issue: Have to use the numeric value of the 'enum type'\n    async _readMobileSettings(stockSiteCode, flowType) {\n        return (0, xtrem_client_1.extractEdges)(await this.$.graph\n            .node('@sage/x3-stock-data/MobileSettings')\n            .query(ui.queryUtils.edgesSelector({\n            stockSite: {\n                code: true,\n            },\n            stockField1: true,\n            stockField2: true,\n            stockField3: true,\n            stockField4: true,\n            stockField5: true,\n            stockField6: true,\n            stockField7: true,\n            stockField8: true,\n        }, {\n            filter: {\n                flowType: flowType,\n                stockSite: { code: { _in: [stockSiteCode, null] } },\n            },\n            orderBy: { stockSite: { code: -1 } }, // ordering to place record with non-null stockSite at the front\n        }))\n            .execute())?.[0];\n    }\n    async _readUser(userCode) {\n        return (await this.$.graph\n            .node('@sage/x3-system/User')\n            .read({\n            code: true,\n            name: true,\n            functionProfile: {\n                profile: true,\n                userProfileDefaultSites: {\n                    query: {\n                        edges: {\n                            node: {\n                                site: {\n                                    code: true,\n                                },\n                            },\n                        },\n                    },\n                },\n            },\n            profession: {\n                profession: true,\n                functionProfile: {\n                    profile: true,\n                    userProfileDefaultSites: {\n                        query: {\n                            edges: {\n                                node: {\n                                    site: {\n                                        code: true,\n                                    },\n                                },\n                            },\n                        },\n                    },\n                },\n            },\n        }, `${userCode?.toUpperCase()}`)\n            .execute());\n    }\n};\nexports.MobileStockSite = MobileStockSite;\n__decorate([\n    ui.decorators.section({\n        title: ui.localize(\"@sage/x3-stock-data/stickers__mobile_stock_site__section____title\", \"Site\"),\n    })\n], MobileStockSite.prototype, \"section\", void 0);\n__decorate([\n    ui.decorators.block({\n        parent() {\n            return this.section;\n        },\n    })\n], MobileStockSite.prototype, \"block\", void 0);\n__decorate([\n    ui.decorators.referenceField({\n        node: '@sage/x3-system/Site',\n        filter() {\n            return { isStockSite: true };\n        },\n        valueField: 'code',\n        columns: [\n            ui.nestedFields.text({ bind: 'code', title: ui.localize(\"@sage/x3-stock-data/stickers__mobile_stock_site__selectionSite____columns__title__code\", \"Site\"), canFilter: true }),\n            ui.nestedFields.text({ bind: 'name', title: ui.localize(\"@sage/x3-stock-data/stickers__mobile_stock_site__selectionSite____columns__title__name\", \"Name\"), canFilter: true }),\n            // (X3-227347) TODO Obsolete: Having to specify & hide fields used in filter that don't need to be displayed\n            ui.nestedFields.checkbox({ bind: 'isStockSite', isHidden: true }),\n        ],\n        isFullWidth: true,\n        isAutoSelectEnabled: true,\n        title: ui.localize(\"@sage/x3-stock-data/stickers__mobile_stock_site__selectionSite____title\", \"Site\"),\n        helperTextField: 'name',\n        parent() {\n            return this.block;\n        },\n        onChange() {\n            this.saveButton.isDisabled = !this.selectionSite.value;\n        },\n    })\n], MobileStockSite.prototype, \"selectionSite\", void 0);\n__decorate([\n    ui.decorators.pageAction({\n        title: ui.localize(\"@sage/x3-stock-data/stickers__mobile_stock_site__saveButton____title\", \"Set site\"),\n        buttonType: 'primary',\n        isTransient: true,\n        isDisabled: true,\n        async onClick() {\n            await this._setMobileSettings(this.selectionSite.value?.code);\n            this.$.finish();\n        },\n    })\n], MobileStockSite.prototype, \"saveButton\", void 0);\nexports.MobileStockSite = MobileStockSite = __decorate([\n    ui.decorators.sticker({\n        title: ui.localize(\"@sage/x3-stock-data/stickers__mobile_stock_site____title\", \"Site\"),\n        icon: 'settings',\n        category: 'mobile',\n        isActive() {\n            return true;\n        },\n        async onLoad() {\n            let sessionSelectedSite = this.$.storage.get('mobile-selected-stock-site'); // Get the default Mobile site from the session storage\n            // If there is no site in the session storage, retrieve it from the getDefaultSiteFromModule service\n            if (!sessionSelectedSite) {\n                const user = await this._readUser(this.$.userCode);\n                if (user) {\n                    sessionSelectedSite = (await (0, user_parameters_values_1.getDefaultSiteFromModule)(user, 7))?.code;\n                }\n                if (!sessionSelectedSite) {\n                    return;\n                }\n            }\n            await this._setMobileSettings(sessionSelectedSite);\n            this.selectionSite.placeholder = sessionSelectedSite; // Set the placeholder to the current Set Site for better user experience\n        },\n        businessActions() {\n            return [this.saveButton];\n        },\n    })\n], MobileStockSite);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./lib/stickers/mobile-stock-site.ts\n");

/***/ }),

/***/ "../x3-system/lib/client-functions/user-parameters-values.ts":
/*!*******************************************************************!*\
  !*** ../x3-system/lib/client-functions/user-parameters-values.ts ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.getDefaultSiteFromModule = exports.getSiteFromModule = exports.getUserProfile = void 0;\nconst xtrem_decimal_1 = __webpack_require__(/*! @sage/xtrem-decimal */ \"@sage/xtrem-decimal\"), typesLib = xtrem_decimal_1;\nasync function getUserProfile(user) {\n    if (user) {\n        const functionProfile = await user.functionProfile;\n        if (!functionProfile) {\n            // eslint-disable-next-line prefer-destructuring\n            const profession = await user.profession;\n            if (profession) {\n                return await profession.functionProfile;\n            }\n        }\n        else {\n            return functionProfile;\n        }\n    }\n    return null;\n}\nexports.getUserProfile = getUserProfile;\nasync function getSiteFromModule(moduleNumber, profile) {\n    const _edges = await profile.userProfileDefaultSites.query.edges;\n    if (typesLib.gt(moduleNumber, 0) && typesLib.lt(moduleNumber, (_edges?.length ?? 0))) {\n        return _edges[typesLib.sub(moduleNumber, 1)].node.site;\n    }\n    return null;\n}\nexports.getSiteFromModule = getSiteFromModule;\nasync function getDefaultSiteFromModule(user, moduleNumber) {\n    const userProfile = await getUserProfile(user);\n    if (userProfile) {\n        return await getSiteFromModule(moduleNumber, userProfile);\n    }\n    return null;\n}\nexports.getDefaultSiteFromModule = getDefaultSiteFromModule;\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi4veDMtc3lzdGVtL2xpYi9jbGllbnQtZnVuY3Rpb25zL3VzZXItcGFyYW1ldGVycy12YWx1ZXMudHMiLCJtYXBwaW5ncyI6Ijs7OztBQUVPLEtBQUssVUFBVSxjQUFjLENBQUMsSUFBaUI7SUFDbEQsSUFBSSxJQUFJLEVBQUUsQ0FBQztRQUNQLE1BQU0sZUFBZSxHQUFHLE1BQU0sSUFBSSxDQUFDLGVBQWUsQ0FBQztRQUNuRCxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7WUFDbkIsZ0RBQWdEO1lBQ2hELE1BQU0sVUFBVSxHQUFHLE1BQU0sSUFBSSxDQUFDLFVBQVUsQ0FBQztZQUN6QyxJQUFJLFVBQVUsRUFBRSxDQUFDO2dCQUNiLE9BQU8sTUFBTSxVQUFVLENBQUMsZUFBZSxDQUFDO1lBQzVDLENBQUM7UUFDTCxDQUFDO2FBQU0sQ0FBQztZQUNKLE9BQU8sZUFBZSxDQUFDO1FBQzNCLENBQUM7SUFDTCxDQUFDO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDaEIsQ0FBQztBQWRELHdDQWNDO0FBRU0sS0FBSyxVQUFVLGlCQUFpQixDQUFDLFlBQW9CLEVBQUUsT0FBNEI7SUFDdEYsTUFBTSxNQUFNLEdBQUcsTUFBTSxPQUFPLENBQUMsdUJBQXVCLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQztJQUNqRSxJQUFJLHdCQUFZLEVBQUcsQ0FBQyxpQkFBSSxZQUFZLEVBQUcsQ0FBQyxNQUFNLEVBQUUsTUFBTSxJQUFJLENBQUMsQ0FBQyxHQUFFLENBQUM7UUFDM0QsT0FBTyxNQUFNLGNBQUMsWUFBWSxFQUFHLENBQUMsRUFBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUM7SUFDOUMsQ0FBQztJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2hCLENBQUM7QUFORCw4Q0FNQztBQUVNLEtBQUssVUFBVSx3QkFBd0IsQ0FBQyxJQUFVLEVBQUUsWUFBb0I7SUFDM0UsTUFBTSxXQUFXLEdBQUcsTUFBTSxjQUFjLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDL0MsSUFBSSxXQUFXLEVBQUUsQ0FBQztRQUNkLE9BQU8sTUFBTSxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsV0FBVyxDQUFDLENBQUM7SUFDOUQsQ0FBQztJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2hCLENBQUM7QUFORCw0REFNQyIsInNvdXJjZXMiOlsid2VicGFjazovL3h0cmVtQXJ0aWZhY3QvLi4veDMtc3lzdGVtL2xpYi9jbGllbnQtZnVuY3Rpb25zL3VzZXItcGFyYW1ldGVycy12YWx1ZXMudHM/ZDdlMCJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTaXRlLCBVc2VyLCBVc2VyRnVuY3Rpb25Qcm9maWxlIH0gZnJvbSAnQHNhZ2UveDMtc3lzdGVtLWFwaSc7XG5cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBnZXRVc2VyUHJvZmlsZSh1c2VyOiBVc2VyIHwgbnVsbCk6IFByb21pc2U8VXNlckZ1bmN0aW9uUHJvZmlsZSB8IG51bGw+IHtcbiAgICBpZiAodXNlcikge1xuICAgICAgICBjb25zdCBmdW5jdGlvblByb2ZpbGUgPSBhd2FpdCB1c2VyLmZ1bmN0aW9uUHJvZmlsZTtcbiAgICAgICAgaWYgKCFmdW5jdGlvblByb2ZpbGUpIHtcbiAgICAgICAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBwcmVmZXItZGVzdHJ1Y3R1cmluZ1xuICAgICAgICAgICAgY29uc3QgcHJvZmVzc2lvbiA9IGF3YWl0IHVzZXIucHJvZmVzc2lvbjtcbiAgICAgICAgICAgIGlmIChwcm9mZXNzaW9uKSB7XG4gICAgICAgICAgICAgICAgcmV0dXJuIGF3YWl0IHByb2Zlc3Npb24uZnVuY3Rpb25Qcm9maWxlO1xuICAgICAgICAgICAgfVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgcmV0dXJuIGZ1bmN0aW9uUHJvZmlsZTtcbiAgICAgICAgfVxuICAgIH1cbiAgICByZXR1cm4gbnVsbDtcbn1cblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGdldFNpdGVGcm9tTW9kdWxlKG1vZHVsZU51bWJlcjogbnVtYmVyLCBwcm9maWxlOiBVc2VyRnVuY3Rpb25Qcm9maWxlKTogUHJvbWlzZTxTaXRlIHwgbnVsbD4ge1xuICAgIGNvbnN0IF9lZGdlcyA9IGF3YWl0IHByb2ZpbGUudXNlclByb2ZpbGVEZWZhdWx0U2l0ZXMucXVlcnkuZWRnZXM7XG4gICAgaWYgKG1vZHVsZU51bWJlciA+IDAgJiYgbW9kdWxlTnVtYmVyIDwgKF9lZGdlcz8ubGVuZ3RoID8/IDApKSB7XG4gICAgICAgIHJldHVybiBfZWRnZXNbbW9kdWxlTnVtYmVyIC0gMV0ubm9kZS5zaXRlO1xuICAgIH1cbiAgICByZXR1cm4gbnVsbDtcbn1cblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGdldERlZmF1bHRTaXRlRnJvbU1vZHVsZSh1c2VyOiBVc2VyLCBtb2R1bGVOdW1iZXI6IG51bWJlcik6IFByb21pc2U8U2l0ZSB8IG51bGw+IHtcbiAgICBjb25zdCB1c2VyUHJvZmlsZSA9IGF3YWl0IGdldFVzZXJQcm9maWxlKHVzZXIpO1xuICAgIGlmICh1c2VyUHJvZmlsZSkge1xuICAgICAgICByZXR1cm4gYXdhaXQgZ2V0U2l0ZUZyb21Nb2R1bGUobW9kdWxlTnVtYmVyLCB1c2VyUHJvZmlsZSk7XG4gICAgfVxuICAgIHJldHVybiBudWxsO1xufVxuIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///../x3-system/lib/client-functions/user-parameters-values.ts\n");

/***/ }),

/***/ "@sage/xtrem-client":
/*!*************************************!*\
  !*** external "@sage/xtrem-client" ***!
  \*************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-client");

/***/ }),

/***/ "@sage/xtrem-decimal":
/*!**************************************!*\
  !*** external "@sage/xtrem-decimal" ***!
  \**************************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-decimal");

/***/ }),

/***/ "@sage/xtrem-ui":
/*!*********************************!*\
  !*** external "@sage/xtrem-ui" ***!
  \*********************************/
/***/ ((module) => {

"use strict";
module.exports = require("@sage/xtrem-ui");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./lib/stickers/mobile-stock-site.ts");
/******/ 	var __webpack_export_target__ = (xtremArtifact = typeof xtremArtifact === "undefined" ? {} : xtremArtifact);
/******/ 	for(var i in __webpack_exports__) __webpack_export_target__[i] = __webpack_exports__[i];
/******/ 	if(__webpack_exports__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;