import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, decimal, date, integer, Collection } from '@sage/xtrem-core';
import * as sageX3StockData from '..';
export declare class Stock extends Node {
    readonly stockSite: Reference<sageX3System.nodes.Site>;
    readonly stockId: Promise<decimal | null>;
    readonly owner: Promise<string>;
    readonly product: Reference<sageX3MasterData.nodes.ProductSite>;
    readonly lot: Promise<string>;
    readonly sublot: Promise<string>;
    readonly supplierLot: Promise<string>;
    readonly identifier1: Promise<string>;
    readonly identifier2: Promise<string>;
    readonly status: Reference<sageX3StockData.nodes.StockStatus>;
    readonly location: Reference<sageX3StockData.nodes.Location | null>;
    readonly locationType: Promise<string>;
    readonly locationCategory: Promise<sageX3StockData.enums.LocationCategory | null>;
    readonly warehouse: Reference<sageX3StockData.nodes.Warehouse | null>;
    readonly serialNumber: Promise<string>;
    readonly receiptDate: Promise<date | null>;
    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly packingUnitToStockUnitConversionFactor: Promise<decimal | null>;
    readonly quantityInPackingUnit: Promise<decimal | null>;
    readonly quantityInStockUnit: Promise<decimal | null>;
    readonly activeQuantityInStockUnit: Promise<decimal | null>;
    readonly originalPackingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly originalQuantityInPackingUnit: Promise<decimal | null>;
    readonly originalQuantityInStockUnit: Promise<decimal | null>;
    readonly qualityAnalysisRequestId: Promise<string>;
    readonly allocatedQuantity: Promise<decimal | null>;
    readonly allocatedActiveQuantity: Promise<decimal | null>;
    readonly inProcessQuantity: Promise<decimal | null>;
    readonly inProcessActiveQuantity: Promise<decimal | null>;
    readonly editedFlag: Promise<integer | null>;
    readonly lastReceiptDate: Promise<date | null>;
    readonly lastIssueDate: Promise<date | null>;
    readonly lastCountDate: Promise<date | null>;
    readonly isBeingCounted: Promise<boolean>;
    readonly countWorksheet: Promise<string>;
    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly stockCustomField1: Promise<string>;
    readonly stockCustomField2: Promise<string>;
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly licensePlateNumber: Reference<sageX3StockData.nodes.LicensePlateNumber | null>;
    readonly productCollection: Collection<sageX3MasterData.nodes.Product>;
    readonly lotReference: Reference<sageX3StockData.nodes.Lot | null>;
    readonly availableQuantity: Promise<decimal | null>;
}
//# sourceMappingURL=stock.d.ts.map