"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockManagementRules = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3StockData = require("..");
const joins = {
    referenceJoins: {
        productCategory: {
            stockSite: 'stockSite',
            code: 'productCategory',
        },
        stockSite: {
            code: 'stockSite',
        },
        stockMovementCode: {
            glossaryId() {
                return 14;
            },
            code: 'stockMovementCode',
        },
    },
};
let StockManagementRules = class StockManagementRules extends xtrem_core_1.Node {
};
exports.StockManagementRules = StockManagementRules;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TCLCOD',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ProductCategory,
    })
], StockManagementRules.prototype, "productCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], StockManagementRules.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TRSTYP',
        dataType: () => sageX3StockData.enums.stockTransactionTypeDatatype,
    })
], StockManagementRules.prototype, "transactionType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRSCOD',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 14,
            },
            control: {
                glossaryId: 14,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], StockManagementRules.prototype, "stockMovementCode", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOCNUM',
        dataType: () => sageX3StockData.enums.titleOfLocationForStockManagementRulesDatatype,
    })
], StockManagementRules.prototype, "locationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOCNUM2',
        dataType: () => sageX3StockData.enums.titleOfLocationForStockManagementRulesDatatype,
    })
], StockManagementRules.prototype, "locationNumber2", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOCNUM3',
        dataType: () => sageX3StockData.enums.titleOfLocationForStockManagementRulesDatatype,
    })
], StockManagementRules.prototype, "locationNumber3", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AUZSTA',
        dataType: () => sageX3StockData.enums.qualityFilter1Datatype,
    })
], StockManagementRules.prototype, "authorizedStatus", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AUZSST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockManagementRules.prototype, "authorizedSubstatus", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEFSTA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockManagementRules.prototype, "defaultStatus", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FORSTA',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], StockManagementRules.prototype, "formula", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'QLYCTLFLG',
    })
], StockManagementRules.prototype, "hasAnalysisRequest", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DACLOT',
        dataType: () => sageX3StockData.enums.packingSequenceDatatype,
    })
], StockManagementRules.prototype, "lotEntry", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOTSUPINH',
        dataType: () => sageX3StockData.enums.defaultLotDatatype,
    })
], StockManagementRules.prototype, "lotByDefault", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SHLLOT',
        dataType: () => sageX3MasterData.enums.lotIssueExpirationUbdDatatype,
    })
], StockManagementRules.prototype, "outputLot", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AUZPRO',
        dataType: () => sageX3StockData.enums.prototypeOrActiveVersionDatatype,
    })
], StockManagementRules.prototype, "prototypeVersion", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AUZACT',
        dataType: () => sageX3StockData.enums.prototypeOrActiveVersionDatatype,
    })
], StockManagementRules.prototype, "activeVersion", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'AUZSTP',
        dataType: () => sageX3StockData.enums.versionStoppedDatatype,
    })
], StockManagementRules.prototype, "versionStopped", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ORDVER',
    })
], StockManagementRules.prototype, "isExclusiveEntryVersion", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DACCTR',
        dataType: () => sageX3StockData.enums.licensePlateNumberEntryDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.LpnActivityCode],
    })
], StockManagementRules.prototype, "licensePlateNumberEntry", void 0);
exports.StockManagementRules = StockManagementRules = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'TABSTORUL',
        keyPropertyNames: ['productCategory', 'stockSite', 'transactionType', 'stockMovementCode'],
        indexes: [
            {
                orderBy: {
                    productCategory: 1,
                    stockSite: 1,
                    transactionType: 1,
                    stockMovementCode: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['productCategory', 'stockSite', 'stockMovementCode'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StockManagementRules);
//# sourceMappingURL=stock-management-rules.js.map