"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProductCategoryDefaultLocations = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3StockData = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'NDL'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            stockSite: 'stockSite',
            code: 'code',
        },
    },
};
let ProductCategoryDefaultLocations = class ProductCategoryDefaultLocations extends xtrem_core_1.Node {
};
exports.ProductCategoryDefaultLocations = ProductCategoryDefaultLocations;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], ProductCategoryDefaultLocations.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'STOFCY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductCategoryDefaultLocations.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'TCLCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductCategoryDefaultLocations.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3MasterData.nodes.ProductCategory,
    })
], ProductCategoryDefaultLocations.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOCDES',
        dataType: () => sageX3StockData.enums.titleOfLocationDatatype,
    })
], ProductCategoryDefaultLocations.prototype, "locationNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEFLOCTYP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductCategoryDefaultLocations.prototype, "defaultLocationType", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEFLOC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], ProductCategoryDefaultLocations.prototype, "defaultLocation", void 0);
exports.ProductCategoryDefaultLocations = ProductCategoryDefaultLocations = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ITMCATEG',
        keyPropertyNames: ['denormalizedIndex', 'stockSite', 'code'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], ProductCategoryDefaultLocations);
//# sourceMappingURL=product-category-default-locations.js.map