"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OverheadFormulaCodes = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3StockData = require("..");
const denormalized = {
    maxRepeat: (context) => sageXtremX3SystemUtils.getSizingFromActivityCode(context, 'ONA'),
};
const joins = {
    referenceJoins: {
        _denormalizedParent: {
            overhead: 'overhead',
        },
    },
};
let OverheadFormulaCodes = class OverheadFormulaCodes extends xtrem_core_1.Node {
};
exports.OverheadFormulaCodes = OverheadFormulaCodes;
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
    })
], OverheadFormulaCodes.prototype, "denormalizedIndex", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'OVECOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], OverheadFormulaCodes.prototype, "overhead", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isVitalParent: true,
        columnType: 'string',
        node: () => sageX3StockData.nodes.Overhead,
    })
], OverheadFormulaCodes.prototype, "_denormalizedParent", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VCRTRG',
        dataType: () => sageX3MasterData.enums.triggerDatatype,
    })
], OverheadFormulaCodes.prototype, "trigger", void 0);
exports.OverheadFormulaCodes = OverheadFormulaCodes = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'OVERHEAD',
        keyPropertyNames: ['denormalizedIndex', 'overhead'],
        indexes: [],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            isDenormalized: true,
            denormalized,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
        isVitalCollectionChild: true,
    })
], OverheadFormulaCodes);
//# sourceMappingURL=overhead-formula-codes.js.map