"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MobileSettings = void 0;
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3StockData = require("..");
const joins = {
    referenceJoins: {
        stockSite: {
            code: 'stockSite',
        },
    },
};
let MobileSettings = class MobileSettings extends xtrem_core_1.Node {
};
exports.MobileSettings = MobileSettings;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STOFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], MobileSettings.prototype, "stockSite", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FLWTYP',
        dataType: () => sageX3StockData.enums.adcFlowTypeDatatype,
    })
], MobileSettings.prototype, "flowType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FILSTO1',
        dataType: () => sageX3StockData.enums.stockSearchFilterDatatype,
    })
], MobileSettings.prototype, "stockField1", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FILSTO2',
        dataType: () => sageX3StockData.enums.stockSearchFilterDatatype,
    })
], MobileSettings.prototype, "stockField2", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FILSTO3',
        dataType: () => sageX3StockData.enums.stockSearchFilterDatatype,
    })
], MobileSettings.prototype, "stockField3", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FILSTO4',
        dataType: () => sageX3StockData.enums.stockSearchFilterDatatype,
    })
], MobileSettings.prototype, "stockField4", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FILSTO5',
        dataType: () => sageX3StockData.enums.stockSearchFilterDatatype,
    })
], MobileSettings.prototype, "stockField5", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FILSTO6',
        dataType: () => sageX3StockData.enums.stockSearchFilterDatatype,
    })
], MobileSettings.prototype, "stockField6", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FILSTO7',
        dataType: () => sageX3StockData.enums.stockSearchFilterDatatype,
    })
], MobileSettings.prototype, "stockField7", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FILSTO8',
        dataType: () => sageX3StockData.enums.stockSearchFilterDatatype,
    })
], MobileSettings.prototype, "stockField8", void 0);
exports.MobileSettings = MobileSettings = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STOADCSEARCH',
        keyPropertyNames: ['stockSite', 'flowType'],
        indexes: [
            {
                orderBy: {
                    stockSite: 1,
                    flowType: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['stockSite'],
        }),
        serviceOptions: () => [sageX3System.serviceOptions.AdcActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], MobileSettings);
//# sourceMappingURL=mobile-settings.js.map