"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MajorVersionStatus = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        product: {
            code: 'product',
        },
    },
    collectionJoins: {
        minorVersions: {
            product: 'product',
            majorVersion: 'code',
        },
    },
};
let MajorVersionStatus = class MajorVersionStatus extends xtrem_core_1.Node {
};
exports.MajorVersionStatus = MajorVersionStatus;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITMREF',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Product,
    })
], MajorVersionStatus.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ECCVALMAJ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], MajorVersionStatus.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], MajorVersionStatus.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ECCSHOAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], MajorVersionStatus.prototype, "shortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ECCSTA',
        dataType: () => sageX3MasterData.enums.versionStatusDatatype,
    })
], MajorVersionStatus.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STRDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], MajorVersionStatus.prototype, "startDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], MajorVersionStatus.prototype, "endDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EXNFLG',
    })
], MajorVersionStatus.prototype, "isSubjectToException", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXNDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], MajorVersionStatus.prototype, "exceptionDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPSFLG',
    })
], MajorVersionStatus.prototype, "isOnHold", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3MasterData.nodes.ProductVersion,
        isMutable: true,
        dependsOn: ['product', 'code'],
    })
], MajorVersionStatus.prototype, "minorVersions", void 0);
exports.MajorVersionStatus = MajorVersionStatus = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ECCSTA',
        keyPropertyNames: ['product', 'code'],
        indexes: [
            {
                orderBy: {
                    product: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], MajorVersionStatus);
//# sourceMappingURL=major-version-status.js.map