import * as sageX3MasterData from '@sage/x3-master-data';
import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
import * as sageX3StockData from '..';
export declare class Lot extends Node {
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly code: Promise<string>;
    readonly sublot: Promise<string>;
    readonly documentType: Promise<sageX3StockData.enums.EntryTypeEnum | null>;
    readonly documentId: Promise<string>;
    readonly documentLine: Promise<integer | null>;
    readonly supplierLot: Promise<string>;
    readonly lotCustomField1: Promise<string>;
    readonly lotCustomField2: Promise<string>;
    readonly lotCustomField3: Promise<decimal | null>;
    readonly lotCustomField4: Promise<date | null>;
    readonly lotCreationDate: Promise<date | null>;
    readonly expirationReferenceDate: Promise<date | null>;
    readonly shelfLife: Promise<integer | null>;
    readonly expirationDate: Promise<date | null>;
    readonly potency: Promise<decimal | null>;
    readonly internationalUnitPotency: Promise<decimal | null>;
    readonly supplier: Reference<sageX3MasterData.nodes.Supplier | null>;
    readonly expirationTimeUnit: Promise<sageX3StockData.enums.ExpirationLeadTimeUnits | null>;
    readonly recontrolTimeUnit: Promise<sageX3StockData.enums.ExpirationLeadTimeUnits | null>;
    readonly checkLeadTime: Promise<integer | null>;
    readonly recontrolDate: Promise<date | null>;
    readonly useByDateCoefficient: Promise<decimal | null>;
    readonly useByDate: Promise<date | null>;
    readonly controlDate: Promise<date | null>;
    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorVersion: Promise<string>;
    readonly stock: Collection<sageX3StockData.nodes.Stock>;
}
//# sourceMappingURL=lot.d.ts.map