"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCountSerialNumber = void 0;
const xtrem_shared_1 = require("@sage/xtrem-shared");
/**
 * async getCountSerialNumber for count number of serial numbers in range
 * @param _pageInstance this page
 * @param _productCode product code
 * @param _stockSiteCode  stock site code
 * @param _stockId optional stock id
 * @param _startingSerialNumberCode starting serial number
 * @param _endingSerialNumberCode  ending serial number
 * @param value to control
 * @returns counted serial number in range or throw exception
 */
async function getCountSerialNumber(_pageInstance, _productCode, _stockSiteCode, _stockId, _startingSerialNumberCode, _endingSerialNumberCode, value) {
    // Create a readable payload, but removing CR/LF before to send request.
    const _payload = `{
        product: { code: '${_productCode}' },
        stockSite: { code: '${_stockSiteCode}' },
        ${_stockId ? `stockId: '${_stockId}',` : ''}
        _and: [
            {
                code: { _gte: '${_startingSerialNumberCode}' },
            },
            {
                code: { _lte: '${_endingSerialNumberCode}' },
            },
        ],
    }`.replace(/[\r\n]/g, '');
    try {
        const response = await _pageInstance.$.graph.raw(`query {
                        x3StockData{
                            serialNumber {
                                query(filter: "${_payload}") {
                                    totalCount
                                }
                            }
                        }
                    }`);
        return response?.x3StockData?.serialNumber?.query?.totalCount ?? 0;
    }
    catch (error) {
        throw new xtrem_shared_1.BusinessRuleError(error?.message, error);
    }
}
exports.getCountSerialNumber = getCountSerialNumber;
//# sourceMappingURL=get-count-serial-number.js.map