import type { Layout } from 'react-grid-layout';
import type { IconType } from 'carbon-react/lib/components/icon/icon-type';
import type { SvgIconProps } from './components/SvgIcon/types';
import type { defaultLiterals } from './default-string-literals';
export interface LayoutDefinition {
    cols: number;
    rowHeight: number;
    width: number;
    isDraggable?: boolean;
    isResizable?: boolean;
    displayAnchors?: boolean;
    editMode?: boolean;
    /** Optional URL where the layout is sent using a PUT method whenever the user saves the changes */
    url?: string;
}
export type WidgetType = 'bar-chart' | 'basic' | 'contact-card' | 'gauge' | 'horizontal-bar' | 'line-chart' | 'line' | 'multiple-indicators' | 'simple-list' | 'pie-chart' | 'preview' | 'progress-tracker' | 'separator' | 'simple-indicator' | 'status-report' | 'table' | 'tile-indicator' | 'treemap' | 'visual-process' | 'custom-widget' | 'quick-links';
export interface DropdownItem {
    i: string;
    label: string;
    icon?: IconType;
    action?: 'closeWidget' | 'editLayout';
    onClick?: () => void;
}
export interface DropdownItemDivider {
    i: string;
    isDivider?: boolean;
}
export interface DropdownDefinition {
    title?: string;
    items?: (DropdownItem | DropdownItemDivider)[];
}
export interface CallToActionDefinition {
    title: string;
    onClick: string | (() => void);
    target?: string;
    isDisabled?: boolean;
    isHidden?: boolean;
}
export interface AbstractWidget<T = any> extends Layout {
    type: WidgetType;
    i: string;
    title?: string;
    description?: string;
    icon?: SvgIconProps;
    data?: T;
    dropdown?: DropdownDefinition;
    callToActions?: Dict<CallToActionDefinition>;
    url?: string;
    showLoader?: boolean;
}
export type Locale = 'en-US' | 'en-GB' | 'fr-FR' | 'es-ES' | 'pt-PT' | 'pt-BR' | 'ar-SA' | 'de-DE' | 'it-IT' | 'pl-PL' | 'zh-CN';
export type DashboardValueOrCallback<T> = T | ((i: string | number) => T);
export interface Dict<T> {
    [key: string]: T;
}
export type TranslationKey = keyof DefaultLiterals | (string & {});
type DefaultLiterals = typeof defaultLiterals;
export type StringLiterals = {
    [K in keyof DefaultLiterals]: string;
} & Dict<string | object>;
export declare const NEW_WIDGET_ID = "__NEW_WIDGET";
export declare const PENDING_WIDGET_ID = "__PENDING_ITEM";
export type Currency = 'AED' | 'AFN' | 'ALL' | 'AMD' | 'ANG' | 'AOA' | 'ARS' | 'AUD' | 'AWG' | 'AZN' | 'BAM' | 'BBD' | 'BDT' | 'BGN' | 'BHD' | 'BIF' | 'BMD' | 'BND' | 'BOB' | 'BOV' | 'BRL' | 'BSD' | 'BTN' | 'BWP' | 'BYN' | 'BZD' | 'CAD' | 'CDF' | 'CHE' | 'CHF' | 'CHW' | 'CLF' | 'CLP' | 'CNY' | 'COP' | 'COU' | 'CRC' | 'CUC' | 'CUP' | 'CVE' | 'CZK' | 'DJF' | 'DKK' | 'DOP' | 'DZD' | 'EGP' | 'ERN' | 'ETB' | 'EUR' | 'FJD' | 'FKP' | 'GBP' | 'GEL' | 'GHS' | 'GIP' | 'GMD' | 'GNF' | 'GTQ' | 'GYD' | 'HKD' | 'HNL' | 'HRK' | 'HTG' | 'HUF' | 'IDR' | 'ILS' | 'INR' | 'IQD' | 'IRR' | 'ISK' | 'JMD' | 'JOD' | 'JPY' | 'KES' | 'KGS' | 'KHR' | 'KMF' | 'KPW' | 'KRW' | 'KWD' | 'KYD' | 'KZT' | 'LAK' | 'LBP' | 'LKR' | 'LRD' | 'LSL' | 'LYD' | 'MAD' | 'MDL' | 'MGA' | 'MKD' | 'MMK' | 'MNT' | 'MOP' | 'MRU' | 'MUR' | 'MVR' | 'MWK' | 'MXN' | 'MXV' | 'MYR' | 'MZN' | 'NAD' | 'NGN' | 'NIO' | 'NOK' | 'NPR' | 'NZD' | 'OMR' | 'PAB' | 'PEN' | 'PGK' | 'PHP' | 'PKR' | 'PLN' | 'PYG' | 'QAR' | 'RON' | 'RSD' | 'RUB' | 'RWF' | 'SAR' | 'SBD' | 'SCR' | 'SDG' | 'SEK' | 'SGD' | 'SHP' | 'SLE' | 'SLL' | 'SOS' | 'SRD' | 'SSP' | 'STN' | 'SVC' | 'SYP' | 'SZL' | 'THB' | 'TJS' | 'TMT' | 'TND' | 'TOP' | 'TRY' | 'TTD' | 'TWD' | 'TZS' | 'UAH' | 'UGX' | 'USD' | 'USN' | 'UYI' | 'UYU' | 'UYW' | 'UZS' | 'VED' | 'VES' | 'VND' | 'VUV' | 'WST' | 'XAF' | 'XAG' | 'XAU' | 'XBA' | 'XBB' | 'XBC' | 'XBD' | 'XCD' | 'XDR' | 'XOF' | 'XPD' | 'XPF' | 'XPT' | 'XSU' | 'XTS' | 'XUA' | 'XXX' | 'YER' | 'ZAR' | 'ZMW' | 'ZWL';
export {};
