interface ChartProps extends BaseChartProps {
    options: {
        type: 'bar';
        areAxesStacked?: boolean;
        areAxesSwapped?: boolean;
        isHistogram?: boolean;
    } | {
        type: 'line';
    };
}
interface EventArgs<T = any, P = any, S = any> {
    primaryValue: P;
    secondaryValue: S;
    record: T;
}
interface BaseChartProps<T = any, P = any, S = any> {
    data: T[];
    primaryAxis: AxisDefinition;
    primaryAxisLabel?: string;
    secondaryAxes: SecondaryAxisDefinition<T, P, S>[];
    secondaryAxisLabel?: string;
}
interface AxisDefinition {
    bind: string;
    title?: string;
}
interface SecondaryAxisDefinition<T = any, P = any, S = any> extends AxisDefinition {
    onClick?: (args: EventArgs<T, P, S>) => void;
    color?: React.CSSProperties['color'];
    tooltipContent?: (args: EventArgs<T, P, S>) => string;
}
export { ChartProps, BaseChartProps, AxisDefinition, SecondaryAxisDefinition };
