import { IHttpService } from './shared/ihttp.service';
import DragDropCanvas, { DragDropCanvasProps } from './components/DragDropCanvas/DragDropCanvas';
import DragDropCanvasWrapper, { DragDropCanvasWrapperProps } from './components/DragDropCanvas/DragDropCanvasWrapper';
import HorizontalBar from './components/HorizontalBar/HorizontalBar';
import ProgressTracker from './components/ProgressTracker/ProgressTracker';
import SimpleIndicator from './components/SimpleIndicator/SimpleIndicator';
import StatusReport from './components/StatusReport/StatusReport';
import type { BarChartComponentProps } from './components/BarChart/BarChart';
import type { GaugeProps as GaugeComponentProps } from './components/Gauge/types';
import type { ContactCardProps as ContactCardComponentProps } from './components/ContactCard/types';
import type { LineChartComponentProps } from './components/LineChart/LineChart';
import type { PieChartProps as PieChartComponentProps } from './components/PieChart/types';
import type { SimpleIndicatorProps as SimpleIndicatorComponentProps } from './components/SimpleIndicator/SimpleIndicator';
import type { TableWidgetProps as TableWidgetComponentProps } from './components/Table/types';
import type { VisualProcessWidgetProps as VisualProcessProps } from './components/VisualProcess/VisualProcess';
import WidgetSkeleton from './components/WidgetSkeleton/WidgetSkeleton';
type WithoutInternalProps<T> = Omit<T, 'stringLiterals' | 'locale'>;
type BarChartProps = WithoutInternalProps<BarChartComponentProps>;
type GaugeProps = WithoutInternalProps<GaugeComponentProps>;
type LineChartProps = WithoutInternalProps<LineChartComponentProps>;
type PieChartProps = WithoutInternalProps<PieChartComponentProps>;
type SimpleIndicatorProps = WithoutInternalProps<SimpleIndicatorComponentProps>;
type TableWidgetProps = WithoutInternalProps<TableWidgetComponentProps>;
type ContactCardProps = WithoutInternalProps<ContactCardComponentProps>;
export { default as BarChart } from './components/BarChart/BarChart';
export type { BarChartProps };
export type { ContactCardProps };
export type { GaugeProps };
export type { LineChartProps };
export type { PieChartProps };
export type { SimpleIndicatorProps };
export type { TableWidgetProps };
export type { TileIndicatorProps } from './components/TileIndicator/TileIndicator';
export type { VisualProcessProps };
export { PeriodDetails, CollectionDateFilter, DateFilterPeriodType, } from './components/shared/DateFilter/types';
export { ValueFormatType, RenderAsType, WidgetCollectionItemDefinition, WidgetColumnDefinitionOptions, WidgetCollectionItem, WidgetCollectionItemDisplayOptions, } from './components/shared/Collection/types';
export * from './types';
export { IHttpService };
export { WidgetSkeleton };
export { DragDropCanvasWrapper, DragDropCanvasWrapperProps };
export { SimpleIndicator };
export { StatusReport };
export { DragDropCanvas, DragDropCanvasProps };
export { ProgressTracker };
export { HorizontalBar };
export { dashboardHttpService } from './shared/http';
export { default as LineChart } from './components/LineChart/LineChart';
export { default as LineGraph } from './components/LineGraph/LineGraph';
export { default as Table } from './components/Table/Table';
export { default as TableTreeMap } from './components/TableTreeMap/TableTreeMap';
export { default as TileIndicator } from './components/TileIndicator/TileIndicator';
export { StatiContentProps } from './components/RenderComponentType/RenderComponentType';
export { default as VisualProcess } from './components/VisualProcess/VisualProcess';
export { default as Gauge } from './components/Gauge/Gauge';
export { default as PieChart } from './components/PieChart/PieChart';
export { default as MultipleIndicators } from './components/MultipleIndicators/MultipleIndicators';
export { default as SimpleList } from './components/SimpleList/SimpleList';
export { default as ContactCard } from './components/ContactCard/ContactCard';
export default DragDropCanvasWrapper;
