import React from 'react';
import type { Locale, Currency } from '../../types';
import type { SvgIconProps } from '../SvgIcon/types';
import Pill from 'carbon-react/lib/components/pill';
export type Indicator = {
    amount?: number;
    title: string;
    value?: number;
};
export type MultipleIndicatorsProps = {
    currencyCode?: Currency;
    customTotal?: number;
    customTotalAmount?: number;
    description?: string;
    icon?: SvgIconProps;
    image?: string;
    indicators: Indicator[];
    isTotalAmountDisplayed?: boolean;
    isTotalDisplayed?: boolean;
    locale?: Locale;
    pillColor: React.ComponentProps<typeof Pill>['borderColor'];
    pillTextContent?: string;
    title?: string;
};
export type IndicatorProps = {
    currencyCode?: Currency;
    indicator: Indicator;
    locale?: Locale;
};
export declare const computeTotal: (indicators: Indicator[]) => number;
export declare const getTotalAmount: (indicators: Indicator[]) => number;
declare const MultipleIndicators: React.FC<MultipleIndicatorsProps>;
export default MultipleIndicators;
