// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/index.d.ts
declare module '@sage/x3-project-management/index' {
	export * from '@sage/x3-project-management/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/index.d.ts
declare module '@sage/x3-project-management/lib/index' {
	export * as enums from '@sage/x3-project-management/lib/enums/index';
	export * as functions from '@sage/x3-project-management/lib/functions/index';
	export * as menuItems from '@sage/x3-project-management/lib/menu-items/index';
	export * as nodeExtensions from '@sage/x3-project-management/lib/node-extensions/index';
	export * as nodes from '@sage/x3-project-management/lib/nodes/index';
	export * as serviceOptions from '@sage/x3-project-management/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/service-options/index.d.ts
declare module '@sage/x3-project-management/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/time-entry-line.d.ts
declare module '@sage/x3-project-management/lib/nodes/time-entry-line' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, TextStream, Collection, Context, DateValue } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class TimeEntryLine extends Node {
	    readonly employee: Reference<sageX3ProjectManagement.nodes.ProjectUser>;
	    readonly lineNumber: Promise<integer>;
	    readonly date: Promise<date>;
	    readonly taskLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly budgetLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly project: Reference<sageX3ProjectManagement.nodes.Project | null>;
	    readonly task: Reference<sageX3ProjectManagement.nodes.Task | null>;
	    readonly operation: Reference<sageX3ProjectManagement.nodes.Operation | null>;
	    readonly firstOperationSplit: Promise<integer | null>;
	    readonly assignmentLine: Reference<sageX3ProjectManagement.nodes.OperationAssignment | null>;
	    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget | null>;
	    readonly financialSite: Reference<sageX3System.nodes.Site | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType>;
	    readonly projectCostType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
	    readonly employeeCostType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
	    readonly projectLaborRate: Promise<decimal | null>;
	    readonly employeeLaborRate: Promise<decimal | null>;
	    readonly timeSpent: Promise<decimal>;
	    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
	    readonly rateMultiplier: Promise<decimal>;
	    readonly localizedDescription: Promise<string>;
	    readonly isValidated: Promise<boolean>;
	    readonly status: Promise<sageX3ProjectManagementData.enums.TimeEntryStatus>;
	    readonly origin: Promise<sageX3ProjectManagementData.enums.TimeEntryOrigin>;
	    readonly validatedBy: Reference<sageX3System.nodes.User | null>;
	    readonly controlledBy: Reference<sageX3System.nodes.User | null>;
	    readonly approvedBy: Reference<sageX3System.nodes.User | null>;
	    readonly entryType: Reference<sageX3FinanceData.nodes.EntryType | null>;
	    readonly rejectedBy: Reference<sageX3System.nodes.User | null>;
	    readonly journal: Reference<sageX3FinanceData.nodes.Journal | null>;
	    readonly postedBy: Reference<sageX3System.nodes.User | null>;
	    readonly journalNumber: Promise<string>;
	    readonly isBillable: Promise<boolean>;
	    readonly billableFrom: Promise<date | null>;
	    readonly billedQuantity: Promise<decimal | null>;
	    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longComment: Promise<TextStream>;
	    readonly longDescription: Promise<TextStream>;
	    readonly connectedEmployee: Reference<sageX3ProjectManagement.nodes.ProjectUser | null>;
	    readonly defaultTimeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
	    readonly defaultUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly isNegativeTimeSpentAllowed: Promise<boolean | null>;
	    readonly isTimeEntryAdministrator: Promise<boolean | null>;
	    readonly isTimeEntryEmployee: Promise<boolean | null>;
	    readonly isValidatedDefault: Promise<boolean | null>;
	    readonly currencyRates: Collection<sageX3ProjectManagement.nodes.TimeEntryLineCurrencyRates>;
	    readonly dimensions: Collection<sageX3ProjectManagement.nodes.TimeEntryLineDimensions>;
	    static computeProjectEmployeeCostType(context: Context, parameters: {
	        project: string;
	        task: string;
	        operation: number;
	        employee: string;
	        timeCategory: string;
	    }): Promise<{
	        employeeCostType: string;
	        projectCostType: string;
	    }>;
	    static computeProjectEmployeeLaborRate(context: Context, parameters: {
	        employee: string;
	        date: DateValue;
	        unit: string;
	        currency: string;
	        rateType: sageX3System.enums.ExchangeRateType;
	        projectCostType: string;
	        employeeCostType: string;
	    }): Promise<{
	        projectLaborRate: decimal;
	        employeeLaborRate: decimal;
	        message: string;
	    }>;
	    static computeUnitOfMeasure(context: Context, parameters: {
	        project: string;
	        task: string;
	        operation: number;
	        employee: string;
	        timeCategory: string;
	        costType: string;
	    }): Promise<{
	        unit: string;
	    }>;
	}
	//# sourceMappingURL=time-entry-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/time-entry-line-dimensions.d.ts
declare module '@sage/x3-project-management/lib/nodes/time-entry-line-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class TimeEntryLineDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly employee: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3ProjectManagement.nodes.TimeEntryLine>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=time-entry-line-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/time-entry-line-currency-rates.d.ts
declare module '@sage/x3-project-management/lib/nodes/time-entry-line-currency-rates' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class TimeEntryLineCurrencyRates extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly employee: Promise<string>;
	    readonly lineNumber: Promise<integer>;
	    readonly _denormalizedParent: Reference<sageX3ProjectManagement.nodes.TimeEntryLine>;
	    readonly chartOfAccounts: Reference<sageX3FinanceData.nodes.ChartOfAccounts | null>;
	    readonly account: Reference<sageX3FinanceData.nodes.Account | null>;
	    readonly multiplyingRate: Promise<decimal | null>;
	    readonly dividingRate: Promise<decimal | null>;
	    readonly ledgerType: Promise<sageX3MasterData.enums.GeneralLedgerTypes | null>;
	    readonly ledgerCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
	}
	//# sourceMappingURL=time-entry-line-currency-rates.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/time-category.d.ts
declare module '@sage/x3-project-management/lib/nodes/time-category' {
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, decimal, Reference } from '@sage/xtrem-core';
	export class TimeCategory extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly multiplyingRate: Promise<decimal | null>;
	    readonly isNonProjectCategory: Promise<boolean>;
	    readonly costType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType>;
	    readonly isBillable: Promise<boolean>;
	}
	//# sourceMappingURL=time-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/task.d.ts
declare module '@sage/x3-project-management/lib/nodes/task' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class Task extends Node {
	    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
	    readonly code: Promise<string>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly parent: Reference<sageX3ProjectManagement.nodes.Task | null>;
	    readonly sortKey: Promise<integer | null>;
	    readonly taskType: Promise<sageX3ProjectManagementData.enums.OpeProvTask | null>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly duration: Promise<integer | null>;
	    readonly launchingDate: Promise<date | null>;
	    readonly planningDate: Promise<date | null>;
	    readonly beginningDate: Promise<date | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly suspensionDate: Promise<date | null>;
	    readonly isToLaunch: Promise<boolean>;
	    readonly status: Promise<sageX3ProjectManagementData.enums.ProjectTaskStatus | null>;
	    readonly category: Reference<sageX3ProjectManagement.nodes.TaskCategory>;
	    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget | null>;
	    readonly keyConcatenation: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly responsiblePerson: Reference<sageX3ProjectManagement.nodes.ProjectUser | null>;
	    readonly sequenceNumber: Promise<string>;
	    readonly estimatedProgress: Promise<decimal | null>;
	    readonly progressRange: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly progressDate: Promise<date | null>;
	    readonly progressMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
	    readonly billingMode: Promise<sageX3ProjectManagementData.enums.BillingMode>;
	    readonly dueDate: Promise<date | null>;
	    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
	    readonly source: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly operations: Collection<sageX3ProjectManagement.nodes.Operation>;
	    readonly products: Collection<sageX3ProjectManagement.nodes.TaskProduct>;
	    readonly precedenceLinks: Collection<sageX3ProjectManagement.nodes.TaskPrecedenceLink>;
	    readonly projectLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
	    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly pjmProject: Reference<sageX3ProjectManagement.nodes.PjmProject>;
	    readonly isActive: Promise<boolean>;
	    readonly isBudgetCreatedAutomatically: Promise<boolean>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly longComment: Promise<TextStream>;
	    readonly longDescription: Promise<TextStream>;
	    readonly type: Promise<sageX3MasterData.enums.ProjectAllocationType>;
	}
	//# sourceMappingURL=task.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/task-product.d.ts
declare module '@sage/x3-project-management/lib/nodes/task-product' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, date, TextStream } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class TaskProduct extends Node {
	    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
	    readonly task: Reference<sageX3ProjectManagement.nodes.Task>;
	    readonly lineNumber: Promise<integer>;
	    readonly keyConcatenation: Promise<string>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly shippingSite: Reference<sageX3System.nodes.Site>;
	    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly requiredQuantity: Promise<decimal>;
	    readonly requirementDate: Promise<date | null>;
	    readonly product: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorVersion: Reference<sageX3MasterData.nodes.ProductVersion | null>;
	    readonly bomCode: Reference<sageX3MasterData.nodes.BomCodes | null>;
	    readonly planNumber: Promise<string>;
	    readonly planVersion: Promise<string>;
	    readonly isSold: Promise<boolean>;
	    readonly consumptionMode: Promise<sageX3ProjectManagementData.enums.ConsumptionMode>;
	    readonly allocatedQuantity: Promise<decimal | null>;
	    readonly shortageQuantity: Promise<decimal | null>;
	    readonly manualAllocation: Promise<decimal | null>;
	    readonly allocationStatus: Promise<sageX3MasterData.enums.AllocationStatus>;
	    readonly allocationType: Promise<sageX3MasterData.enums.AllocationType>;
	    readonly inProcessQuantity: Promise<decimal | null>;
	    readonly deliveredQuantity: Promise<decimal | null>;
	    readonly deliveryStatus: Promise<sageX3ProjectManagementData.enums.DeliveryStatus>;
	    readonly orderedQuantity: Promise<decimal | null>;
	    readonly workInProgressOrderNumber: Promise<string>;
	    readonly closeWip: Promise<boolean>;
	    readonly isDeliverable: Promise<boolean>;
	    readonly primaryBudgetingMethod: Promise<sageX3ProjectManagementData.enums.BudgetMethod>;
	    readonly secondaryBudgetingMethod: Promise<sageX3ProjectManagementData.enums.BudgetMethod>;
	    readonly manualBudgetAmount: Promise<decimal | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly saleableProductLine: Promise<string>;
	    readonly stockManagement: Promise<sageX3MasterData.enums.StockManagement>;
	    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longComment: Promise<TextStream>;
	    readonly longDescription: Promise<TextStream>;
	}
	//# sourceMappingURL=task-product.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/task-precedence-link.d.ts
declare module '@sage/x3-project-management/lib/nodes/task-precedence-link' {
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class TaskPrecedenceLink extends Node {
	    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
	    readonly task: Reference<sageX3ProjectManagement.nodes.Task>;
	    readonly lineNumber: Promise<integer>;
	    readonly linkedTask: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly linkType: Promise<sageX3ProjectManagementData.enums.TasksLinkType>;
	    readonly constraintType: Promise<sageX3ProjectManagementData.enums.ConstraintType>;
	    readonly lagDays: Promise<integer | null>;
	}
	//# sourceMappingURL=task-precedence-link.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/task-category.d.ts
declare module '@sage/x3-project-management/lib/nodes/task-category' {
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, integer, Reference, Collection } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class TaskCategory extends Node {
	    readonly code: Promise<string>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly isActive: Promise<boolean>;
	    readonly type: Promise<sageX3ProjectManagementData.enums.ProjectTaskType | null>;
	    readonly planningMode: Promise<sageX3ProjectManagementData.enums.PlanningMode | null>;
	    readonly duration: Promise<integer | null>;
	    readonly costType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
	    readonly personResponsible: Reference<sageX3System.nodes.User | null>;
	    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
	    readonly lines: Collection<sageX3ProjectManagement.nodes.TaskCategoryOperation>;
	}
	//# sourceMappingURL=task-category.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/task-category-operation.d.ts
declare module '@sage/x3-project-management/lib/nodes/task-category-operation' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class TaskCategoryOperation extends Node {
	    readonly category: Reference<sageX3ProjectManagement.nodes.TaskCategory>;
	    readonly lineNumber: Promise<integer>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly numberOfResource1: Reference<sageX3ManufacturingData.nodes.WorkCenter>;
	    readonly numberOfResource2: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly packingUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly plannedLoad: Promise<decimal | null>;
	    readonly duration: Promise<integer | null>;
	    readonly employee: Reference<sageX3ProjectManagement.nodes.ProjectUser | null>;
	    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
	}
	//# sourceMappingURL=task-category-operation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/saleable-product.d.ts
declare module '@sage/x3-project-management/lib/nodes/saleable-product' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class SaleableProduct extends Node {
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
	    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget | null>;
	    readonly task: Reference<sageX3ProjectManagement.nodes.Task | null>;
	    readonly lineNumber: Promise<integer>;
	    readonly product: Reference<sageX3MasterData.nodes.Product>;
	    readonly description: Promise<string>;
	    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
	    readonly minorVersion: Promise<string>;
	    readonly plannedQuantity: Promise<decimal | null>;
	    readonly plannedUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantity: Promise<decimal>;
	    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly quantityInStockUnit: Promise<decimal>;
	    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly basePrice: Promise<decimal | null>;
	    readonly origin: Promise<sageX3ProjectManagementData.enums.SaleablePrdLineOrigin>;
	    readonly initialGrouping: Promise<sageX3ProjectManagementData.enums.SoldProductsLinePrdGrpLvl>;
	    readonly productGroupingLevel: Promise<sageX3ProjectManagementData.enums.SoldProductsLinePrdGrpLvl>;
	    readonly sourceOperation: Reference<sageX3ProjectManagement.nodes.Operation | null>;
	    readonly sourceProductLine: Reference<sageX3ProjectManagement.nodes.TaskProduct | null>;
	    readonly sourceBudgetLine: Reference<sageX3ProjectManagement.nodes.BudgetLine | null>;
	    readonly lineOrigin: Promise<string>;
	}
	//# sourceMappingURL=saleable-product.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/project.d.ts
declare module '@sage/x3-project-management/lib/nodes/project' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, Collection, decimal, TextStream } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class Project extends Node {
	    readonly id: Promise<string>;
	    readonly category: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly externalIdentifier: Promise<string>;
	    readonly isClosed: Promise<boolean>;
	    readonly salesRepresentative: Reference<sageX3MasterData.nodes.SalesRep | null>;
	    readonly rateType: Promise<sageX3System.enums.ExchangeRateType>;
	    readonly customer: Reference<sageX3MasterData.nodes.Customer | null>;
	    readonly contact: Reference<sageX3MasterData.nodes.ContactRelationship | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly marketingCampaign: Promise<string>;
	    readonly marketingOperation: Promise<string>;
	    readonly marketingOperationType: Promise<string>;
	    readonly origin: Promise<sageX3MasterData.enums.ProjectOrigins | null>;
	    readonly originalDocument: Promise<string>;
	    readonly originalDocumentLine: Promise<integer | null>;
	    readonly creationTime: Promise<string>;
	    readonly originalMethod: Promise<sageX3MasterData.enums.OriginType | null>;
	    readonly openingDate: Promise<date>;
	    readonly employees: Collection<sageX3ProjectManagement.nodes.ProjectAssignment>;
	    readonly projectLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
	    readonly pjmProject: Reference<sageX3ProjectManagement.nodes.PjmProject>;
	    readonly tasks: Collection<sageX3ProjectManagement.nodes.Task>;
	    readonly budgets: Collection<sageX3ProjectManagement.nodes.Budget>;
	    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly accountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
	    readonly billingMode: Promise<sageX3ProjectManagementData.enums.BillingMode>;
	    readonly closingDate: Promise<date | null>;
	    readonly deliveryDate: Promise<date | null>;
	    readonly dimensions: Collection<sageX3ProjectManagement.nodes.PjmProjectDimensions>;
	    readonly dueDate: Promise<date | null>;
	    readonly duration: Promise<integer | null>;
	    readonly endDate: Promise<date | null>;
	    readonly estimatedProgressPercentage: Promise<decimal | null>;
	    readonly estimatedRevenueAtCompletion: Promise<decimal | null>;
	    readonly isActive: Promise<boolean>;
	    readonly isBudgetCreatedAutomatically: Promise<boolean>;
	    readonly isIndirectCostCalculated: Promise<boolean>;
	    readonly isIntermediateLevelBudgetingAllowed: Promise<boolean>;
	    readonly isInternal: Promise<boolean>;
	    readonly isProvisional: Promise<boolean>;
	    readonly isTemplate: Promise<boolean>;
	    readonly launchingDate: Promise<date | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly longComment: Promise<TextStream>;
	    readonly longDescription: Promise<TextStream>;
	    readonly operatingSite: Reference<sageX3System.nodes.Site>;
	    readonly overviewCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly progressEstimationDate: Promise<date | null>;
	    readonly progressEstimationMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
	    readonly progressRange: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly projectStatus: Promise<sageX3ProjectManagementData.enums.ProjectStatus | null>;
	    readonly responsiblePerson: Reference<sageX3ProjectManagement.nodes.ProjectUser | null>;
	    readonly revenueEstimationDate: Promise<date | null>;
	    readonly revenueEstimationMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
	    readonly revenueRecognitionExtractionMethod: Promise<sageX3ProjectManagementData.enums.CalculationMethodUsed>;
	    readonly revenueRecognitionRule: Reference<sageX3FinanceData.nodes.RevenueRecognitionRules | null>;
	    readonly source: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly startDate: Promise<date | null>;
	    readonly suspensionDate: Promise<date | null>;
	    readonly type: Promise<sageX3MasterData.enums.ProjectAllocationType>;
	}
	//# sourceMappingURL=project.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/project-user.d.ts
declare module '@sage/x3-project-management/lib/nodes/project-user' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class ProjectUser extends Node {
	    readonly employee: Reference<sageX3System.nodes.User>;
	    readonly role: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly isTimeEntryEmployee: Promise<boolean>;
	    readonly isTimeEntryAdministrator: Promise<boolean>;
	    readonly hourlyRate: Promise<decimal | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly costType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
	    readonly isActiveEmployeeOnProjects: Promise<boolean>;
	    readonly weeklyStructure: Reference<sageX3MasterData.nodes.WeeklyStructure | null>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
	    readonly lines: Collection<sageX3ProjectManagement.nodes.ProjectUserCapacityVariation>;
	}
	//# sourceMappingURL=project-user.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/project-user-capacity-variation.d.ts
declare module '@sage/x3-project-management/lib/nodes/project-user-capacity-variation' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class ProjectUserCapacityVariation extends Node {
	    readonly employee: Reference<sageX3ProjectManagement.nodes.ProjectUser>;
	    readonly lineNumber: Promise<integer>;
	    readonly startDate: Promise<date>;
	    readonly endDate: Promise<date>;
	    readonly reason: Reference<sageX3System.nodes.MiscellaneousTable>;
	    readonly weeklyStructure: Reference<sageX3MasterData.nodes.WeeklyStructure>;
	}
	//# sourceMappingURL=project-user-capacity-variation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/project-assignment.d.ts
declare module '@sage/x3-project-management/lib/nodes/project-assignment' {
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class ProjectAssignment extends Node {
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
	    readonly employee: Reference<sageX3ProjectManagement.nodes.ProjectUser>;
	    readonly role: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	}
	//# sourceMappingURL=project-assignment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/pjm-project.d.ts
declare module '@sage/x3-project-management/lib/nodes/pjm-project' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, date, integer, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class PjmProject extends Node {
	    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
	    readonly isInternal: Promise<boolean>;
	    readonly isProvisional: Promise<boolean>;
	    readonly projectStatus: Promise<sageX3ProjectManagementData.enums.ProjectStatus | null>;
	    readonly suspensionDate: Promise<date | null>;
	    readonly deliveryDate: Promise<date | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly launchingDate: Promise<date | null>;
	    readonly isIndirectCostCalculated: Promise<boolean>;
	    readonly overviewCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly isIntermediateLevelBudgetingAllowed: Promise<boolean>;
	    readonly operatingSite: Reference<sageX3System.nodes.Site>;
	    readonly isTemplate: Promise<boolean>;
	    readonly isBudgetCreatedAutomatically: Promise<boolean>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly dueDate: Promise<date | null>;
	    readonly duration: Promise<integer | null>;
	    readonly responsiblePerson: Reference<sageX3ProjectManagement.nodes.ProjectUser | null>;
	    readonly revenueRecognitionRule: Reference<sageX3FinanceData.nodes.RevenueRecognitionRules | null>;
	    readonly estimatedRevenueAtCompletion: Promise<decimal | null>;
	    readonly revenueEstimationDate: Promise<date | null>;
	    readonly revenueEstimationMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
	    readonly revenueRecognitionExtractionMethod: Promise<sageX3ProjectManagementData.enums.CalculationMethodUsed>;
	    readonly accountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
	    readonly estimatedProgressPercentage: Promise<decimal | null>;
	    readonly progressRange: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly progressEstimationDate: Promise<date | null>;
	    readonly progressEstimationMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
	    readonly billingMode: Promise<sageX3ProjectManagementData.enums.BillingMode>;
	    readonly source: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly dimensions: Collection<sageX3ProjectManagement.nodes.PjmProjectDimensions>;
	}
	//# sourceMappingURL=pjm-project.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/pjm-project-dimensions.d.ts
declare module '@sage/x3-project-management/lib/nodes/pjm-project-dimensions' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import { Node, integer, Reference } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class PjmProjectDimensions extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly project: Promise<string>;
	    readonly _denormalizedParent: Reference<sageX3ProjectManagement.nodes.PjmProject>;
	    readonly dimensionType: Reference<sageX3FinanceData.nodes.DimensionType | null>;
	    readonly dimension: Reference<sageX3FinanceData.nodes.Dimension | null>;
	}
	//# sourceMappingURL=pjm-project-dimensions.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/operation.d.ts
declare module '@sage/x3-project-management/lib/nodes/operation' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class Operation extends Node {
	    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
	    readonly task: Reference<sageX3ProjectManagement.nodes.Task>;
	    readonly number: Promise<integer>;
	    readonly firstOperationSplit: Promise<integer | null>;
	    readonly site: Reference<sageX3System.nodes.Site>;
	    readonly workCenterLaborResource1: Reference<sageX3ManufacturingData.nodes.WorkCenter>;
	    readonly workCenterLaborResource2: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly status: Promise<sageX3ManufacturingData.enums.OperationStatus>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly duration: Promise<integer | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
	    readonly numberOfResource1: Promise<integer | null>;
	    readonly numberOfResource2: Promise<integer | null>;
	    readonly plannedLoad: Promise<decimal | null>;
	    readonly consumedLoad: Promise<decimal | null>;
	    readonly remainingLoad: Promise<decimal | null>;
	    readonly hourlyRate: Promise<decimal | null>;
	    readonly laborRate: Promise<decimal | null>;
	    readonly actualStartDate: Promise<date | null>;
	    readonly actualEndDate: Promise<date | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly suspensionDate: Promise<date | null>;
	    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
	    readonly saleableProductLine: Promise<string>;
	    readonly assignments: Collection<sageX3ProjectManagement.nodes.OperationAssignment>;
	    readonly precedenceLinks: Collection<sageX3ProjectManagement.nodes.OperationPrecedenceLink>;
	    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longComment: Promise<TextStream>;
	    readonly longDescription: Promise<TextStream>;
	}
	//# sourceMappingURL=operation.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/operation-precedence-link.d.ts
declare module '@sage/x3-project-management/lib/nodes/operation-precedence-link' {
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class OperationPrecedenceLink extends Node {
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
	    readonly task: Reference<sageX3ProjectManagement.nodes.Task>;
	    readonly operation: Reference<sageX3ProjectManagement.nodes.Operation>;
	    readonly firstOperationSplit: Promise<integer>;
	    readonly lineNumber: Promise<integer>;
	    readonly linkedOperation: Reference<sageX3ProjectManagement.nodes.Operation>;
	    readonly linkedOperationSplit: Promise<integer>;
	    readonly linkType: Promise<sageX3ProjectManagementData.enums.OperationsLinkType>;
	    readonly constraintType: Promise<sageX3ProjectManagementData.enums.ConstraintType>;
	    readonly lagDays: Promise<integer | null>;
	}
	//# sourceMappingURL=operation-precedence-link.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/operation-assignment.d.ts
declare module '@sage/x3-project-management/lib/nodes/operation-assignment' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import { Node, Reference, integer, decimal, date, TextStream } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class OperationAssignment extends Node {
	    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
	    readonly task: Reference<sageX3ProjectManagement.nodes.Task>;
	    readonly operation: Reference<sageX3ProjectManagement.nodes.Operation>;
	    readonly firstOperationSplit: Promise<integer | null>;
	    readonly lineNumber: Promise<integer>;
	    readonly employee: Reference<sageX3ProjectManagement.nodes.ProjectUser>;
	    readonly localizedDescription: Promise<string>;
	    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly plannedLoad: Promise<decimal | null>;
	    readonly consumedLoad: Promise<decimal | null>;
	    readonly remainingLoad: Promise<decimal | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly hourlyRate: Promise<decimal | null>;
	    readonly laborRate: Promise<decimal | null>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly startTime: Promise<string>;
	    readonly endTime: Promise<string>;
	    readonly keyConcatenation: Promise<string>;
	    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
	    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longComment: Promise<TextStream>;
	    readonly longDescription: Promise<TextStream>;
	}
	//# sourceMappingURL=operation-assignment.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/index.d.ts
declare module '@sage/x3-project-management/lib/nodes/index' {
	export * from '@sage/x3-project-management/lib/nodes/budget-line';
	export * from '@sage/x3-project-management/lib/nodes/budget';
	export * from '@sage/x3-project-management/lib/nodes/cost-date';
	export * from '@sage/x3-project-management/lib/nodes/cost-group-link';
	export * from '@sage/x3-project-management/lib/nodes/cost-structure-reporting-snapshot';
	export * from '@sage/x3-project-management/lib/nodes/cost-type-reporting-snapshot';
	export * from '@sage/x3-project-management/lib/nodes/financial-overview-structure';
	export * from '@sage/x3-project-management/lib/nodes/operation-assignment';
	export * from '@sage/x3-project-management/lib/nodes/operation-precedence-link';
	export * from '@sage/x3-project-management/lib/nodes/operation';
	export * from '@sage/x3-project-management/lib/nodes/pjm-project-dimensions';
	export * from '@sage/x3-project-management/lib/nodes/pjm-project';
	export * from '@sage/x3-project-management/lib/nodes/project-assignment';
	export * from '@sage/x3-project-management/lib/nodes/project-user-capacity-variation';
	export * from '@sage/x3-project-management/lib/nodes/project-user';
	export * from '@sage/x3-project-management/lib/nodes/project';
	export * from '@sage/x3-project-management/lib/nodes/saleable-product';
	export * from '@sage/x3-project-management/lib/nodes/task-category-operation';
	export * from '@sage/x3-project-management/lib/nodes/task-category';
	export * from '@sage/x3-project-management/lib/nodes/task-precedence-link';
	export * from '@sage/x3-project-management/lib/nodes/task-product';
	export * from '@sage/x3-project-management/lib/nodes/task';
	export * from '@sage/x3-project-management/lib/nodes/time-category';
	export * from '@sage/x3-project-management/lib/nodes/time-entry-line-currency-rates';
	export * from '@sage/x3-project-management/lib/nodes/time-entry-line-dimensions';
	export * from '@sage/x3-project-management/lib/nodes/time-entry-line';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/financial-overview-structure.d.ts
declare module '@sage/x3-project-management/lib/nodes/financial-overview-structure' {
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference } from '@sage/xtrem-core';
	export class FinancialOverviewStructure extends Node {
	    readonly financialView: Reference<sageX3System.nodes.MiscellaneousTable>;
	    readonly columnSequence: Promise<string>;
	    readonly columnContent: Promise<string>;
	    readonly subColumn1Title: Promise<string>;
	    readonly subColumn2Title: Promise<string>;
	    readonly subColumn1Type: Promise<sageX3ProjectManagementData.enums.QuantityAmount | null>;
	    readonly subColumn2Type: Promise<sageX3ProjectManagementData.enums.QuantityAmount | null>;
	    readonly display: Promise<boolean>;
	}
	//# sourceMappingURL=financial-overview-structure.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/cost-type-reporting-snapshot.d.ts
declare module '@sage/x3-project-management/lib/nodes/cost-type-reporting-snapshot' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class CostTypeReportingSnapshot extends Node {
	    readonly id: Promise<string>;
	    readonly financialView: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly lineNumber: Promise<integer>;
	    readonly parent: Reference<sageX3ProjectManagement.nodes.Budget | null>;
	    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget | null>;
	    readonly costTypeGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly costTypeGroupSortKey: Promise<integer | null>;
	    readonly costType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
	    readonly budgetQuantity: Promise<decimal | null>;
	    readonly budgetAmount: Promise<decimal | null>;
	    readonly quantity1: Promise<decimal | null>;
	    readonly amount1: Promise<decimal | null>;
	    readonly quantity2: Promise<decimal | null>;
	    readonly amount2: Promise<decimal | null>;
	    readonly quantity3: Promise<decimal | null>;
	    readonly amount3: Promise<decimal | null>;
	    readonly quantity4: Promise<decimal | null>;
	    readonly amount4: Promise<decimal | null>;
	    readonly quantity5: Promise<decimal | null>;
	    readonly amount5: Promise<decimal | null>;
	    readonly totalQuantity: Promise<decimal | null>;
	    readonly totalAmount: Promise<decimal | null>;
	    readonly remainingQuantity: Promise<decimal | null>;
	    readonly remainingAmount: Promise<decimal | null>;
	    readonly marginQuantity: Promise<decimal | null>;
	    readonly marginAmount: Promise<decimal | null>;
	    readonly percentageQuantity: Promise<decimal | null>;
	    readonly percentageAmount: Promise<decimal | null>;
	    readonly totalEstimationQuantity: Promise<decimal | null>;
	    readonly totalEstimationAmount: Promise<decimal | null>;
	    readonly freeQuantity1: Promise<decimal | null>;
	    readonly freeAmount1: Promise<decimal | null>;
	    readonly freeQuantity2: Promise<decimal | null>;
	    readonly freeAmount2: Promise<decimal | null>;
	    readonly freeQuantity3: Promise<decimal | null>;
	    readonly freeAmount3: Promise<decimal | null>;
	    readonly freeQuantity4: Promise<decimal | null>;
	    readonly freeAmount4: Promise<decimal | null>;
	    readonly freeQuantity5: Promise<decimal | null>;
	    readonly freeAmount5: Promise<decimal | null>;
	    readonly budgetRatio: Promise<decimal | null>;
	    readonly budgetPercentage: Promise<decimal | null>;
	    readonly totalRatio: Promise<decimal | null>;
	    readonly totalPercentage: Promise<decimal | null>;
	    readonly wipQuantity: Promise<decimal | null>;
	    readonly wipAmount: Promise<decimal | null>;
	    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	}
	//# sourceMappingURL=cost-type-reporting-snapshot.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/cost-structure-reporting-snapshot.d.ts
declare module '@sage/x3-project-management/lib/nodes/cost-structure-reporting-snapshot' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class CostStructureReportingSnapshot extends Node {
	    readonly id: Promise<string>;
	    readonly financialView: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly lineNumber: Promise<integer>;
	    readonly parent: Reference<sageX3ProjectManagement.nodes.Budget | null>;
	    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget | null>;
	    readonly budgetSortKey: Promise<integer | null>;
	    readonly costTypeGroup: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly costTypeGroupSortKey: Promise<integer | null>;
	    readonly costType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
	    readonly budgetQuantity: Promise<decimal | null>;
	    readonly budgetAmount: Promise<decimal | null>;
	    readonly quantity1: Promise<decimal | null>;
	    readonly amount1: Promise<decimal | null>;
	    readonly quantity2: Promise<decimal | null>;
	    readonly amount2: Promise<decimal | null>;
	    readonly quantity3: Promise<decimal | null>;
	    readonly amount3: Promise<decimal | null>;
	    readonly quantity4: Promise<decimal | null>;
	    readonly amount4: Promise<decimal | null>;
	    readonly quantity5: Promise<decimal | null>;
	    readonly amount5: Promise<decimal | null>;
	    readonly totalQuantity: Promise<decimal | null>;
	    readonly totalAmount: Promise<decimal | null>;
	    readonly remainingQuantity: Promise<decimal | null>;
	    readonly remainingAmount: Promise<decimal | null>;
	    readonly marginQuantity: Promise<decimal | null>;
	    readonly marginAmount: Promise<decimal | null>;
	    readonly percentageQuantity: Promise<decimal | null>;
	    readonly percentageAmount: Promise<decimal | null>;
	    readonly totalEstimationQuantity: Promise<decimal | null>;
	    readonly totalEstimationAmount: Promise<decimal | null>;
	    readonly freeQuantity1: Promise<decimal | null>;
	    readonly freeAmount1: Promise<decimal | null>;
	    readonly freeQuantity2: Promise<decimal | null>;
	    readonly freeAmount2: Promise<decimal | null>;
	    readonly freeQuantity3: Promise<decimal | null>;
	    readonly freeAmount3: Promise<decimal | null>;
	    readonly freeQuantity4: Promise<decimal | null>;
	    readonly freeAmount4: Promise<decimal | null>;
	    readonly freeQuantity5: Promise<decimal | null>;
	    readonly freeAmount5: Promise<decimal | null>;
	    readonly budgetRatio: Promise<decimal | null>;
	    readonly budgetPercentage: Promise<decimal | null>;
	    readonly totalRatio: Promise<decimal | null>;
	    readonly totalPercentage: Promise<decimal | null>;
	    readonly wipQuantity: Promise<decimal | null>;
	    readonly wipAmount: Promise<decimal | null>;
	    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	}
	//# sourceMappingURL=cost-structure-reporting-snapshot.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/cost-group-link.d.ts
declare module '@sage/x3-project-management/lib/nodes/cost-group-link' {
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3StockData from '@sage/x3-stock-data';
	import { Node, Reference } from '@sage/xtrem-core';
	export class CostGroupLink extends Node {
	    readonly costType: Reference<sageX3ProjectManagementData.nodes.CostType>;
	    readonly costGroupType: Promise<sageX3ProjectManagementData.enums.CostGroupType | null>;
	    readonly material: Promise<sageX3StockData.enums.MaterialCostGroup | null>;
	    readonly labor: Promise<sageX3StockData.enums.DimensionCostGroup | null>;
	    readonly machine: Promise<sageX3StockData.enums.DimensionCostGroup | null>;
	}
	//# sourceMappingURL=cost-group-link.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/cost-date.d.ts
declare module '@sage/x3-project-management/lib/nodes/cost-date' {
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import { Node, Reference, date, decimal } from '@sage/xtrem-core';
	export class CostDate extends Node {
	    readonly costType: Reference<sageX3ProjectManagementData.nodes.CostType>;
	    readonly rateActivationDate: Promise<date>;
	    readonly unitPrice: Promise<decimal | null>;
	}
	//# sourceMappingURL=cost-date.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/budget.d.ts
declare module '@sage/x3-project-management/lib/nodes/budget' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class Budget extends Node {
	    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
	    readonly code: Promise<string>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly sortKey: Promise<integer | null>;
	    readonly suspensionDate: Promise<date | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly deliveryDate: Promise<date | null>;
	    readonly parent: Reference<sageX3ProjectManagement.nodes.Budget | null>;
	    readonly status: Promise<sageX3ProjectManagementData.enums.ProjectBudgetStatus | null>;
	    readonly isElementary: Promise<boolean>;
	    readonly isChargeable: Promise<boolean>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly keyConcatenation: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly sequenceNumber: Promise<string>;
	    readonly responsiblePerson: Reference<sageX3ProjectManagement.nodes.ProjectUser | null>;
	    readonly estimatedProgress: Promise<decimal | null>;
	    readonly progressRange: Reference<sageX3System.nodes.MiscellaneousTable | null>;
	    readonly progressDate: Promise<date | null>;
	    readonly progressMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
	    readonly billingMode: Promise<sageX3ProjectManagementData.enums.BillingMode>;
	    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
	    readonly source: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
	    readonly lines: Collection<sageX3ProjectManagement.nodes.BudgetLine>;
	    readonly projectLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
	    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly isActive: Promise<boolean>;
	    readonly localizedDescription: Promise<string>;
	    readonly localizedShortDescription: Promise<string>;
	    readonly longComment: Promise<TextStream>;
	    readonly longDescription: Promise<TextStream>;
	    readonly type: Promise<sageX3MasterData.enums.ProjectAllocationType>;
	}
	//# sourceMappingURL=budget.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/nodes/budget-line.d.ts
declare module '@sage/x3-project-management/lib/nodes/budget-line' {
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { Node, Reference, integer, decimal, date, TextStream } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class BudgetLine extends Node {
	    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
	    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget>;
	    readonly lineNumber: Promise<integer>;
	    readonly costType: Reference<sageX3ProjectManagementData.nodes.CostType>;
	    readonly site: Reference<sageX3System.nodes.Site | null>;
	    readonly localizedDescription: Promise<string>;
	    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly quantity: Promise<decimal | null>;
	    readonly unitPrice: Promise<decimal | null>;
	    readonly isPriceForced: Promise<boolean>;
	    readonly amount: Promise<decimal | null>;
	    readonly lastBudgetDate: Promise<date | null>;
	    readonly hasNothingLeftToCommit: Promise<boolean>;
	    readonly remainingQuantity: Promise<decimal | null>;
	    readonly remainingUnitPrice: Promise<decimal | null>;
	    readonly remainingAmount: Promise<decimal | null>;
	    readonly lastEstimatedDate: Promise<date | null>;
	    readonly lastEstimatedQuantity: Promise<decimal | null>;
	    readonly lastEstimatedAmount: Promise<decimal | null>;
	    readonly recordedQuantity: Promise<decimal | null>;
	    readonly recordedAmount: Promise<decimal | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
	    readonly origin: Promise<sageX3ProjectManagementData.enums.BudgetLineOrigin | null>;
	    readonly saleableProductLine: Promise<string>;
	    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
	    readonly longComment: Promise<TextStream>;
	    readonly longDescription: Promise<TextStream>;
	}
	//# sourceMappingURL=budget-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/node-extensions/work-center-extension.d.ts
declare module '@sage/x3-project-management/lib/node-extensions/work-center-extension' {
	import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	export class WorkCenterExtension extends NodeExtension<sageX3ManufacturingData.nodes.WorkCenter> {
	    readonly costTypeProject: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
	}
	declare module '@sage/x3-manufacturing-data/lib/nodes/work-center' {
	    interface WorkCenter extends WorkCenterExtension {
	    }
	}
	//# sourceMappingURL=work-center-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/node-extensions/project-link-extension.d.ts
declare module '@sage/x3-project-management/lib/node-extensions/project-link-extension' {
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class ProjectLinkExtension extends NodeExtension<sageX3ProjectManagementData.nodes.ProjectLink> {
	    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
	    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget | null>;
	    readonly task: Reference<sageX3ProjectManagement.nodes.Task | null>;
	    readonly financialSite: Reference<sageX3System.nodes.Site>;
	    readonly projectStatus: Promise<sageX3ProjectManagementData.enums.ProjectStatus | null>;
	    readonly budgetStatus: Promise<sageX3ProjectManagementData.enums.ProjectBudgetStatus | null>;
	    readonly taskStatus: Promise<sageX3ProjectManagementData.enums.ProjectTaskStatus | null>;
	    readonly billingMode: Promise<sageX3ProjectManagementData.enums.BillingMode>;
	}
	declare module '@sage/x3-project-management-data/lib/nodes/project-link' {
	    interface ProjectLink extends ProjectLinkExtension {
	    }
	}
	//# sourceMappingURL=project-link-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/node-extensions/index.d.ts
declare module '@sage/x3-project-management/lib/node-extensions/index' {
	export * from '@sage/x3-project-management/lib/node-extensions/cost-type-extension';
	export * from '@sage/x3-project-management/lib/node-extensions/project-link-extension';
	export * from '@sage/x3-project-management/lib/node-extensions/work-center-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/node-extensions/cost-type-extension.d.ts
declare module '@sage/x3-project-management/lib/node-extensions/cost-type-extension' {
	import * as sageX3FinanceData from '@sage/x3-finance-data';
	import * as sageX3MasterData from '@sage/x3-master-data';
	import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
	import * as sageX3System from '@sage/x3-system';
	import { NodeExtension, Reference, decimal, Collection } from '@sage/xtrem-core';
	import * as sageX3ProjectManagement from '@sage/x3-project-management/lib/index';
	export class CostTypeExtension extends NodeExtension<sageX3ProjectManagementData.nodes.CostType> {
	    readonly costTypeGroup: Reference<sageX3System.nodes.MiscellaneousTable>;
	    readonly isPurchasingCost: Promise<boolean>;
	    readonly isLaborCost: Promise<boolean>;
	    readonly isStockIssueCost: Promise<boolean>;
	    readonly isAccountingCost: Promise<boolean>;
	    readonly product: Reference<sageX3MasterData.nodes.Product | null>;
	    readonly isIndirectCost: Promise<boolean>;
	    readonly indirectCostPercentage: Promise<decimal | null>;
	    readonly indirectCostType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
	    readonly laborUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
	    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
	    readonly chart: Reference<sageX3FinanceData.nodes.ChartOfAccounts | null>;
	    readonly account: Reference<sageX3FinanceData.nodes.Account | null>;
	    readonly accountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
	    readonly rateDates: Collection<sageX3ProjectManagement.nodes.CostDate>;
	    readonly costGroupLinks: Collection<sageX3ProjectManagement.nodes.CostGroupLink>;
	}
	declare module '@sage/x3-project-management-data/lib/nodes/cost-type' {
	    interface CostType extends CostTypeExtension {
	    }
	}
	//# sourceMappingURL=cost-type-extension.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/menu-items/project.d.ts
declare module '@sage/x3-project-management/lib/menu-items/project' {
	import type { RootMenuItem } from '@sage/xtrem-shared';
	export const project: RootMenuItem;
	//# sourceMappingURL=project.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/menu-items/index.d.ts
declare module '@sage/x3-project-management/lib/menu-items/index' {
	export * from '@sage/x3-project-management/lib/menu-items/project';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/functions/time-entry-line.d.ts
declare module '@sage/x3-project-management/lib/functions/time-entry-line' {
	import * as x3MasterData from '@sage/x3-master-data';
	import * as x3ProjectManagement from '@sage/x3-project-management/lib/index';
	export function getConnectedEmployee(_this: x3ProjectManagement.nodes.TimeEntryLine): Promise<x3ProjectManagement.nodes.ProjectUser>;
	export function getIsTimeEntryAdministrator(_this: x3ProjectManagement.nodes.TimeEntryLine): Promise<boolean>;
	export function getIsTimeEntryEmployee(_this: x3ProjectManagement.nodes.TimeEntryLine): Promise<boolean>;
	export function getIsNegativeTimeSpentAllowed(_this: x3ProjectManagement.nodes.TimeEntryLine): Promise<boolean>;
	export function getDefaultTimeCategory(_this: x3ProjectManagement.nodes.TimeEntryLine): Promise<x3ProjectManagement.nodes.TimeCategory | null>;
	export function getDefaultUnit(_this: x3ProjectManagement.nodes.TimeEntryLine): Promise<x3MasterData.nodes.UnitOfMeasure | null>;
	export function getIsValidatedDefault(_this: x3ProjectManagement.nodes.TimeEntryLine): Promise<boolean>;
	//# sourceMappingURL=time-entry-line.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/functions/index.d.ts
declare module '@sage/x3-project-management/lib/functions/index' {
	export * from '@sage/x3-project-management/lib/functions/time-entry-line';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/x3-services/application/x3-project-management/build/lib/enums/index.d.ts
declare module '@sage/x3-project-management/lib/enums/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/x3-project-management' {
	export * from '@sage/x3-project-management/index';
}
