import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, TextStream, Collection, Context, DateValue } from '@sage/xtrem-core';
import * as sageX3ProjectManagement from '..';
export declare class TimeEntryLine extends Node {
    readonly employee: Reference<sageX3ProjectManagement.nodes.ProjectUser>;
    readonly lineNumber: Promise<integer>;
    readonly date: Promise<date>;
    readonly taskLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly budgetLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly project: Reference<sageX3ProjectManagement.nodes.Project | null>;
    readonly task: Reference<sageX3ProjectManagement.nodes.Task | null>;
    readonly operation: Reference<sageX3ProjectManagement.nodes.Operation | null>;
    readonly firstOperationSplit: Promise<integer | null>;
    readonly assignmentLine: Reference<sageX3ProjectManagement.nodes.OperationAssignment | null>;
    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget | null>;
    readonly financialSite: Reference<sageX3System.nodes.Site | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency | null>;
    readonly rateType: Promise<sageX3System.enums.ExchangeRateType>;
    readonly projectCostType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
    readonly employeeCostType: Reference<sageX3ProjectManagementData.nodes.CostType | null>;
    readonly projectLaborRate: Promise<decimal | null>;
    readonly employeeLaborRate: Promise<decimal | null>;
    readonly timeSpent: Promise<decimal>;
    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
    readonly rateMultiplier: Promise<decimal>;
    readonly localizedDescription: Promise<string>;
    readonly isValidated: Promise<boolean>;
    readonly status: Promise<sageX3ProjectManagementData.enums.TimeEntryStatus>;
    readonly origin: Promise<sageX3ProjectManagementData.enums.TimeEntryOrigin>;
    readonly validatedBy: Reference<sageX3System.nodes.User | null>;
    readonly controlledBy: Reference<sageX3System.nodes.User | null>;
    readonly approvedBy: Reference<sageX3System.nodes.User | null>;
    readonly entryType: Reference<sageX3FinanceData.nodes.EntryType | null>;
    readonly rejectedBy: Reference<sageX3System.nodes.User | null>;
    readonly journal: Reference<sageX3FinanceData.nodes.Journal | null>;
    readonly postedBy: Reference<sageX3System.nodes.User | null>;
    readonly journalNumber: Promise<string>;
    readonly isBillable: Promise<boolean>;
    readonly billableFrom: Promise<date | null>;
    readonly billedQuantity: Promise<decimal | null>;
    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly longComment: Promise<TextStream>;
    readonly longDescription: Promise<TextStream>;
    readonly connectedEmployee: Reference<sageX3ProjectManagement.nodes.ProjectUser | null>;
    readonly defaultTimeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
    readonly defaultUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly isNegativeTimeSpentAllowed: Promise<boolean | null>;
    readonly isTimeEntryAdministrator: Promise<boolean | null>;
    readonly isTimeEntryEmployee: Promise<boolean | null>;
    readonly isValidatedDefault: Promise<boolean | null>;
    readonly currencyRates: Collection<sageX3ProjectManagement.nodes.TimeEntryLineCurrencyRates>;
    readonly dimensions: Collection<sageX3ProjectManagement.nodes.TimeEntryLineDimensions>;
    static computeProjectEmployeeCostType(context: Context, parameters: {
        project: string;
        task: string;
        operation: number;
        employee: string;
        timeCategory: string;
    }): Promise<{
        employeeCostType: string;
        projectCostType: string;
    }>;
    static computeProjectEmployeeLaborRate(context: Context, parameters: {
        employee: string;
        date: DateValue;
        unit: string;
        currency: string;
        rateType: sageX3System.enums.ExchangeRateType;
        projectCostType: string;
        employeeCostType: string;
    }): Promise<{
        projectLaborRate: decimal;
        employeeLaborRate: decimal;
        message: string;
    }>;
    static computeUnitOfMeasure(context: Context, parameters: {
        project: string;
        task: string;
        operation: number;
        employee: string;
        timeCategory: string;
        costType: string;
    }): Promise<{
        unit: string;
    }>;
}
//# sourceMappingURL=time-entry-line.d.ts.map