"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Task = void 0;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        site: {
            code: 'site',
        },
        parent: {
            project: 'project',
            code: 'parent',
        },
        category: {
            code: 'category',
        },
        budget: {
            project: 'project',
            code: 'budget',
        },
        keyConcatenation: {
            id: 'keyConcatenation',
        },
        responsiblePerson: {
            employee: 'responsiblePerson',
        },
        progressRange: {
            glossaryId() {
                return 387;
            },
            code: 'progressRange',
        },
        timeCategory: {
            code: 'timeCategory',
        },
        source: {
            id: 'source',
        },
        projectLink: {
            id: 'keyConcatenation',
        },
        longCommentRef: {
            code() {
                return 'PJMTSK';
            },
            identifier1() {
                return 'TASCOMTEX';
            },
            identifier2: 'project',
            identifier3: 'code',
            identifier4() {
                return null;
            },
        },
        longDescriptionRef: {
            code() {
                return 'PJMTSK';
            },
            identifier1() {
                return 'TASDESTEX';
            },
            identifier2: 'project',
            identifier3: 'code',
            identifier4() {
                return null;
            },
        },
        pjmProject: {
            project: 'project',
        },
    },
    collectionJoins: {
        operations: {
            project: 'project',
            task: 'code',
        },
        products: {
            project: 'project',
            task: 'code',
        },
        precedenceLinks: {
            project: 'project',
            task: 'code',
        },
    },
};
const compositeReferences = {
    projectLink: {
        isActive: 'isActive',
        localizedDescription: 'localizedDescription',
        localizedShortDescription: 'localizedShortDescription',
        type: 'type',
    },
    pjmProject: {
        isBudgetCreatedAutomatically: 'isBudgetCreatedAutomatically',
    },
    longCommentRef: {
        longComment: 'text',
    },
    longDescriptionRef: {
        longDescription: 'text',
    },
};
let Task = class Task extends xtrem_core_1.Node {
};
exports.Task = Task;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Project,
    })
], Task.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'TASCOD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Task.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], Task.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASPAE',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Task,
    })
], Task.prototype, "parent", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASSOR',
    })
], Task.prototype, "sortKey", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASTYP',
        dataType: () => sageX3ProjectManagementData.enums.opeProvTaskDatatype,
    })
], Task.prototype, "taskType", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASSTARTDT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Task.prototype, "startDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASENDDT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Task.prototype, "endDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASDUR',
    })
], Task.prototype, "duration", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASDATL',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Task.prototype, "launchingDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASDATP',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Task.prototype, "planningDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASDATB',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Task.prototype, "beginningDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASDATS',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Task.prototype, "closingDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASDATH',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Task.prototype, "suspensionDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASTLA',
    })
], Task.prototype, "isToLaunch", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASSTATE',
        dataType: () => sageX3ProjectManagementData.enums.projectTaskStatusDatatype,
    })
], Task.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TCACOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.TaskCategory,
    })
], Task.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Budget,
    })
], Task.prototype, "budget", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnName: 'KEYCONCAT',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], Task.prototype, "keyConcatenation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RPBAUS',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.ProjectUser,
    })
], Task.prototype, "responsiblePerson", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'TASNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], Task.prototype, "sequenceNumber", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPL',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], Task.prototype, "estimatedProgress", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPLADI',
        columnType: 'string',
        filters: {
            lookup: {
                glossaryId: 387,
            },
            control: {
                glossaryId: 387,
            },
        },
        node: () => sageX3System.nodes.MiscellaneousTable,
    })
], Task.prototype, "progressRange", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRCCPLDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Task.prototype, "progressDate", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRCCPLMET',
        dataType: () => sageX3ProjectManagementData.enums.estimationMethodUsedDatatype,
    })
], Task.prototype, "progressMethod", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PROBIL',
        dataType: () => sageX3ProjectManagementData.enums.billingModeDatatype,
    })
], Task.prototype, "billingMode", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DUEDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], Task.prototype, "dueDate", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTETYP',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.TimeCategory,
    })
], Task.prototype, "timeCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORITAS',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], Task.prototype, "source", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.Operation,
        isMutable: true,
        dependsOn: ['project', 'code'],
    })
], Task.prototype, "operations", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.TaskProduct,
        isMutable: true,
        dependsOn: ['project', 'code'],
    })
], Task.prototype, "products", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageX3ProjectManagement.nodes.TaskPrecedenceLink,
        isMutable: true,
        dependsOn: ['project', 'code'],
    })
], Task.prototype, "precedenceLinks", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], Task.prototype, "projectLink", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMTSK',
                identifier1: 'TASCOMTEX',
                identifier4: null,
            },
            control: {
                code: 'PJMTSK',
                identifier1: 'TASCOMTEX',
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], Task.prototype, "longCommentRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMTSK',
                identifier1: 'TASDESTEX',
                identifier4: null,
            },
            control: {
                code: 'PJMTSK',
                identifier1: 'TASDESTEX',
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], Task.prototype, "longDescriptionRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.PjmProject,
    })
], Task.prototype, "pjmProject", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMSTA',
    })
], Task.prototype, "isActive", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASBUDAUT',
    })
], Task.prototype, "isBudgetCreatedAutomatically", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], Task.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMDESAX1',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], Task.prototype, "localizedShortDescription", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], Task.prototype, "longComment", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], Task.prototype, "longDescription", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIMTYP',
        dataType: () => sageX3MasterData.enums.projectAllocationTypeDatatype,
    })
], Task.prototype, "type", void 0);
exports.Task = Task = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMTSK',
        keyPropertyNames: ['project', 'code'],
        indexes: [
            {
                orderBy: {
                    project: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
        canCreate: true,
        canUpdate: true,
        canDelete: true,
        canDeleteMany: true,
    })
], Task);
//# sourceMappingURL=task.js.map