import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, decimal, date, TextStream } from '@sage/xtrem-core';
import * as sageX3ProjectManagement from '..';
export declare class TaskProduct extends Node {
    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
    readonly task: Reference<sageX3ProjectManagement.nodes.Task>;
    readonly lineNumber: Promise<integer>;
    readonly keyConcatenation: Promise<string>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly shippingSite: Reference<sageX3System.nodes.Site>;
    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly requiredQuantity: Promise<decimal>;
    readonly requirementDate: Promise<date | null>;
    readonly product: Reference<sageX3MasterData.nodes.Product | null>;
    readonly localizedDescription: Promise<string>;
    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorVersion: Reference<sageX3MasterData.nodes.ProductVersion | null>;
    readonly bomCode: Reference<sageX3MasterData.nodes.BomCodes | null>;
    readonly planNumber: Promise<string>;
    readonly planVersion: Promise<string>;
    readonly isSold: Promise<boolean>;
    readonly consumptionMode: Promise<sageX3ProjectManagementData.enums.ConsumptionMode>;
    readonly allocatedQuantity: Promise<decimal | null>;
    readonly shortageQuantity: Promise<decimal | null>;
    readonly manualAllocation: Promise<decimal | null>;
    readonly allocationStatus: Promise<sageX3MasterData.enums.AllocationStatus>;
    readonly allocationType: Promise<sageX3MasterData.enums.AllocationType>;
    readonly inProcessQuantity: Promise<decimal | null>;
    readonly deliveredQuantity: Promise<decimal | null>;
    readonly deliveryStatus: Promise<sageX3ProjectManagementData.enums.DeliveryStatus>;
    readonly orderedQuantity: Promise<decimal | null>;
    readonly workInProgressOrderNumber: Promise<string>;
    readonly closeWip: Promise<boolean>;
    readonly isDeliverable: Promise<boolean>;
    readonly primaryBudgetingMethod: Promise<sageX3ProjectManagementData.enums.BudgetMethod>;
    readonly secondaryBudgetingMethod: Promise<sageX3ProjectManagementData.enums.BudgetMethod>;
    readonly manualBudgetAmount: Promise<decimal | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly saleableProductLine: Promise<string>;
    readonly stockManagement: Promise<sageX3MasterData.enums.StockManagement>;
    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly longComment: Promise<TextStream>;
    readonly longDescription: Promise<TextStream>;
}
//# sourceMappingURL=task-product.d.ts.map