"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskCategoryOperation = void 0;
const sageX3ManufacturingData = require("@sage/x3-manufacturing-data");
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        category: {
            code: 'category',
        },
        site: {
            code: 'site',
        },
        numberOfResource1: {
            code: 'numberOfResource1',
            manufacturingSite: 'site',
        },
        numberOfResource2: {
            code: 'numberOfResource2',
            manufacturingSite: 'site',
        },
        packingUnit: {
            code: 'packingUnit',
        },
        employee: {
            employee: 'employee',
        },
        timeCategory: {
            code: 'timeCategory',
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'PJMTSKCATOPE';
            },
            columnName() {
                return 'PTCODESAXX';
            },
            key1: ['category', 'lineNumber'],
        },
    },
};
let TaskCategoryOperation = class TaskCategoryOperation extends xtrem_core_1.Node {
};
exports.TaskCategoryOperation = TaskCategoryOperation;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TCACOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.TaskCategory,
    })
], TaskCategoryOperation.prototype, "category", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'IPTCOSEQ',
    })
], TaskCategoryOperation.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], TaskCategoryOperation.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EXTWST',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], TaskCategoryOperation.prototype, "numberOfResource1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTLAB',
        columnType: 'string',
        node: () => sageX3ManufacturingData.nodes.WorkCenter,
    })
], TaskCategoryOperation.prototype, "numberOfResource2", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PTCODESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], TaskCategoryOperation.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPEUOM2',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], TaskCategoryOperation.prototype, "packingUnit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EXTQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], TaskCategoryOperation.prototype, "plannedLoad", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPEDUR',
    })
], TaskCategoryOperation.prototype, "duration", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POACLB',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.ProjectUser,
    })
], TaskCategoryOperation.prototype, "employee", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTETYP',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.TimeCategory,
    })
], TaskCategoryOperation.prototype, "timeCategory", void 0);
exports.TaskCategoryOperation = TaskCategoryOperation = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMTSKCATOPE',
        keyPropertyNames: ['category', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    category: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], TaskCategoryOperation);
//# sourceMappingURL=task-category-operation.js.map