import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3StockData from '@sage/x3-stock-data';
import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
import * as sageX3ProjectManagement from '..';
export declare class SaleableProduct extends Node {
    readonly project: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget | null>;
    readonly task: Reference<sageX3ProjectManagement.nodes.Task | null>;
    readonly lineNumber: Promise<integer>;
    readonly product: Reference<sageX3MasterData.nodes.Product>;
    readonly description: Promise<string>;
    readonly majorVersion: Reference<sageX3StockData.nodes.MajorVersionStatus | null>;
    readonly minorVersion: Promise<string>;
    readonly plannedQuantity: Promise<decimal | null>;
    readonly plannedUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly quantity: Promise<decimal>;
    readonly salesUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly quantityInStockUnit: Promise<decimal>;
    readonly stockUnit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly basePrice: Promise<decimal | null>;
    readonly origin: Promise<sageX3ProjectManagementData.enums.SaleablePrdLineOrigin>;
    readonly initialGrouping: Promise<sageX3ProjectManagementData.enums.SoldProductsLinePrdGrpLvl>;
    readonly productGroupingLevel: Promise<sageX3ProjectManagementData.enums.SoldProductsLinePrdGrpLvl>;
    readonly sourceOperation: Reference<sageX3ProjectManagement.nodes.Operation | null>;
    readonly sourceProductLine: Reference<sageX3ProjectManagement.nodes.TaskProduct | null>;
    readonly sourceBudgetLine: Reference<sageX3ProjectManagement.nodes.BudgetLine | null>;
    readonly lineOrigin: Promise<string>;
}
//# sourceMappingURL=saleable-product.d.ts.map