import * as sageX3FinanceData from '@sage/x3-finance-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, date, integer, decimal, Collection } from '@sage/xtrem-core';
import * as sageX3ProjectManagement from '..';
export declare class PjmProject extends Node {
    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
    readonly isInternal: Promise<boolean>;
    readonly isProvisional: Promise<boolean>;
    readonly projectStatus: Promise<sageX3ProjectManagementData.enums.ProjectStatus | null>;
    readonly suspensionDate: Promise<date | null>;
    readonly deliveryDate: Promise<date | null>;
    readonly closingDate: Promise<date | null>;
    readonly launchingDate: Promise<date | null>;
    readonly isIndirectCostCalculated: Promise<boolean>;
    readonly overviewCurrency: Reference<sageX3MasterData.nodes.Currency | null>;
    readonly isIntermediateLevelBudgetingAllowed: Promise<boolean>;
    readonly operatingSite: Reference<sageX3System.nodes.Site>;
    readonly isTemplate: Promise<boolean>;
    readonly isBudgetCreatedAutomatically: Promise<boolean>;
    readonly startDate: Promise<date | null>;
    readonly endDate: Promise<date | null>;
    readonly dueDate: Promise<date | null>;
    readonly duration: Promise<integer | null>;
    readonly responsiblePerson: Reference<sageX3ProjectManagement.nodes.ProjectUser | null>;
    readonly revenueRecognitionRule: Reference<sageX3FinanceData.nodes.RevenueRecognitionRules | null>;
    readonly estimatedRevenueAtCompletion: Promise<decimal | null>;
    readonly revenueEstimationDate: Promise<date | null>;
    readonly revenueEstimationMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
    readonly revenueRecognitionExtractionMethod: Promise<sageX3ProjectManagementData.enums.CalculationMethodUsed>;
    readonly accountingCode: Reference<sageX3FinanceData.nodes.AccountingCode | null>;
    readonly estimatedProgressPercentage: Promise<decimal | null>;
    readonly progressRange: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly progressEstimationDate: Promise<date | null>;
    readonly progressEstimationMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
    readonly billingMode: Promise<sageX3ProjectManagementData.enums.BillingMode>;
    readonly source: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly dimensions: Collection<sageX3ProjectManagement.nodes.PjmProjectDimensions>;
}
//# sourceMappingURL=pjm-project.d.ts.map