import * as sageX3ManufacturingData from '@sage/x3-manufacturing-data';
import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3ProjectManagement from '..';
export declare class Operation extends Node {
    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
    readonly task: Reference<sageX3ProjectManagement.nodes.Task>;
    readonly number: Promise<integer>;
    readonly firstOperationSplit: Promise<integer | null>;
    readonly site: Reference<sageX3System.nodes.Site>;
    readonly workCenterLaborResource1: Reference<sageX3ManufacturingData.nodes.WorkCenter>;
    readonly workCenterLaborResource2: Reference<sageX3ManufacturingData.nodes.WorkCenter | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly status: Promise<sageX3ManufacturingData.enums.OperationStatus>;
    readonly startDate: Promise<date | null>;
    readonly endDate: Promise<date | null>;
    readonly duration: Promise<integer | null>;
    readonly localizedDescription: Promise<string>;
    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure>;
    readonly numberOfResource1: Promise<integer | null>;
    readonly numberOfResource2: Promise<integer | null>;
    readonly plannedLoad: Promise<decimal | null>;
    readonly consumedLoad: Promise<decimal | null>;
    readonly remainingLoad: Promise<decimal | null>;
    readonly hourlyRate: Promise<decimal | null>;
    readonly laborRate: Promise<decimal | null>;
    readonly actualStartDate: Promise<date | null>;
    readonly actualEndDate: Promise<date | null>;
    readonly closingDate: Promise<date | null>;
    readonly suspensionDate: Promise<date | null>;
    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
    readonly saleableProductLine: Promise<string>;
    readonly assignments: Collection<sageX3ProjectManagement.nodes.OperationAssignment>;
    readonly precedenceLinks: Collection<sageX3ProjectManagement.nodes.OperationPrecedenceLink>;
    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly longComment: Promise<TextStream>;
    readonly longDescription: Promise<TextStream>;
}
//# sourceMappingURL=operation.d.ts.map