"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperationPrecedenceLink = void 0;
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        task: {
            project: 'project',
            code: 'task',
        },
        operation: {
            project: 'project',
            task: 'task',
            number: 'operation',
            firstOperationSplit: 'firstOperationSplit',
        },
        linkedOperation: {
            project: 'project',
            task: 'task',
            number: 'linkedOperation',
            firstOperationSplit: 'linkedOperationSplit',
        },
    },
};
let OperationPrecedenceLink = class OperationPrecedenceLink extends xtrem_core_1.Node {
};
exports.OperationPrecedenceLink = OperationPrecedenceLink;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.ProjectLink,
    })
], OperationPrecedenceLink.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Task,
    })
], OperationPrecedenceLink.prototype, "task", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPENUM',
        columnType: 'integer',
        node: () => sageX3ProjectManagement.nodes.Operation,
    })
], OperationPrecedenceLink.prototype, "operation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPESPLNUM',
    })
], OperationPrecedenceLink.prototype, "firstOperationSplit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SEQNUM',
    })
], OperationPrecedenceLink.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPENUMLNK',
        columnType: 'integer',
        node: () => sageX3ProjectManagement.nodes.Operation,
    })
], OperationPrecedenceLink.prototype, "linkedOperation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPESPNUMLNK',
    })
], OperationPrecedenceLink.prototype, "linkedOperationSplit", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPELNKTYP',
        dataType: () => sageX3ProjectManagementData.enums.operationsLinkTypeDatatype,
    })
], OperationPrecedenceLink.prototype, "linkType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPELNKCSTR',
        dataType: () => sageX3ProjectManagementData.enums.constraintTypeDatatype,
    })
], OperationPrecedenceLink.prototype, "constraintType", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPELNKLAG',
    })
], OperationPrecedenceLink.prototype, "lagDays", void 0);
exports.OperationPrecedenceLink = OperationPrecedenceLink = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMTSKOPELNK',
        keyPropertyNames: ['project', 'task', 'operation', 'firstOperationSplit', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    project: 1,
                    task: 1,
                    operation: 1,
                    firstOperationSplit: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], OperationPrecedenceLink);
//# sourceMappingURL=operation-precedence-link.js.map