"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperationAssignment = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        task: {
            project: 'project',
            code: 'task',
        },
        operation: {
            project: 'project',
            task: 'task',
            number: 'operation',
            firstOperationSplit: 'firstOperationSplit',
        },
        employee: {
            employee: 'employee',
        },
        unit: {
            code: 'unit',
        },
        currency: {
            code: 'currency',
        },
        timeCategory: {
            code: 'timeCategory',
        },
        longCommentRef: {
            code() {
                return 'PJMOPEAFF';
            },
            identifier1() {
                return 'POALGCOM';
            },
            async identifier2() {
                return (typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add((await this.project), '~'), (await (await this.task).code)), '~'), (await (await this.operation).number)), '~'), (await this.firstOperationSplit)), '~'), (await this.lineNumber)));
            },
            identifier3: 'lineNumber',
            identifier4() {
                return null;
            },
        },
        longDescriptionRef: {
            code() {
                return 'PJMOPEAFF';
            },
            identifier1() {
                return 'POALGDES';
            },
            async identifier2() {
                return (typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add(typesLib.add((await this.project), '~'), (await (await this.task).code)), '~'), (await (await this.operation).number)), '~'), (await this.firstOperationSplit)), '~'), (await this.lineNumber)));
            },
            identifier3: 'lineNumber',
            identifier4() {
                return null;
            },
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'PJMOPEAFF';
            },
            columnName() {
                return 'POADES';
            },
            key1: ['keyConcatenation'],
        },
    },
};
const compositeReferences = {
    longCommentRef: {
        longComment: 'text',
    },
    longDescriptionRef: {
        longDescription: 'text',
    },
};
let OperationAssignment = class OperationAssignment extends xtrem_core_1.Node {
};
exports.OperationAssignment = OperationAssignment;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Project,
    })
], OperationAssignment.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'TASCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Task,
    })
], OperationAssignment.prototype, "task", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPENUM',
        columnType: 'integer',
        node: () => sageX3ProjectManagement.nodes.Operation,
    })
], OperationAssignment.prototype, "operation", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPESPLNUM',
    })
], OperationAssignment.prototype, "firstOperationSplit", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POANUM',
    })
], OperationAssignment.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POACLB',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.ProjectUser,
    })
], OperationAssignment.prototype, "employee", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POADES',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], OperationAssignment.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POUOM',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], OperationAssignment.prototype, "unit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POASTDQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OperationAssignment.prototype, "plannedLoad", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POACSMQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OperationAssignment.prototype, "consumedLoad", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POARMNQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OperationAssignment.prototype, "remainingLoad", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], OperationAssignment.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POACST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OperationAssignment.prototype, "hourlyRate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POACSTLAB',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], OperationAssignment.prototype, "laborRate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POASTR',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], OperationAssignment.prototype, "startDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'POAEND',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], OperationAssignment.prototype, "endDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POASTRHM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], OperationAssignment.prototype, "startTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'POAENDHM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], OperationAssignment.prototype, "endTime", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isStored: true,
        columnName: 'KEYCONCAT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], OperationAssignment.prototype, "keyConcatenation", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PTETYP',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.TimeCategory,
    })
], OperationAssignment.prototype, "timeCategory", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMOPEAFF',
                identifier1: 'POALGCOM',
                identifier4: null,
            },
            control: {
                code: 'PJMOPEAFF',
                identifier1: 'POALGCOM',
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], OperationAssignment.prototype, "longCommentRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMOPEAFF',
                identifier1: 'POALGDES',
                identifier4: null,
            },
            control: {
                code: 'PJMOPEAFF',
                identifier1: 'POALGDES',
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], OperationAssignment.prototype, "longDescriptionRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], OperationAssignment.prototype, "longComment", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], OperationAssignment.prototype, "longDescription", void 0);
exports.OperationAssignment = OperationAssignment = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMOPEAFF',
        keyPropertyNames: ['project', 'task', 'operation', 'firstOperationSplit', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    project: 1,
                    task: 1,
                    operation: 1,
                    firstOperationSplit: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
            joinFallbackProperties: ['firstOperationSplit'],
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], OperationAssignment);
//# sourceMappingURL=operation-assignment.js.map