"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CostGroupLink = void 0;
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3StockData = require("@sage/x3-stock-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const joins = {
    referenceJoins: {
        costType: {
            code: 'costType',
        },
    },
};
let CostGroupLink = class CostGroupLink extends xtrem_core_1.Node {
};
exports.CostGroupLink = CostGroupLink;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCCCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.CostType,
    })
], CostGroupLink.prototype, "costType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCGTYP',
        dataType: () => sageX3ProjectManagementData.enums.costGroupTypeDatatype,
    })
], CostGroupLink.prototype, "costGroupType", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCGGRPMAT',
        dataType: () => sageX3StockData.enums.materialCostGroupDatatype,
    })
], CostGroupLink.prototype, "material", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCGGRPLAB',
        dataType: () => sageX3StockData.enums.dimensionCostGroupDatatype,
    })
], CostGroupLink.prototype, "labor", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PCGGRPMAC',
        dataType: () => sageX3StockData.enums.dimensionCostGroupDatatype,
    })
], CostGroupLink.prototype, "machine", void 0);
exports.CostGroupLink = CostGroupLink = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMCOSTGRP',
        keyPropertyNames: ['costType', 'costGroupType', 'material', 'labor', 'machine'],
        indexes: [
            {
                orderBy: {
                    costType: 1,
                    costGroupType: 1,
                    material: 1,
                    labor: 1,
                    machine: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['costGroupType', 'material', 'labor', 'machine'],
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], CostGroupLink);
//# sourceMappingURL=cost-group-link.js.map