import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, date, decimal, Collection, TextStream } from '@sage/xtrem-core';
import * as sageX3ProjectManagement from '..';
export declare class Budget extends Node {
    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
    readonly code: Promise<string>;
    readonly site: Reference<sageX3System.nodes.Site | null>;
    readonly sortKey: Promise<integer | null>;
    readonly suspensionDate: Promise<date | null>;
    readonly closingDate: Promise<date | null>;
    readonly deliveryDate: Promise<date | null>;
    readonly parent: Reference<sageX3ProjectManagement.nodes.Budget | null>;
    readonly status: Promise<sageX3ProjectManagementData.enums.ProjectBudgetStatus | null>;
    readonly isElementary: Promise<boolean>;
    readonly isChargeable: Promise<boolean>;
    readonly startDate: Promise<date | null>;
    readonly endDate: Promise<date | null>;
    readonly keyConcatenation: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly sequenceNumber: Promise<string>;
    readonly responsiblePerson: Reference<sageX3ProjectManagement.nodes.ProjectUser | null>;
    readonly estimatedProgress: Promise<decimal | null>;
    readonly progressRange: Reference<sageX3System.nodes.MiscellaneousTable | null>;
    readonly progressDate: Promise<date | null>;
    readonly progressMethod: Promise<sageX3ProjectManagementData.enums.EstimationMethodUsed>;
    readonly billingMode: Promise<sageX3ProjectManagementData.enums.BillingMode>;
    readonly timeCategory: Reference<sageX3ProjectManagement.nodes.TimeCategory | null>;
    readonly source: Reference<sageX3ProjectManagementData.nodes.ProjectLink | null>;
    readonly lines: Collection<sageX3ProjectManagement.nodes.BudgetLine>;
    readonly projectLink: Reference<sageX3ProjectManagementData.nodes.ProjectLink>;
    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly isActive: Promise<boolean>;
    readonly localizedDescription: Promise<string>;
    readonly localizedShortDescription: Promise<string>;
    readonly longComment: Promise<TextStream>;
    readonly longDescription: Promise<TextStream>;
    readonly type: Promise<sageX3MasterData.enums.ProjectAllocationType>;
}
//# sourceMappingURL=budget.d.ts.map