"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BudgetLine = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const sageX3MasterData = require("@sage/x3-master-data");
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        budget: {
            project: 'project',
            code: 'budget',
        },
        costType: {
            code: 'costType',
        },
        site: {
            code: 'site',
        },
        unit: {
            code: 'unit',
        },
        currency: {
            code: 'currency',
        },
        longDescriptionRef: {
            code() {
                return 'PJMBUDLIG';
            },
            identifier1() {
                return 'PLBDESTEX';
            },
            async identifier2() {
                return typesLib.add(typesLib.add((await this.project), '~'), (await (await this.budget).code));
            },
            identifier3: 'lineNumber',
            identifier4() {
                return null;
            },
        },
        longCommentRef: {
            code() {
                return 'PJMBUDLIG';
            },
            identifier1() {
                return 'PLBCOMTEX';
            },
            async identifier2() {
                return typesLib.add(typesLib.add((await this.project), '~'), (await (await this.budget).code));
            },
            identifier3: 'lineNumber',
            identifier4() {
                return null;
            },
        },
    },
    localizedStrings: {
        localizedDescription: {
            tableName() {
                return 'PJMBUDLIG';
            },
            columnName() {
                return 'PLBDESAXX';
            },
            key1: ['project', 'budget'],
            key2: ['lineNumber'],
        },
    },
};
const compositeReferences = {
    longCommentRef: {
        longComment: 'text',
    },
    longDescriptionRef: {
        longDescription: 'text',
    },
};
let BudgetLine = class BudgetLine extends xtrem_core_1.Node {
};
exports.BudgetLine = BudgetLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Project,
    })
], BudgetLine.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PBUCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Budget,
    })
], BudgetLine.prototype, "budget", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PLBSEQ',
    })
], BudgetLine.prototype, "lineNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PCCCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagementData.nodes.CostType,
    })
], BudgetLine.prototype, "costType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], BudgetLine.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'PLBDESAXX',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], BudgetLine.prototype, "localizedDescription", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBU',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.UnitOfMeasure,
    })
], BudgetLine.prototype, "unit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BudgetLine.prototype, "quantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBPRI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BudgetLine.prototype, "unitPrice", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PLBPRIFRC',
    })
], BudgetLine.prototype, "isPriceForced", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBAMT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BudgetLine.prototype, "amount", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBDATBUD',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], BudgetLine.prototype, "lastBudgetDate", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PLBFLGREM',
    })
], BudgetLine.prototype, "hasNothingLeftToCommit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBQTYREM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BudgetLine.prototype, "remainingQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBPRIREM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BudgetLine.prototype, "remainingUnitPrice", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBAMTREM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BudgetLine.prototype, "remainingAmount", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBDATREM',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
    })
], BudgetLine.prototype, "lastEstimatedDate", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBQTYEST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BudgetLine.prototype, "lastEstimatedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBAMTEST',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BudgetLine.prototype, "lastEstimatedAmount", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBQTYREC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BudgetLine.prototype, "recordedQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PLBAMTREC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
    })
], BudgetLine.prototype, "recordedAmount", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CUR',
        columnType: 'string',
        node: () => sageX3MasterData.nodes.Currency,
    })
], BudgetLine.prototype, "currency", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ORI',
        dataType: () => sageX3ProjectManagementData.enums.budgetLineOriginDatatype,
    })
], BudgetLine.prototype, "origin", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SPLDREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], BudgetLine.prototype, "saleableProductLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMBUDLIG',
                identifier1: 'PLBDESTEX',
                identifier4: null,
            },
            control: {
                code: 'PJMBUDLIG',
                identifier1: 'PLBDESTEX',
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], BudgetLine.prototype, "longDescriptionRef", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isStored: true,
        isNullable: true,
        columnType: 'string',
        filters: {
            lookup: {
                code: 'PJMBUDLIG',
                identifier1: 'PLBCOMTEX',
                identifier4: null,
            },
            control: {
                code: 'PJMBUDLIG',
                identifier1: 'PLBCOMTEX',
                identifier4: null,
            },
        },
        node: () => sageX3ProjectManagementData.nodes.ProjectText,
    })
], BudgetLine.prototype, "longCommentRef", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], BudgetLine.prototype, "longComment", void 0);
__decorate([
    xtrem_core_1.decorators.textStreamProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CLOB',
    })
], BudgetLine.prototype, "longDescription", void 0);
exports.BudgetLine = BudgetLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'PJMBUDLIG',
        keyPropertyNames: ['project', 'budget', 'lineNumber'],
        indexes: [
            {
                orderBy: {
                    project: 1,
                    budget: 1,
                    lineNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            compositeReferences,
        }),
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], BudgetLine);
//# sourceMappingURL=budget-line.js.map