import * as sageX3MasterData from '@sage/x3-master-data';
import * as sageX3ProjectManagementData from '@sage/x3-project-management-data';
import * as sageX3System from '@sage/x3-system';
import { Node, Reference, integer, decimal, date, TextStream } from '@sage/xtrem-core';
import * as sageX3ProjectManagement from '..';
export declare class BudgetLine extends Node {
    readonly project: Reference<sageX3ProjectManagement.nodes.Project>;
    readonly budget: Reference<sageX3ProjectManagement.nodes.Budget>;
    readonly lineNumber: Promise<integer>;
    readonly costType: Reference<sageX3ProjectManagementData.nodes.CostType>;
    readonly site: Reference<sageX3System.nodes.Site | null>;
    readonly localizedDescription: Promise<string>;
    readonly unit: Reference<sageX3MasterData.nodes.UnitOfMeasure | null>;
    readonly quantity: Promise<decimal | null>;
    readonly unitPrice: Promise<decimal | null>;
    readonly isPriceForced: Promise<boolean>;
    readonly amount: Promise<decimal | null>;
    readonly lastBudgetDate: Promise<date | null>;
    readonly hasNothingLeftToCommit: Promise<boolean>;
    readonly remainingQuantity: Promise<decimal | null>;
    readonly remainingUnitPrice: Promise<decimal | null>;
    readonly remainingAmount: Promise<decimal | null>;
    readonly lastEstimatedDate: Promise<date | null>;
    readonly lastEstimatedQuantity: Promise<decimal | null>;
    readonly lastEstimatedAmount: Promise<decimal | null>;
    readonly recordedQuantity: Promise<decimal | null>;
    readonly recordedAmount: Promise<decimal | null>;
    readonly currency: Reference<sageX3MasterData.nodes.Currency>;
    readonly origin: Promise<sageX3ProjectManagementData.enums.BudgetLineOrigin | null>;
    readonly saleableProductLine: Promise<string>;
    readonly longDescriptionRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly longCommentRef: Reference<sageX3ProjectManagementData.nodes.ProjectText | null>;
    readonly longComment: Promise<TextStream>;
    readonly longDescription: Promise<TextStream>;
}
//# sourceMappingURL=budget-line.d.ts.map