"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProjectLinkExtension = void 0;
const sageX3ProjectManagementData = require("@sage/x3-project-management-data");
const sageX3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageX3ProjectManagement = require("..");
const joins = {
    referenceJoins: {
        project: {
            id: 'project',
        },
        budget: {
            project: 'project',
            code: 'budget',
        },
        task: {
            project: 'project',
            code: 'task',
        },
        financialSite: {
            code: 'financialSite',
        },
    },
};
let ProjectLinkExtension = class ProjectLinkExtension extends xtrem_core_1.NodeExtension {
};
exports.ProjectLinkExtension = ProjectLinkExtension;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'OPPNUM',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Project,
    })
], ProjectLinkExtension.prototype, "project", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Budget,
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
    })
], ProjectLinkExtension.prototype, "budget", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASCOD',
        columnType: 'string',
        node: () => sageX3ProjectManagement.nodes.Task,
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
    })
], ProjectLinkExtension.prototype, "task", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FINRSPFCY',
        columnType: 'string',
        node: () => sageX3System.nodes.Site,
    })
], ProjectLinkExtension.prototype, "financialSite", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'OPPSTATE',
        dataType: () => sageX3ProjectManagementData.enums.projectStatusDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
    })
], ProjectLinkExtension.prototype, "projectStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PBUSTATE',
        dataType: () => sageX3ProjectManagementData.enums.projectBudgetStatusDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
    })
], ProjectLinkExtension.prototype, "budgetStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TASSTATE',
        dataType: () => sageX3ProjectManagementData.enums.projectTaskStatusDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
    })
], ProjectLinkExtension.prototype, "taskStatus", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PROBIL',
        dataType: () => sageX3ProjectManagementData.enums.billingModeDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.PjmActivityCode],
    })
], ProjectLinkExtension.prototype, "billingMode", void 0);
exports.ProjectLinkExtension = ProjectLinkExtension = __decorate([
    xtrem_core_1.decorators.nodeExtension({
        extends: () => sageX3ProjectManagementData.nodes.ProjectLink,
        externalStorageManagerExtension: new xtrem_x3_gateway_1.X3StorageManagerExtension({
            joins,
        }),
    })
], ProjectLinkExtension);
//# sourceMappingURL=project-link-extension.js.map