"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getIsValidatedDefault = exports.getDefaultUnit = exports.getDefaultTimeCategory = exports.getIsNegativeTimeSpentAllowed = exports.getIsTimeEntryEmployee = exports.getIsTimeEntryAdministrator = exports.getConnectedEmployee = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const x3MasterData = require("@sage/x3-master-data");
const x3System = require("@sage/x3-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const x3ProjectManagement = require("..");
async function getConnectedEmployee(_this) {
    const employee = await _this.$.context.user;
    if (!employee) {
        throw new xtrem_core_1.BusinessRuleError('No username found for current user');
    }
    const projectUser = await _this.$.context.tryRead(x3ProjectManagement.nodes.ProjectUser, {
        employee: employee.userName,
    });
    if (!projectUser) {
        throw new xtrem_core_1.BusinessRuleError('Employee does not exist for time entry');
    }
    else {
        const isActive = await projectUser.isActiveEmployeeOnProjects;
        if (!isActive) {
            throw new xtrem_core_1.BusinessRuleError('Employee is not active on project management');
        }
    }
    return projectUser;
    //
}
exports.getConnectedEmployee = getConnectedEmployee;
async function getIsTimeEntryAdministrator(_this) {
    const connectedEmployee = await _this.connectedEmployee;
    if (!connectedEmployee) {
        return false;
    }
    return connectedEmployee.isTimeEntryAdministrator;
}
exports.getIsTimeEntryAdministrator = getIsTimeEntryAdministrator;
async function getIsTimeEntryEmployee(_this) {
    const connectedEmployee = await _this.connectedEmployee;
    if (!connectedEmployee) {
        return false;
    }
    return connectedEmployee.isTimeEntryEmployee;
}
exports.getIsTimeEntryEmployee = getIsTimeEntryEmployee;
async function getIsNegativeTimeSpentAllowed(_this) {
    const result = await x3System.nodes.UserParameterValue.readParameterValueInteger(_this.$.context, {
        code: 'PJMTIMNEG',
    });
    return typesLib.strictEq(result.value, 2);
}
exports.getIsNegativeTimeSpentAllowed = getIsNegativeTimeSpentAllowed;
async function getDefaultTimeCategory(_this) {
    const connectedEmployee = await _this.connectedEmployee;
    if (!connectedEmployee) {
        return null;
    }
    const timeCategory = await connectedEmployee.timeCategory;
    if (timeCategory) {
        return _this.$.context.read(x3ProjectManagement.nodes.TimeCategory, { code: await timeCategory.code });
    }
    return null;
}
exports.getDefaultTimeCategory = getDefaultTimeCategory;
async function getDefaultUnit(_this) {
    const connectedEmployee = await _this.connectedEmployee;
    if (!connectedEmployee) {
        return null;
    }
    const site = await connectedEmployee.site;
    if (site) {
        const result = await x3System.nodes.GeneralParametersData.readParameterValueString(_this.$.context, {
            company: '',
            site: await site.code,
            code: 'UNITWORK',
        });
        if (result.value) {
            return _this.$.context.read(x3MasterData.nodes.UnitOfMeasure, { code: result.value });
        }
    }
    else {
        const result = await x3System.nodes.GeneralParametersData.readParameterValueString(_this.$.context, {
            company: '',
            site: '',
            code: 'HOURLYUNIT',
        });
        if (result.value) {
            return _this.$.context.read(x3MasterData.nodes.UnitOfMeasure, { code: result.value });
        }
    }
    return null;
}
exports.getDefaultUnit = getDefaultUnit;
async function getIsValidatedDefault(_this) {
    const result = await x3System.nodes.UserParameterValue.readParameterValueInteger(_this.$.context, {
        code: 'PJMTIMAUTO',
    });
    return typesLib.strictEq(result.value, 2);
}
exports.getIsValidatedDefault = getIsValidatedDefault;
//# sourceMappingURL=time-entry-line.js.map